/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.connector.openai;

import com.oxygenxml.positron.api.connector.AIService;
import com.oxygenxml.positron.api.connector.ProxyProvider;
import com.oxygenxml.positron.api.connector.dto.CompletionRequest;
import com.oxygenxml.positron.api.connector.param.CheckBoxConnectorParam;
import com.oxygenxml.positron.api.connector.param.ConnectorParamBase;
import com.oxygenxml.positron.api.connector.param.KeyValueTableConnectorParam;
import com.oxygenxml.positron.api.connector.param.ModelsComboConnectorParam;
import com.oxygenxml.positron.api.connector.param.PasswordTextFieldConnectorParam;
import com.oxygenxml.positron.api.connector.param.TextFieldConnectorParam;
import com.oxygenxml.positron.connector.api.BuiltInAIConnector;
import com.oxygenxml.positron.connector.openai.OpenAIService;
import com.oxygenxml.positron.core.util.AIModelsUtil;
import com.oxygenxml.positron.utilities.AIProviderConstants;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAIConnector
extends BuiltInAIConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)OpenAIConnector.class.getName());
    public static final String CONNECTOR_ID = "open-ai-connector";

    public List<ConnectorParamBase> getParametersList() {
        ArrayList<ConnectorParamBase> params = new ArrayList<ConnectorParamBase>();
        params.add((ConnectorParamBase)new TextFieldConnectorParam("base_URL_param", TRANSLATOR.getTranslation("Base_URL") + ":", TRANSLATOR.getTranslation("OpenAI_Base_URL_Tooltip")).setDefaultValue("https://api.openai.com/"));
        params.add((ConnectorParamBase)new PasswordTextFieldConnectorParam("ai_key_param", TRANSLATOR.getTranslation("API_Key") + ":", null));
        params.add((ConnectorParamBase)new TextFieldConnectorParam("organization_param", TRANSLATOR.getTranslation("Organization_ID") + ":", TRANSLATOR.getTranslation("Organization_explanation")).setPlaceholderText(TRANSLATOR.getTranslation("OpenAI_Connector_Organization_Placeholder")));
        params.add((ConnectorParamBase)new ModelsComboConnectorParam("model_param", TRANSLATOR.getTranslation("Default_model") + ":", TRANSLATOR.getTranslation("Default_model_explanation"), () -> AIModelsUtil.getSupportedOpenAIConnectorModelsForUI()).setDefaultValue(AIProviderConstants.DEFAULT_ENGINE.getId()));
        params.add((ConnectorParamBase)new CheckBoxConnectorParam("enable_text_moderation_param", TRANSLATOR.getTranslation("Enable_text_moderation"), TRANSLATOR.getTranslation("Enable_text_moderation_explanation"), Boolean.TRUE));
        params.add((ConnectorParamBase)new CheckBoxConnectorParam("enable_speech_to_text_param", TRANSLATOR.getTranslation("Enable_speech_to_text"), TRANSLATOR.getTranslation("Enable_speech_to_text_explanation"), Boolean.TRUE));
        params.add((ConnectorParamBase)new CheckBoxConnectorParam("streaming_param", TRANSLATOR.getTranslation("Switch_Streaming_Param_Name"), TRANSLATOR.getTranslation("Switch_Streaming_Param_Description"), Boolean.TRUE));
        params.add((ConnectorParamBase)new KeyValueTableConnectorParam("extra_headers_param", TRANSLATOR.getTranslation("Extra_headers") + ":", null));
        return params;
    }

    public String getConnectorId() {
        return CONNECTOR_ID;
    }

    public String getConnectorName() {
        return "OpenAI";
    }

    public AIService createAIService(ProxyProvider proxyProvider, int timeout) {
        Map resolvedParameters = this.getResolvedParameters();
        String baseUrl = (String)resolvedParameters.get("base_URL_param");
        if (baseUrl != null) {
            try {
                URIBuilder uriBuilder = new URIBuilder(baseUrl);
                String currentPath = uriBuilder.getPath();
                if (currentPath == null || currentPath.isEmpty() || "/".equals(currentPath)) {
                    uriBuilder.setPath("/v1/");
                } else if (!currentPath.endsWith("/")) {
                    uriBuilder.setPath(currentPath + "/");
                }
                baseUrl = uriBuilder.build().toURL().toExternalForm();
            }
            catch (MalformedURLException | URISyntaxException e) {
                LOGGER.error((Throwable)e);
            }
        }
        Object enableTextModeration = resolvedParameters.get("enable_text_moderation_param");
        Object enableSpeechToText = resolvedParameters.get("enable_speech_to_text_param");
        return new OpenAIService(this.getHttpClientExtraConfigProvider(), baseUrl, (String)resolvedParameters.get("ai_key_param"), (String)resolvedParameters.get("organization_param"), (List)resolvedParameters.get("extra_headers_param"), enableTextModeration instanceof Boolean && (Boolean)enableTextModeration != false, enableSpeechToText instanceof Boolean && (Boolean)enableSpeechToText != false);
    }

    @Override
    public CompletionRequest configureCompletionRequestForBuiltInConnector(CompletionRequest request) {
        Map resolvedParameters = this.getResolvedParameters();
        if (request.getModel() == null) {
            boolean hasDefaultModel;
            Object defaultEngineModel = resolvedParameters.get("model_param");
            boolean bl = hasDefaultModel = defaultEngineModel instanceof String && !((String)defaultEngineModel).isEmpty() && !"<Default>".equals(defaultEngineModel);
            if (hasDefaultModel) {
                request.setModel((String)defaultEngineModel);
            } else {
                request.setModel(AIProviderConstants.DEFAULT_ENGINE.getId());
            }
        }
        return request;
    }
}

