/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.connector.openai;

import com.oxygenxml.positron.api.connector.AIService;
import com.oxygenxml.positron.api.connector.ProxyProvider;
import com.oxygenxml.positron.api.connector.dto.CompletionRequest;
import com.oxygenxml.positron.api.connector.param.CheckBoxConnectorParam;
import com.oxygenxml.positron.api.connector.param.ConnectorParamBase;
import com.oxygenxml.positron.api.connector.param.KeyValueTableConnectorParam;
import com.oxygenxml.positron.api.connector.param.PasswordTextFieldConnectorParam;
import com.oxygenxml.positron.api.connector.param.TextFieldConnectorParam;
import com.oxygenxml.positron.connector.api.BuiltInAIConnector;
import com.oxygenxml.positron.connector.auth.OAuthCodeFlowEnabled;
import com.oxygenxml.positron.connector.auth.OAuthCodeFlowHelper;
import com.oxygenxml.positron.connector.openai.MSOpenAIService;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.utilities.AIRequestUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MSOpenAIConnector
extends BuiltInAIConnector
implements OAuthCodeFlowEnabled {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)MSOpenAIConnector.class.getName());
    private OAuthCodeFlowHelper oauthCodeFlowHelper;
    public static final String CONNECTOR_ID = "ms-azure-open-ai-connector";
    private static final String MS_OPEN_AI_BASE_LINK = "https://docs-test-001.openai.azure.com/";
    private static final String ENDPOINT = "{0}/openai/deployments/{1}/";
    private static final Translator TRANSLATOR = Translator.getInstance();

    public String getConnectorId() {
        return CONNECTOR_ID;
    }

    public List<ConnectorParamBase> getParametersList() {
        ArrayList<ConnectorParamBase> params = new ArrayList<ConnectorParamBase>();
        String baseUrlExample = TRANSLATOR.getTranslation("Short_Example") + " https://docs-test-001.openai.azure.com/";
        params.add((ConnectorParamBase)new TextFieldConnectorParam("base_URL_param", TRANSLATOR.getTranslation("Base_URL") + ":", TRANSLATOR.getTranslation("MS_Azure_Base_URL_Tooltip")).setPlaceholderText(baseUrlExample));
        params.add((ConnectorParamBase)new TextFieldConnectorParam("deployment_param", TRANSLATOR.getTranslation("Deployment") + ":", TRANSLATOR.getTranslation("Deployment_explanation")));
        StringBuilder apiKeyExtraInfo = new StringBuilder().append(TRANSLATOR.getTranslation("MS_Azure_Connecion_Info_Toolip")).append("\n\n");
        if (this.oauthCodeFlowHelper != null) {
            apiKeyExtraInfo.append(TRANSLATOR.getTranslation("MS_Azure_Authorization_Code_Flow_Environment_Variables")).append("\n").append("    - AZURE_OAUTH_TENANT_ID\n").append("    - AZURE_OAUTH_CLIENT_ID\n").append("    - AZURE_OAUTH_REDIRECT_URI\n").append(TRANSLATOR.getTranslation("MS_Azure_Authorization_Code_Flow_Info")).append("\n").append("\n");
        }
        apiKeyExtraInfo.append(TRANSLATOR.getTranslation("MS_Azure_Connecion_Client_Secret")).append("\n").append("    - AZURE_CLIENT_ID\n").append("    - AZURE_CLIENT_SECRET\n").append("    - AZURE_TENANT_ID\n").append("\n").append(TRANSLATOR.getTranslation("MS_Azure_Connecion_Client_Certificate")).append("\n").append("    - AZURE_CLIENT_ID\n").append("    - AZURE_CLIENT_CERTIFICATE_PATH\n").append("    - AZURE_CLIENT_CERTIFICATE_PASSWORD\n").append("    - AZURE_TENANT_ID");
        params.add((ConnectorParamBase)new PasswordTextFieldConnectorParam("ai_key_param", TRANSLATOR.getTranslation("API_Key") + ":", null).setInfo(TRANSLATOR.getTranslation("MS_Azure_Connecion_Info_Toolip")).setExtraInfo(apiKeyExtraInfo.toString()));
        params.add((ConnectorParamBase)new CheckBoxConnectorParam("streaming_param", TRANSLATOR.getTranslation("Switch_Streaming_Param_Name"), TRANSLATOR.getTranslation("Switch_Streaming_Param_Description"), Boolean.TRUE));
        params.add((ConnectorParamBase)new KeyValueTableConnectorParam("extra_headers_param", TRANSLATOR.getTranslation("Extra_headers") + ":", null));
        params.add((ConnectorParamBase)new TextFieldConnectorParam("ms_azure_speech_region", TRANSLATOR.getTranslation("Speech_service_region") + ":", TRANSLATOR.getTranslation("Speech_service_region_description")));
        params.add((ConnectorParamBase)new PasswordTextFieldConnectorParam("ms_azure_speech_subscription_key", TRANSLATOR.getTranslation("Speech_service_key") + ":", TRANSLATOR.getTranslation("Speech_service_key_description")));
        return params;
    }

    public String getConnectorName() {
        return "MS Azure OpenAI";
    }

    @Override
    public void setOAuthCodeFlowHelper(OAuthCodeFlowHelper oauthCodeFlowHelper) {
        this.oauthCodeFlowHelper = oauthCodeFlowHelper;
    }

    public AIService createAIService(ProxyProvider proxyProvider, int timeout) {
        Map resolvedParameters = this.getResolvedParameters();
        String endpoint = this.computeServiceURLAdress();
        String apiKey = (String)resolvedParameters.get("ai_key_param");
        String speechToTextRegion = (String)resolvedParameters.get("ms_azure_speech_region");
        String speechToTextKey = (String)resolvedParameters.get("ms_azure_speech_subscription_key");
        MSOpenAIService service = new MSOpenAIService(this.getHttpClientExtraConfigProvider(), endpoint, apiKey, (List)resolvedParameters.get("extra_headers_param"), speechToTextRegion, speechToTextKey, this.oauthCodeFlowHelper);
        return service;
    }

    String computeServiceURLAdress() {
        Map resolvedParameters = this.getResolvedParameters();
        String endpoint = (String)resolvedParameters.get("base_URL_param");
        try {
            new URL(endpoint);
        }
        catch (MalformedURLException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)e, (Throwable)e);
            }
            String errorMessage = Optional.ofNullable(endpoint).filter(t -> !t.isBlank()).map(t -> MessageFormat.format(TRANSLATOR.getTranslation("Invalid_ai_service_address"), t)).orElseGet(() -> TRANSLATOR.getTranslation("Ai_service_address_missing"));
            throw new IllegalArgumentException(errorMessage);
        }
        if (endpoint.endsWith("\\") || endpoint.endsWith("/")) {
            endpoint = endpoint.substring(0, endpoint.length() - 1);
        }
        String deployment = this.getDeploymentFromParams();
        return MessageFormat.format(ENDPOINT, endpoint, deployment);
    }

    private String getDeploymentFromParams() {
        Map resolvedParameters = this.getResolvedParameters();
        return (String)resolvedParameters.get("deployment_param");
    }

    @Override
    public CompletionRequest configureCompletionRequestForBuiltInConnector(CompletionRequest request) {
        request.setModel(null);
        request = AIRequestUtil.processRequestTakingAccountOfReasoningDeployments((CompletionRequest)request, (String)this.getDeploymentFromParams());
        return request;
    }
}

