/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.connector.openai;

import com.oxygenxml.positron.api.connector.AIConnectionException;
import com.oxygenxml.positron.connector.openai.IHeadersProvider;
import java.io.IOException;
import java.util.Map;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class HeadersQueryInterceptor
implements Interceptor {
    private final IHeadersProvider headersProvider;
    private Map<String, String> queryParams;

    public HeadersQueryInterceptor(IHeadersProvider headersProvider, Map<String, String> queryParams) {
        this.headersProvider = headersProvider;
        this.queryParams = queryParams;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        HttpUrl.Builder urlBuilder = chain.request().url().newBuilder();
        if (this.queryParams != null) {
            for (Map.Entry<String, String> entry : this.queryParams.entrySet()) {
                urlBuilder = urlBuilder.addQueryParameter(entry.getKey(), entry.getValue());
            }
        }
        Request.Builder newBuilder = chain.request().newBuilder().url(urlBuilder.build());
        if (this.headersProvider != null) {
            Map<String, String> headers = this.headersProvider.getHeaders();
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                newBuilder = newBuilder.header(entry.getKey(), entry.getValue());
            }
        }
        try {
            return chain.proceed(newBuilder.build());
        }
        catch (IOException e) {
            throw new IOException(e.getMessage(), new AIConnectionException(e.getMessage(), "500", (Exception)e));
        }
    }
}

