/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.connector.grok;

import com.oxygenxml.positron.api.connector.AIService;
import com.oxygenxml.positron.api.connector.ProxyProvider;
import com.oxygenxml.positron.api.connector.dto.CompletionRequest;
import com.oxygenxml.positron.api.connector.param.ConnectorParamBase;
import com.oxygenxml.positron.api.connector.param.ModelsComboConnectorParam;
import com.oxygenxml.positron.api.connector.param.PasswordTextFieldConnectorParam;
import com.oxygenxml.positron.api.connector.param.TextFieldConnectorParam;
import com.oxygenxml.positron.connector.ConnectorUtil;
import com.oxygenxml.positron.connector.api.BuiltInAIConnector;
import com.oxygenxml.positron.connector.openai.OpenAIService;
import com.oxygenxml.positron.core.util.AIModelsUtil;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GrokConnector
extends BuiltInAIConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)GrokConnector.class.getName());
    private static final String DEFAULT_MODEL = "grok-3";
    public static final String CONNECTOR_ID = "grok-connector";
    private static final String NAME = "xAI Grok";
    private static final String BASE_URL = "https://api.x.ai";

    public List<ConnectorParamBase> getParametersList() {
        ArrayList<ConnectorParamBase> params = new ArrayList<ConnectorParamBase>();
        params.add((ConnectorParamBase)new TextFieldConnectorParam("base_URL_param", TRANSLATOR.getTranslation("Base_URL") + ":", TRANSLATOR.getTranslation("Grok_Base_URL_Tooltip")).setDefaultValue(BASE_URL));
        params.add((ConnectorParamBase)new PasswordTextFieldConnectorParam("ai_key_param", TRANSLATOR.getTranslation("API_Key") + ":", null));
        params.add((ConnectorParamBase)new ModelsComboConnectorParam("model_param", TRANSLATOR.getTranslation("Default_model") + ":", null, () -> AIModelsUtil.getSupportedNonOpenAIConnectorModelsForUI("xAI")).setDefaultValue(DEFAULT_MODEL));
        return params;
    }

    public String getConnectorId() {
        return CONNECTOR_ID;
    }

    public String getConnectorName() {
        return NAME;
    }

    public String getModelParameterId() {
        return "model_param";
    }

    @Override
    public CompletionRequest configureCompletionRequestForBuiltInConnector(CompletionRequest request) {
        if (request.getModel() == null || request.getModel().isEmpty()) {
            ConnectorUtil.setModelFromResolvedParamsInRequest(request, this.getResolvedParameters(), this.getModelParameterId());
        }
        return request;
    }

    public AIService createAIService(ProxyProvider proxyProvider, int timeout) {
        Map resolvedParameters = this.getResolvedParameters();
        String baseUrl = (String)resolvedParameters.get("base_URL_param");
        if (baseUrl != null) {
            try {
                URIBuilder uriBuilder = new URIBuilder(baseUrl);
                String currentPath = uriBuilder.getPath();
                if (currentPath == null || currentPath.isEmpty() || "/".equals(currentPath)) {
                    uriBuilder.setPath("/v1/");
                    baseUrl = uriBuilder.build().toURL().toExternalForm();
                }
            }
            catch (MalformedURLException | URISyntaxException e) {
                LOGGER.error((Throwable)e);
            }
        }
        return new OpenAIService(this.getHttpClientExtraConfigProvider(), baseUrl, (String)resolvedParameters.get("ai_key_param"), null, (List)resolvedParameters.get("extra_headers_param"), false, false);
    }
}

