/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.connector.gemini;

import com.oxygenxml.positron.api.connector.AIConnectionException;
import com.oxygenxml.positron.api.connector.AIService;
import com.oxygenxml.positron.api.connector.dto.CompletionChoice;
import com.oxygenxml.positron.api.connector.dto.CompletionChunk;
import com.oxygenxml.positron.api.connector.dto.CompletionMessage;
import com.oxygenxml.positron.api.connector.dto.CompletionRequest;
import com.oxygenxml.positron.api.connector.dto.CompletionResponse;
import com.oxygenxml.positron.api.connector.dto.CompletionToolCall;
import com.oxygenxml.positron.api.connector.dto.ModerationRequest;
import com.oxygenxml.positron.connector.api.HttpClientExtraConfigProvider;
import com.oxygenxml.positron.connector.gemini.GeminiAPIProvider;
import com.oxygenxml.positron.connector.openai.HeadersQueryInterceptor;
import com.oxygenxml.positron.connector.openai.IHeadersProvider;
import com.oxygenxml.positron.connector.openai.RequestLoggingInterceptor;
import com.oxygenxml.positron.connector.util.ReactiveUtil;
import io.reactivex.rxjava3.core.Flowable;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Flow;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.reactivestreams.FlowAdapters;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeminiService
implements AIService {
    private static final Logger log = LoggerFactory.getLogger(GeminiService.class);
    protected GeminiAPIProvider apiProvider;
    private int timeout;

    public GeminiService(HttpClientExtraConfigProvider httpClientExtraConfigProvider, String baseUrl, String apiKey, int timeout) {
        this.timeout = timeout;
        this.apiProvider = new GeminiAPIProvider(httpClientExtraConfigProvider, baseUrl, apiKey){

            @Override
            public OkHttpClient createHttpClient(HttpClientExtraConfigProvider httpClientExtraConfigProvider, String baseUrl, String token) {
                return GeminiService.this.createServiceHttpClient(httpClientExtraConfigProvider, baseUrl, token);
            }
        };
    }

    public Flow.Publisher<CompletionChunk> getCompletionFlux(CompletionRequest completionRequest) {
        Flowable flowable = ReactiveUtil.stream(this.apiProvider.getGeminiApi().createChatCompletionStream(completionRequest), CompletionChunk.class);
        int indexOfResponseMessage = completionRequest.getMessages().size() + 1;
        flowable = flowable.map(chunk -> {
            GeminiService.enrichToolCallsWithIds(indexOfResponseMessage, (CompletionChoice)chunk.getChoices().get(0));
            return chunk;
        });
        return FlowAdapters.toFlowPublisher((Publisher)flowable);
    }

    private static void enrichToolCallsWithIds(int indexOfResponseMessage, CompletionChoice completionChoice) {
        CompletionMessage message;
        List toolCalls;
        if (completionChoice != null && completionChoice.getMessage() != null && (toolCalls = (message = completionChoice.getMessage()).getToolCalls()) != null) {
            int nuOfToolCalls = toolCalls.size();
            for (int i = 0; i < nuOfToolCalls; ++i) {
                String toolId = ((CompletionToolCall)toolCalls.get(i)).getId();
                if (toolId != null && !toolId.isEmpty()) continue;
                ((CompletionToolCall)toolCalls.get(i)).setIndex(Integer.valueOf(i));
                ((CompletionToolCall)toolCalls.get(i)).setId("tool-call-" + indexOfResponseMessage + "-" + i);
            }
        }
    }

    public CompletionResponse getCompletion(CompletionRequest completionRequest) throws AIConnectionException {
        CompletionResponse completionResponse = ReactiveUtil.execute(this.apiProvider.getGeminiApi().createChatCompletion(completionRequest));
        GeminiService.enrichToolCallsWithIds(completionRequest.getMessages().size() + 1, (CompletionChoice)completionResponse.getChoices().get(0));
        return completionResponse;
    }

    public boolean isRequiringApplyingModeration() {
        return false;
    }

    public boolean applyModeration(ModerationRequest moderationRequest) throws AIConnectionException {
        return false;
    }

    protected OkHttpClient createServiceHttpClient(HttpClientExtraConfigProvider httpClientExtraConfigProvider, String baseUrl, String token) {
        HashMap<String, CallSite> headers = new HashMap<String, CallSite>();
        if (token != null && !token.isBlank()) {
            headers.put("Authorization", (CallSite)((Object)("Bearer " + token)));
        }
        return this.createHttpClient(httpClientExtraConfigProvider, baseUrl, () -> headers, null);
    }

    protected OkHttpClient createHttpClient(HttpClientExtraConfigProvider httpClientExtraConfigProvider, String baseUrl, IHeadersProvider headersProvider, Map<String, String> queryParams) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder = httpClientExtraConfigProvider.configureHttpClientAccordingToPreferences(builder, baseUrl);
        builder = builder.addInterceptor((Interceptor)new HeadersQueryInterceptor(() -> {
            Map<String, String> headers = headersProvider.getHeaders();
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    headers.put(entry.getKey(), entry.getValue());
                }
            }
            return headers;
        }, queryParams));
        if (log.isDebugEnabled()) {
            builder = builder.addInterceptor((Interceptor)new RequestLoggingInterceptor(log));
        }
        return builder.connectionPool(new ConnectionPool(5, 1L, TimeUnit.SECONDS)).readTimeout((long)this.timeout, TimeUnit.MILLISECONDS).build();
    }
}

