/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.connector.gemini;

import com.oxygenxml.positron.api.connector.AIService;
import com.oxygenxml.positron.api.connector.ProxyProvider;
import com.oxygenxml.positron.api.connector.dto.CompletionRequest;
import com.oxygenxml.positron.api.connector.param.ConnectorParamBase;
import com.oxygenxml.positron.api.connector.param.ModelsComboConnectorParam;
import com.oxygenxml.positron.api.connector.param.PasswordTextFieldConnectorParam;
import com.oxygenxml.positron.api.connector.param.TextFieldConnectorParam;
import com.oxygenxml.positron.connector.ConnectorUtil;
import com.oxygenxml.positron.connector.api.BuiltInAIConnector;
import com.oxygenxml.positron.connector.gemini.GeminiService;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.core.util.AIModelsUtil;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GeminiConnector
extends BuiltInAIConnector {
    private static final String VERTEX_GOOGLE_MODEL_PREFIX = "google/";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)GeminiConnector.class.getName());
    private static final String DEFAULT_MODEL = "gemini-2.5-flash";
    public static final String CONNECTOR_ID = "google-gemini-ai-connector";

    public List<ConnectorParamBase> getParametersList() {
        ArrayList<ConnectorParamBase> params = new ArrayList<ConnectorParamBase>();
        params.add((ConnectorParamBase)new TextFieldConnectorParam("base_URL_param", TRANSLATOR.getTranslation("Base_URL") + ":", TRANSLATOR.getTranslation("Gemini_Base_URL_Tooltip")).setDefaultValue("https://generativelanguage.googleapis.com/"));
        params.add((ConnectorParamBase)new PasswordTextFieldConnectorParam("ai_key_param", TRANSLATOR.getTranslation("API_Key") + ":", null));
        params.add((ConnectorParamBase)new ModelsComboConnectorParam("model_param", TRANSLATOR.getTranslation("Default_model") + ":", null, () -> AIModelsUtil.getSupportedNonOpenAIConnectorModelsForUI("vertex")).setDefaultValue(DEFAULT_MODEL));
        return params;
    }

    public String getConnectorId() {
        return CONNECTOR_ID;
    }

    public String getConnectorName() {
        return "Google Gemini";
    }

    public AIService createAIService(ProxyProvider proxyProvider, int timeout) {
        Map resolvedParameters = this.getResolvedParameters();
        String baseUrl = (String)resolvedParameters.get("base_URL_param");
        if (baseUrl != null) {
            try {
                URIBuilder uriBuilder = new URIBuilder(baseUrl);
                String currentPath = uriBuilder.getPath();
                if (currentPath == null || currentPath.isEmpty() || "/".equals(currentPath)) {
                    uriBuilder.setPath("/v1beta/");
                    baseUrl = uriBuilder.build().toURL().toExternalForm();
                }
            }
            catch (MalformedURLException | URISyntaxException e) {
                LOGGER.error((Throwable)e);
            }
        }
        return new GeminiService(this.getHttpClientExtraConfigProvider(), baseUrl, (String)resolvedParameters.get("ai_key_param"), timeout);
    }

    @Override
    public CompletionRequest configureCompletionRequest(CompletionRequest request) {
        CompletionRequest completionRequest = super.configureCompletionRequest(request);
        if (completionRequest.getModel() != null && completionRequest.getModel().startsWith(VERTEX_GOOGLE_MODEL_PREFIX)) {
            completionRequest.setModel(completionRequest.getModel().replace(VERTEX_GOOGLE_MODEL_PREFIX, ""));
        }
        return completionRequest;
    }

    @Override
    public CompletionRequest configureCompletionRequestForBuiltInConnector(CompletionRequest request) {
        if (request.getModel() == null || request.getModel().isEmpty()) {
            ConnectorUtil.setModelFromResolvedParamsInRequest(request, this.getResolvedParameters(), "model_param");
        }
        return request;
    }

    public String getDisclaimer() {
        return Translator.getInstance().getTranslation("Google_Gemini_Disclaimer");
    }
}

