/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.connector.auth;

import com.oxygenxml.positron.connector.auth.OAuthAuthorizationListener;
import com.oxygenxml.positron.connector.auth.RequestCancelledException;
import com.oxygenxml.positron.core.auth.BrowserOpener;
import com.oxygenxml.positron.core.plugin.Translator;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.io.IOUtil;
import ro.sync.basic.util.URLUtil;

public class OAuthAuthorizationCodeManager {
    private static final Logger log = LoggerFactory.getLogger(OAuthAuthorizationCodeManager.class);
    private static final int TIME_OUT_MS = 600000;
    private static final Pattern AUTH_CODE_REGEX_PATTERN = Pattern.compile("(\\?|\\&)code=([^\\&\\s]+)(\\&|\\s)");
    private static final int AUTH_CODE_REGEX_GROUP_INDEX = 2;
    private static final Pattern AUTH_ERROR_REGEX_PATTERN = Pattern.compile("(\\?|\\&)error_description=([^\\&\\s]+)(\\&|\\s)");
    private static final int ERROR_MESSAGE_REGEX_GROUP_INDEX = 2;
    private static final String HTTP_SUCCESS_RESPONSE = "HTTP/1.1 200 OK\r\nContent-Length: {0}\r\n\r\n{1}";
    private static final String HTTP_ERROR_RESPONSE_BODY_PATTERN = "<html>\r\n<title>Error</title>\r\n<body><b style='color:red'>{0}</b>\r\n</body>\r\n</html>";
    private static final String HTTP_ERROR_RESPONSE = "HTTP/1.1 400 Bad Request\r\nContent-Length: {0}\r\n\r\n{1}";
    private static final Translator TRANSLATOR = Translator.getInstance();
    private BrowserOpener browserOpener;
    private final ExecutorService executorService;
    private ServerSocket serverSocket;
    private final AtomicBoolean authorizationInProgress = new AtomicBoolean(false);
    private OAuthAuthorizationListener listener;
    private String authorizationUrl;
    private String redirectUri;
    private CompletableFuture<String> authorizationFuture;
    private boolean isCancelled;

    public OAuthAuthorizationCodeManager() {
        this.browserOpener = new BrowserOpener();
        this.executorService = Executors.newSingleThreadExecutor();
    }

    public void setBrowserOpener(BrowserOpener browserOpener) {
        this.browserOpener = browserOpener;
    }

    public CompletableFuture<String> prepareAuthorization(String authorizationUrl, String redirectUri, OAuthAuthorizationListener listener) {
        if (!this.authorizationInProgress.compareAndSet(false, true)) {
            CompletableFuture<String> future = new CompletableFuture<String>();
            future.completeExceptionally(new IllegalStateException(TRANSLATOR.getTranslation("OAuth_authorization_already_in_progress")));
            return future;
        }
        this.listener = listener;
        this.authorizationUrl = authorizationUrl;
        this.redirectUri = redirectUri;
        this.authorizationFuture = new CompletableFuture();
        return this.authorizationFuture;
    }

    public void startBrowserAuthorization() {
        this.isCancelled = false;
        if (!this.authorizationInProgress.get() || this.authorizationUrl == null || this.redirectUri == null) {
            if (this.listener != null) {
                this.listener.onAuthorizationError(TRANSLATOR.getTranslation("OAuth_authorization_not_initialized"));
            }
            if (this.authorizationFuture != null && !this.authorizationFuture.isDone()) {
                this.authorizationFuture.completeExceptionally(new IllegalStateException(TRANSLATOR.getTranslation("OAuth_authorization_not_prepared")));
            }
            return;
        }
        if (this.listener != null) {
            this.listener.onAuthorizationStarted(TRANSLATOR.getTranslation("OAuth_authorization_starting"));
        }
        this.executorService.submit(() -> {
            try {
                this.executeAuthorizationFlow(this.authorizationUrl, this.redirectUri, this.authorizationFuture);
            }
            finally {
                this.authorizationInProgress.set(false);
            }
        });
    }

    public void cancelAuthorization() {
        this.authorizationFuture.complete(null);
        this.authorizationInProgress.set(false);
        this.isCancelled = true;
        if (this.serverSocket != null && !this.serverSocket.isClosed()) {
            try {
                this.serverSocket.close();
            }
            catch (IOException e) {
                log.debug("Error closing server socket during cancellation", (Throwable)e);
            }
        }
        if (this.listener != null) {
            this.listener.onAuthorizationCancelled(TRANSLATOR.getTranslation("OAuth_authorization_cancelled"));
        }
    }

    public void shutdown() {
        this.cancelAuthorization();
        this.executorService.shutdown();
    }

    private void executeAuthorizationFlow(String authorizationUrl, String redirectUri, CompletableFuture<String> authorizationFuture) {
        try {
            int port = OAuthAuthorizationCodeManager.extractPortFromRedirectUri(redirectUri);
            this.notifyProgress(TRANSLATOR.getTranslation("OAuth_validating_configuration"));
            if (!OAuthAuthorizationCodeManager.isPortAvailable(port)) {
                String errorMsg = MessageFormat.format(TRANSLATOR.getTranslation("OAuth_port_unavailable"), port, redirectUri);
                log.warn("Port validation failed: {}", (Object)errorMsg);
                if (this.listener != null) {
                    this.listener.onAuthorizationError(errorMsg);
                }
                authorizationFuture.completeExceptionally(new IOException(errorMsg));
                return;
            }
            this.serverSocket = new ServerSocket(port);
            this.serverSocket.setSoTimeout(600000);
            this.notifyProgress(TRANSLATOR.getTranslation("OAuth_opening_browser"));
            this.browserOpener.openWebpage(authorizationUrl);
            this.notifyProgress(TRANSLATOR.getTranslation("OAuth_waiting_for_authentication"));
            this.waitForCallback(authorizationFuture);
        }
        catch (Exception e) {
            log.error("OAuth authorization failed", (Throwable)e);
            String userMessage = MessageFormat.format(TRANSLATOR.getTranslation("OAuth_authentication_failed"), e.getMessage());
            if (this.listener != null) {
                this.listener.onAuthorizationError(userMessage);
            }
            authorizationFuture.completeExceptionally(e);
        }
    }

    private static int extractPortFromRedirectUri(String redirectUri) {
        URL url = URLUtil.convertToURL((String)redirectUri);
        int port = -1;
        if (url != null) {
            port = url.getPort();
        }
        if (port == -1) {
            throw new IllegalArgumentException("Cannot determine port from redirectUri: " + redirectUri);
        }
        if (port < 1 || port > 65535) {
            throw new IllegalArgumentException("Port number must be between 1 and 65535, got: " + port);
        }
        return port;
    }

    private static boolean isPortAvailable(int port) {
        boolean bl;
        ServerSocket socket = new ServerSocket(port);
        try {
            socket.setReuseAddress(true);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                log.debug("Port {} is not available: {}", (Object)port, (Object)e.getMessage());
                return false;
            }
        }
        socket.close();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForCallback(CompletableFuture<String> authorizationFuture) {
        block26: {
            Socket clientSocket = null;
            try {
                this.checkIsCancelled();
                clientSocket = this.serverSocket.accept();
                clientSocket.setSoTimeout(600000);
                this.checkIsCancelled();
                BufferedReader reader = new BufferedReader(new InputStreamReader(clientSocket.getInputStream(), StandardCharsets.UTF_8));
                String line = reader.readLine();
                String authorizationCode = OAuthAuthorizationCodeManager.extractAuthorizationCode(line);
                URL resource = this.getClass().getResource("/connector-user-based-authentication-complete.html");
                String htmlContent = IOUtil.readURL((URL)resource, (String)"UTF-8");
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(clientSocket.getOutputStream(), StandardCharsets.UTF_8));
                if (authorizationCode != null) {
                    String response = MessageFormat.format(HTTP_SUCCESS_RESPONSE, String.valueOf(htmlContent.getBytes(StandardCharsets.UTF_8).length), htmlContent);
                    writer.write(response);
                    ((Writer)writer).flush();
                    if (this.listener != null) {
                        this.listener.onAuthorizationSuccess(TRANSLATOR.getTranslation("OAuth_authorization_successful"));
                    }
                    authorizationFuture.complete(authorizationCode);
                    break block26;
                }
                String errorMessage = OAuthAuthorizationCodeManager.extractErrorMessage(line);
                writer.write(OAuthAuthorizationCodeManager.getErrorResponse(errorMessage));
                ((Writer)writer).flush();
                throw new IOException(errorMessage);
            }
            catch (SocketException e) {
                if (log.isDebugEnabled()) {
                    log.debug("Socket closed: " + e.getMessage(), (Throwable)e);
                }
            }
            catch (IOException e) {
                if (!this.serverSocket.isClosed() && this.authorizationInProgress.get()) {
                    log.error("Error waiting for OAuth callback", (Throwable)e);
                    if (this.listener != null) {
                        this.listener.onAuthorizationError(e.getMessage());
                    }
                    authorizationFuture.completeExceptionally(e);
                }
            }
            catch (RequestCancelledException e) {
                if (log.isDebugEnabled()) {
                    log.debug("Operation cancelled!", (Throwable)e);
                }
            }
            finally {
                try {
                    this.serverSocket.close();
                    if (clientSocket != null) {
                        clientSocket.shutdownInput();
                        clientSocket.shutdownOutput();
                        clientSocket.close();
                    }
                }
                catch (IOException e) {}
            }
        }
    }

    private static String getErrorResponse(String errMessage) {
        String errorBody = MessageFormat.format(HTTP_ERROR_RESPONSE_BODY_PATTERN, errMessage);
        return MessageFormat.format(HTTP_ERROR_RESPONSE, errorBody.length(), errorBody);
    }

    private void checkIsCancelled() throws RequestCancelledException {
        if (this.isCancelled) {
            throw new RequestCancelledException();
        }
    }

    private static String extractAuthorizationCode(String requestLine) {
        String code;
        Matcher matcher;
        String authCode = null;
        if (requestLine != null && (matcher = AUTH_CODE_REGEX_PATTERN.matcher(requestLine)).find() && (code = matcher.group(2)) != null && !code.isEmpty()) {
            authCode = OAuthAuthorizationCodeManager.decodeUrlEncoded(code);
        }
        return authCode;
    }

    private static String decodeUrlEncoded(String value) {
        block2: {
            try {
                value = URLDecoder.decode(value, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                if (!log.isDebugEnabled()) break block2;
                log.debug("Could not decode application/x-www-form-urlencoded value: " + value + " -- " + e.getMessage(), (Throwable)e);
            }
        }
        return value;
    }

    private static String extractErrorMessage(String requestLine) {
        String errorMessageGroup;
        Matcher errMatcher;
        String errorMessage = MessageFormat.format(TRANSLATOR.getTranslation("OAuth_authorization_code_extract_error"), requestLine);
        if (requestLine != null && (errMatcher = AUTH_ERROR_REGEX_PATTERN.matcher(requestLine)).find() && (errorMessageGroup = errMatcher.group(2)) != null) {
            errorMessage = OAuthAuthorizationCodeManager.decodeUrlEncoded(errorMessageGroup);
        }
        return errorMessage;
    }

    private void notifyProgress(String message) {
        if (this.listener != null) {
            this.listener.onAuthorizationProgress(message);
        }
    }
}

