/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.connector.api.claude;

import com.oxygenxml.positron.api.connector.AIService;
import com.oxygenxml.positron.api.connector.ProxyProvider;
import com.oxygenxml.positron.api.connector.dto.CompletionRequest;
import com.oxygenxml.positron.api.connector.param.CheckBoxConnectorParam;
import com.oxygenxml.positron.api.connector.param.ConnectorParamBase;
import com.oxygenxml.positron.api.connector.param.KeyValueTableConnectorParam;
import com.oxygenxml.positron.api.connector.param.ModelsComboConnectorParam;
import com.oxygenxml.positron.api.connector.param.PasswordTextFieldConnectorParam;
import com.oxygenxml.positron.api.connector.param.TextFieldConnectorParam;
import com.oxygenxml.positron.connector.ConnectorUtil;
import com.oxygenxml.positron.connector.api.BuiltInAIConnector;
import com.oxygenxml.positron.connector.api.claude.ClaudeService;
import com.oxygenxml.positron.core.util.AIModelsUtil;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClaudeConnector
extends BuiltInAIConnector {
    private static final String DEFAULT_MODEL = "claude-sonnet-4-20250514";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ClaudeConnector.class.getName());
    public static final String CONNECTOR_ID = "claude-ai-connector";
    private static final String CLAUDE_BASE_LINK = "https://api.anthropic.com/";

    public String getConnectorId() {
        return CONNECTOR_ID;
    }

    public List<ConnectorParamBase> getParametersList() {
        ArrayList<ConnectorParamBase> params = new ArrayList<ConnectorParamBase>();
        String baseUrlExample = TRANSLATOR.getTranslation("Short_Example") + " claude-ai-connector";
        params.add((ConnectorParamBase)new TextFieldConnectorParam("base_URL_param", TRANSLATOR.getTranslation("Base_URL") + ":", TRANSLATOR.getTranslation("Claude_Base_URL_Tooltip")).setPlaceholderText(baseUrlExample).setDefaultValue(CLAUDE_BASE_LINK));
        params.add((ConnectorParamBase)new PasswordTextFieldConnectorParam("ai_key_param", TRANSLATOR.getTranslation("API_Key") + ":", null));
        params.add((ConnectorParamBase)new ModelsComboConnectorParam("model_param", TRANSLATOR.getTranslation("Default_model") + ":", null, () -> AIModelsUtil.getSupportedNonOpenAIConnectorModelsForUI("claude")).setDefaultValue(DEFAULT_MODEL));
        params.add((ConnectorParamBase)new CheckBoxConnectorParam("streaming_param", TRANSLATOR.getTranslation("Switch_Streaming_Param_Name"), TRANSLATOR.getTranslation("Switch_Streaming_Param_Description"), Boolean.TRUE));
        params.add((ConnectorParamBase)new KeyValueTableConnectorParam("extra_headers_param", TRANSLATOR.getTranslation("Extra_headers") + ":", null));
        return params;
    }

    public String getConnectorName() {
        return "Claude";
    }

    public AIService createAIService(ProxyProvider proxyProvider, int timeout) {
        Map resolvedParameters = this.getResolvedParameters();
        String endpoint = ClaudeConnector.computeServiceURLAdress(resolvedParameters);
        return new ClaudeService(this.getHttpClientExtraConfigProvider(), endpoint, (String)resolvedParameters.get("ai_key_param"), (List)resolvedParameters.get("extra_headers_param"));
    }

    protected static String computeServiceURLAdress(Map<String, Object> resolvedParameters) {
        String endpoint = (String)resolvedParameters.get("base_URL_param");
        if (endpoint.trim().isEmpty()) {
            throw new IllegalArgumentException(TRANSLATOR.getTranslation("Ai_service_address_missing"));
        }
        try {
            URIBuilder uriBuilder = new URIBuilder(endpoint);
            String currentPath = uriBuilder.getPath();
            if (!(currentPath == null || currentPath.isEmpty() || currentPath.endsWith("/") || currentPath.endsWith("\\"))) {
                uriBuilder.setPath(currentPath + "/");
                endpoint = uriBuilder.build().toURL().toExternalForm();
            }
        }
        catch (MalformedURLException | URISyntaxException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)e, (Throwable)e);
            }
            throw new IllegalArgumentException(MessageFormat.format(TRANSLATOR.getTranslation("Invalid_ai_service_address"), endpoint));
        }
        return endpoint;
    }

    @Override
    public CompletionRequest configureCompletionRequestForBuiltInConnector(CompletionRequest request) {
        if (request.getModel() == null || request.getModel().isEmpty()) {
            ConnectorUtil.setModelFromResolvedParamsInRequest(request, this.getResolvedParameters(), "model_param");
        }
        return request;
    }
}

