/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.connector.api.claude;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.oxygenxml.positron.connector.api.HttpClientExtraConfigProvider;
import com.oxygenxml.positron.connector.api.claude.ClaudeApi;
import com.oxygenxml.positron.utilities.AIRequestUtil;
import okhttp3.OkHttpClient;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava3.RxJava3CallAdapterFactory;
import retrofit2.converter.jackson.JacksonConverterFactory;

public abstract class ClaudeAPIProvider {
    private ClaudeApi api = null;
    private HttpClientExtraConfigProvider httpClientExtraConfigProvider;
    private String baseUrl;
    private String apiKey;

    public ClaudeAPIProvider(HttpClientExtraConfigProvider httpClientExtraConfigProvider, String baseUrl, String apiKey) {
        this.httpClientExtraConfigProvider = httpClientExtraConfigProvider;
        this.baseUrl = baseUrl;
        this.apiKey = apiKey;
    }

    public ClaudeApi getOpenAIApi() {
        if (this.api == null) {
            OkHttpClient client = this.createHttpClient(this.httpClientExtraConfigProvider, this.baseUrl, this.apiKey);
            ObjectMapper objectMapper = AIRequestUtil.defaultObjectMapper();
            Retrofit retrofit = new Retrofit.Builder().baseUrl(this.baseUrl).client(client).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)objectMapper)).addCallAdapterFactory((CallAdapter.Factory)RxJava3CallAdapterFactory.create()).build();
            this.api = (ClaudeApi)retrofit.create(ClaudeApi.class);
        }
        return this.api;
    }

    public abstract OkHttpClient createHttpClient(HttpClientExtraConfigProvider var1, String var2, String var3);
}

