/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.connector.api.bedrock;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.oxygenxml.positron.api.connector.AIConnectionException;
import com.oxygenxml.positron.connector.api.bedrock.dto.BedrockContentBlockDeltaEvent;
import com.oxygenxml.positron.connector.api.bedrock.dto.BedrockContentBlockStartEvent;
import com.oxygenxml.positron.connector.api.bedrock.dto.BedrockContentBlockStopEvent;
import com.oxygenxml.positron.connector.api.bedrock.dto.BedrockConverseStreamResponse;
import com.oxygenxml.positron.connector.api.bedrock.dto.BedrockMessageStartEvent;
import com.oxygenxml.positron.connector.api.bedrock.dto.BedrockMessageStopEvent;
import com.oxygenxml.positron.connector.api.bedrock.dto.BedrockMetadataEvent;
import com.oxygenxml.positron.connector.util.ReactiveUtil;
import com.oxygenxml.positron.core.InvalidUserConfigurationException;
import com.oxygenxml.positron.core.api.SSE;
import com.oxygenxml.positron.utilities.AIRequestUtil;
import com.oxygenxml.positron.utilities.debug.LoggerUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.SubmissionPublisher;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.HttpException;
import retrofit2.Response;

public class BedrockResponseBodyCallback
implements Callback<ResponseBody> {
    private static final Logger log = LoggerFactory.getLogger(BedrockResponseBodyCallback.class);
    private SubmissionPublisher<BedrockConverseStreamResponse> submissionPublisher;

    public BedrockResponseBodyCallback(SubmissionPublisher<BedrockConverseStreamResponse> submissionPublisher) {
        this.submissionPublisher = submissionPublisher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
        BufferedReader reader = null;
        if (log.isDebugEnabled()) {
            log.debug("<-- Received response;\n\t Code: {};", (Object)response.code());
        }
        try {
            String line;
            if (!response.isSuccessful()) {
                HttpException httpException = new HttpException(response);
                AIConnectionException processHttpException = ReactiveUtil.processHttpException(httpException);
                String errorMesssage = processHttpException.getMessage();
                log.debug("\n\tExceptions message is: " + errorMesssage);
                StringBuilder headersString = new StringBuilder();
                response.headers().forEach(p -> {
                    headersString.append("\n");
                    headersString.append((String)p.component1()).append(":").append((String)p.component2());
                });
                log.debug("\n\t Response headers: {} ", (Object)headersString.toString());
                throw new InvalidUserConfigurationException(errorMesssage, (Exception)((Object)processHttpException));
            }
            InputStream in = ((ResponseBody)response.body()).byteStream();
            reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
            while (!this.isPublisherCancelled() && (line = reader.readLine()) != null) {
                String jsonContent;
                log.debug("Processing line: {}", (Object)line);
                if (line.trim().isEmpty()) continue;
                if (line.startsWith("event:")) {
                    log.debug("Skipping event line: {}", (Object)line);
                    continue;
                }
                if (line.startsWith("data:")) {
                    String data = line.substring(5).trim();
                    this.submit(new SSE(data));
                    continue;
                }
                if (line.isEmpty() || (jsonContent = this.extractJsonFromLine(line)) == null || jsonContent.trim().isEmpty()) continue;
                log.debug("Found JSON in line: {}", (Object)LoggerUtil.filterMessagesFromRequestBody((String)jsonContent));
                try {
                    BedrockConverseStreamResponse parsedEvent = this.parseBedrockStreamEvent(jsonContent);
                    if (parsedEvent != null) {
                        this.submitDirect(parsedEvent);
                        continue;
                    }
                }
                catch (Exception e) {
                    log.debug("Failed to parse Bedrock stream event: {}", (Object)e.getMessage());
                }
                this.submit(new SSE(jsonContent));
            }
            this.submissionPublisher.close();
        }
        catch (Throwable t) {
            this.onFailure(call, t);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException in) {}
            }
        }
    }

    private String extractJsonFromLine(String line) {
        int startBrace = line.indexOf(123);
        int endBrace = line.lastIndexOf(125);
        if (startBrace >= 0 && endBrace > startBrace) {
            return line.substring(startBrace, endBrace + 1);
        }
        return null;
    }

    private void submit(SSE item) {
        try {
            if (log.isDebugEnabled()) {
                log.debug("SSE: " + LoggerUtil.filterMessagesFromRequestBody((String)item.getData()));
            }
            log.debug("SSE: " + item.getData());
            BedrockConverseStreamResponse chunkItem = (BedrockConverseStreamResponse)AIRequestUtil.defaultObjectMapper().readValue(item.getData(), BedrockConverseStreamResponse.class);
            this.submissionPublisher.submit(chunkItem);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e, (Throwable)e);
            }
            this.submitError(e);
        }
    }

    private void submitDirect(BedrockConverseStreamResponse item) {
        try {
            log.debug("Sending to submissionPublisher...");
            this.submissionPublisher.submit(item);
            log.debug("Successfully sent to submissionPublisher");
        }
        catch (Exception e) {
            log.error("=== BEDROCK DIRECT SUBMIT ERROR ===");
            log.error("Error submitting item: {}", (Object)e.getMessage(), (Object)e);
            log.error("Item that caused error: {}", (Object)LoggerUtil.filterMessagesFromRequestBody((String)item.toString()));
            log.error("Item type: {}", (Object)item.getClass().getSimpleName());
            this.submitError(e);
        }
    }

    private BedrockConverseStreamResponse parseBedrockStreamEvent(String jsonContent) {
        try {
            ObjectMapper mapper = AIRequestUtil.defaultObjectMapper();
            JsonNode jsonNode = mapper.readTree(jsonContent);
            log.debug("JSON node fields: {}", (Object)jsonNode.fieldNames().toString());
            BedrockConverseStreamResponse response = new BedrockConverseStreamResponse();
            log.debug("Created response object of type: {}", (Object)response.getClass().getSimpleName());
            if (jsonNode.has("role") && !jsonNode.has("contentBlockIndex") && !jsonNode.has("stopReason")) {
                log.debug("Parsing messageStart event: {}", (Object)jsonContent);
                BedrockMessageStartEvent messageStart = (BedrockMessageStartEvent)mapper.treeToValue((TreeNode)jsonNode, BedrockMessageStartEvent.class);
                response.setMessageStart(messageStart);
            } else if (jsonNode.has("contentBlockIndex") && jsonNode.has("delta")) {
                log.debug("Parsing contentBlockDelta event: {}", (Object)jsonContent);
                BedrockContentBlockDeltaEvent contentBlockDelta = (BedrockContentBlockDeltaEvent)mapper.treeToValue((TreeNode)jsonNode, BedrockContentBlockDeltaEvent.class);
                response.setContentBlockDelta(contentBlockDelta);
            } else if (jsonNode.has("contentBlockIndex") && !jsonNode.has("delta") && !jsonNode.has("stopReason")) {
                log.debug("Parsing contentBlockStart event: {}", (Object)jsonContent);
                BedrockContentBlockStartEvent contentBlockStart = (BedrockContentBlockStartEvent)mapper.treeToValue((TreeNode)jsonNode, BedrockContentBlockStartEvent.class);
                response.setContentBlockStart(contentBlockStart);
            } else if (jsonNode.has("contentBlockIndex") && jsonNode.has("stopReason")) {
                log.debug("Parsing contentBlockStop event: {}", (Object)jsonContent);
                BedrockContentBlockStopEvent contentBlockStop = (BedrockContentBlockStopEvent)mapper.treeToValue((TreeNode)jsonNode, BedrockContentBlockStopEvent.class);
                response.setContentBlockStop(contentBlockStop);
            } else if (jsonNode.has("stopReason") && !jsonNode.has("contentBlockIndex")) {
                log.debug("Parsing messageStop event: {}", (Object)jsonContent);
                BedrockMessageStopEvent messageStop = (BedrockMessageStopEvent)mapper.treeToValue((TreeNode)jsonNode, BedrockMessageStopEvent.class);
                response.setMessageStop(messageStop);
            } else if (jsonNode.has("usage") || jsonNode.has("metrics")) {
                log.debug("Parsing metadata event: {}", (Object)jsonContent);
                BedrockMetadataEvent metadata = (BedrockMetadataEvent)mapper.treeToValue((TreeNode)jsonNode, BedrockMetadataEvent.class);
                response.setMetadata(metadata);
            } else {
                log.debug("Parsing as generic BedrockConverseStreamResponse: {}", (Object)jsonContent);
                response = (BedrockConverseStreamResponse)mapper.readValue(jsonContent, BedrockConverseStreamResponse.class);
            }
            log.debug("Successfully parsed event, returning response of type: {}", (Object)response.getClass().getSimpleName());
            return response;
        }
        catch (Exception e) {
            log.error("=== BEDROCK PARSE EVENT ERROR ===");
            log.error("Failed to parse Bedrock stream event: {}", (Object)e.getMessage(), (Object)e);
            log.error("JSON content that failed: {}", (Object)LoggerUtil.filterMessagesFromRequestBody((String)jsonContent));
            return null;
        }
    }

    private boolean isPublisherCancelled() {
        return this.submissionPublisher != null && this.submissionPublisher.isClosed();
    }

    public void onFailure(Call<ResponseBody> call, Throwable t) {
        this.submitError(t);
    }

    private void submitError(Throwable t) {
        log.error("=== BEDROCK SUBMIT ERROR DEBUG ===");
        log.error("Exception type: {}", (Object)t.getClass().getSimpleName());
        log.error("Exception message: {}", (Object)t.getMessage());
        log.error("Exception stack trace:", t);
        log.error("Sending error to submissionPublisher...");
        this.submissionPublisher.closeExceptionally(t);
        log.error("Successfully sent error to submissionPublisher");
    }
}

