/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.connector.api.bedrock;

import com.oxygenxml.positron.api.connector.AIConnectionException;
import com.oxygenxml.positron.api.connector.AIService;
import com.oxygenxml.positron.api.connector.dto.CompletionChunk;
import com.oxygenxml.positron.api.connector.dto.CompletionRequest;
import com.oxygenxml.positron.api.connector.dto.CompletionResponse;
import com.oxygenxml.positron.api.connector.dto.ModerationRequest;
import com.oxygenxml.positron.api.connector.dto.Pair;
import com.oxygenxml.positron.connector.api.HttpClientExtraConfigProvider;
import com.oxygenxml.positron.connector.api.bedrock.AWSBedrockAPIProvider;
import com.oxygenxml.positron.connector.api.bedrock.BedrockRequestResponseMapper;
import com.oxygenxml.positron.connector.api.bedrock.BedrockStreamingUtil;
import com.oxygenxml.positron.connector.api.bedrock.dto.BedrockConverseRequest;
import com.oxygenxml.positron.connector.api.bedrock.dto.BedrockConverseResponse;
import com.oxygenxml.positron.connector.api.bedrock.dto.BedrockConverseStreamResponse;
import com.oxygenxml.positron.connector.openai.HeadersQueryInterceptor;
import com.oxygenxml.positron.connector.openai.RequestLoggingInterceptor;
import com.oxygenxml.positron.connector.util.AIServiceUtil;
import com.oxygenxml.positron.connector.util.ReactiveUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Flow;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okio.Buffer;
import okio.BufferedSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AWSBedrockService
implements AIService {
    private static final Logger log = LoggerFactory.getLogger(AWSBedrockService.class);
    private List<Pair<String, String>> extraHeaders;
    protected AWSBedrockAPIProvider apiProvider;

    public AWSBedrockService(HttpClientExtraConfigProvider httpClientExtraConfigProvider, String endpoint, String apiKey, List<Pair<String, String>> extraHeaders) {
        this.extraHeaders = extraHeaders;
        this.apiProvider = new AWSBedrockAPIProvider(httpClientExtraConfigProvider, endpoint, apiKey){

            @Override
            public OkHttpClient createHttpClient(HttpClientExtraConfigProvider httpClientExtraConfigProvider, String endpoint, String apiKey) {
                return AWSBedrockService.this.createHttpClient(httpClientExtraConfigProvider, endpoint, apiKey);
            }
        };
    }

    public Flow.Publisher<CompletionChunk> getCompletionFlux(CompletionRequest completionRequest) {
        BedrockConverseRequest bedrockRequest = BedrockRequestResponseMapper.mapToBedrockRequest(completionRequest);
        if (completionRequest.getStream() != null && !completionRequest.getStream().booleanValue()) {
            if (log.isDebugEnabled()) {
                log.debug("Streaming disabled - using non-streaming endpoint and converting to stream");
            }
            try {
                BedrockConverseResponse response = ReactiveUtil.execute(this.apiProvider.getBedrockApi().createChatCompletion(bedrockRequest.getModelId(), bedrockRequest));
                CompletionResponse completionResponse = BedrockRequestResponseMapper.translateBedrockResponseToCommonResponse(response);
                final CompletionChunk chunk = new CompletionChunk();
                chunk.setModel(completionResponse.getModel());
                chunk.setChoices(completionResponse.getChoices());
                chunk.setUsage(completionResponse.getUsage());
                chunk.setFinishReason("stop");
                return new Flow.Publisher<CompletionChunk>(){

                    @Override
                    public void subscribe(final Flow.Subscriber<? super CompletionChunk> subscriber) {
                        subscriber.onSubscribe(new Flow.Subscription(){
                            private boolean cancelled = false;

                            @Override
                            public void request(long n) {
                                if (!this.cancelled && n > 0L) {
                                    subscriber.onNext(chunk);
                                    subscriber.onComplete();
                                }
                            }

                            @Override
                            public void cancel() {
                                this.cancelled = true;
                            }
                        });
                    }
                };
            }
            catch (Exception e) {
                log.error("Error in non-streaming mode: {}", (Object)e.getMessage(), (Object)e);
                throw new RuntimeException(e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Using streaming endpoint");
        }
        Flow.Publisher<BedrockConverseStreamResponse> chunkedFlow = BedrockStreamingUtil.streamFlow(this.apiProvider.getBedrockApi().createChatCompletionStream(bedrockRequest.getModelId(), bedrockRequest));
        return ReactiveUtil.map(chunkedFlow, BedrockRequestResponseMapper::translateBedrockChunkToCommonChunk);
    }

    public CompletionResponse getCompletion(CompletionRequest completionRequest) throws AIConnectionException {
        BedrockConverseRequest bedrockRequest = BedrockRequestResponseMapper.mapToBedrockRequest(completionRequest);
        BedrockConverseResponse resp = ReactiveUtil.execute(this.apiProvider.getBedrockApi().createChatCompletion(bedrockRequest.getModelId(), bedrockRequest));
        if (log.isDebugEnabled()) {
            log.debug("=== AWS Bedrock Non-Streaming Response Debug ===");
            log.debug("Response received successfully");
            if (resp.getUsage() != null) {
                log.debug("Token usage - Input: {}, Output: {}, Total: {}", new Object[]{resp.getUsage().getInputTokens(), resp.getUsage().getOutputTokens(), resp.getUsage().getTotalTokens()});
            }
            log.debug("Stop reason: {}", (Object)resp.getStopReason());
        }
        return BedrockRequestResponseMapper.translateBedrockResponseToCommonResponse(resp);
    }

    public boolean isRequiringApplyingModeration() {
        return false;
    }

    public boolean applyModeration(ModerationRequest moderationRequest) throws AIConnectionException {
        return false;
    }

    protected OkHttpClient createHttpClient(HttpClientExtraConfigProvider httpClientExtraConfigProvider, String endpoint, String apiKey) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Authorization", "Bearer " + apiKey);
        if (log.isDebugEnabled()) {
            log.debug("=== AWS Bedrock HTTP Client Debug ===");
            log.debug("Base URL: {}", (Object)endpoint);
            log.debug("Headers: {}", headers);
        }
        return this.createHttpClient(httpClientExtraConfigProvider, endpoint, headers, null);
    }

    protected OkHttpClient createHttpClient(HttpClientExtraConfigProvider httpClientExtraConfigProvider, String endpoint, Map<String, String> headers, Map<String, String> queryParams) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder = httpClientExtraConfigProvider.configureHttpClientAccordingToPreferences(builder, endpoint);
        if (this.extraHeaders != null) {
            for (Pair<String, String> pair : this.extraHeaders) {
                headers.put((String)pair.getFirst(), (String)pair.getSecond());
            }
        }
        builder = builder.addInterceptor((Interceptor)new HeadersQueryInterceptor(() -> headers, queryParams));
        builder = builder.addInterceptor((Interceptor)new RequestLoggingInterceptor(log));
        builder = builder.addInterceptor(chain -> {
            Request request = chain.request();
            if (log.isDebugEnabled()) {
                log.debug("=== Complete HTTP Request Debug ===");
                log.debug("Method: {}", (Object)request.method());
                log.debug("URL: {}", (Object)request.url());
                log.debug("Headers: {}", (Object)request.headers());
            }
            if (request.body() != null) {
                try {
                    Buffer buffer = new Buffer();
                    request.body().writeTo((BufferedSink)buffer);
                }
                catch (Exception e) {
                    log.warn("Could not read request body: {}", (Object)e.getMessage());
                }
            }
            return chain.proceed(request);
        });
        builder = builder.protocols(Arrays.asList(Protocol.HTTP_1_1));
        return builder.connectionPool(new ConnectionPool(5, 1L, TimeUnit.SECONDS)).readTimeout((long)AIServiceUtil.getAIClientReadTimeout(), TimeUnit.MILLISECONDS).build();
    }

    void setApiProviderForTc(AWSBedrockAPIProvider apiProvider) {
        this.apiProvider = apiProvider;
    }
}

