/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.connector.api.bedrock;

import com.oxygenxml.positron.api.connector.AIService;
import com.oxygenxml.positron.api.connector.ProxyProvider;
import com.oxygenxml.positron.api.connector.dto.CompletionRequest;
import com.oxygenxml.positron.api.connector.dto.Pair;
import com.oxygenxml.positron.api.connector.param.CheckBoxConnectorParam;
import com.oxygenxml.positron.api.connector.param.ConnectorParamBase;
import com.oxygenxml.positron.api.connector.param.KeyValueTableConnectorParam;
import com.oxygenxml.positron.api.connector.param.PasswordTextFieldConnectorParam;
import com.oxygenxml.positron.api.connector.param.TextFieldConnectorParam;
import com.oxygenxml.positron.connector.ConnectorUtil;
import com.oxygenxml.positron.connector.api.BuiltInAIConnector;
import com.oxygenxml.positron.connector.api.bedrock.AWSBedrockService;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AWSBedrockConnector
extends BuiltInAIConnector {
    private static final String DEFAULT_MODEL = "anthropic.claude-3-haiku-20240307-v1:0";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)AWSBedrockConnector.class.getName());
    public static final String CONNECTOR_ID = "aws-bedrock-connector";
    private static final String AWS_BEDROCK_BASE_LINK_TEMPLATE = "https://bedrock-runtime.{region}.amazonaws.com/";
    static final String AWS_REGION_PARAM_ID = "aws_region_param";
    static final String AWS_BEDROCK_API_KEY_PARAM_ID = "aws_bedrock_api_key_param";

    public String getConnectorId() {
        return CONNECTOR_ID;
    }

    public List<ConnectorParamBase> getParametersList() {
        ArrayList<ConnectorParamBase> params = new ArrayList<ConnectorParamBase>();
        params.add((ConnectorParamBase)new TextFieldConnectorParam(AWS_REGION_PARAM_ID, TRANSLATOR.getTranslation("AWS_REGION") + ":", TRANSLATOR.getTranslation("AWS_REGION_TOOLTIP")).setPlaceholderText("us-east-1").setDefaultValue("us-east-1"));
        String baseUrlExample = TRANSLATOR.getTranslation("Short_Example") + " https://bedrock-runtime.us-east-1.amazonaws.com/";
        params.add((ConnectorParamBase)new TextFieldConnectorParam("base_URL_param", TRANSLATOR.getTranslation("Base_URL") + ":", TRANSLATOR.getTranslation("AWS_BEDROCK_BASE_URL_TOOLTIP")).setPlaceholderText(baseUrlExample).setDefaultValue(AWS_BEDROCK_BASE_LINK_TEMPLATE.replace("{region}", "us-east-1")));
        params.add((ConnectorParamBase)new PasswordTextFieldConnectorParam(AWS_BEDROCK_API_KEY_PARAM_ID, TRANSLATOR.getTranslation("AWS_BEDROCK_API_KEY") + ":", TRANSLATOR.getTranslation("AWS_BEDROCK_API_KEY_TOOLTIP")));
        params.add((ConnectorParamBase)new TextFieldConnectorParam("model_param", TRANSLATOR.getTranslation("Default_model") + ":", null).setDefaultValue(DEFAULT_MODEL));
        params.add((ConnectorParamBase)new CheckBoxConnectorParam("streaming_param", TRANSLATOR.getTranslation("Switch_Streaming_Param_Name"), TRANSLATOR.getTranslation("Switch_Streaming_Param_Description"), Boolean.TRUE));
        params.add((ConnectorParamBase)new KeyValueTableConnectorParam("extra_headers_param", TRANSLATOR.getTranslation("Extra_headers") + ":", null));
        return params;
    }

    public String getConnectorName() {
        return "AWS Bedrock";
    }

    public AIService createAIService(ProxyProvider proxyProvider, int timeout) {
        Map resolvedParameters = this.getResolvedParameters();
        String endpoint = AWSBedrockConnector.computeServiceURLAddress(resolvedParameters);
        return new AWSBedrockService(this.getHttpClientExtraConfigProvider(), endpoint, (String)resolvedParameters.get(AWS_BEDROCK_API_KEY_PARAM_ID), AWSBedrockConnector.getExtraHeaders(resolvedParameters));
    }

    protected static String computeServiceURLAddress(Map<String, Object> resolvedParameters) {
        String endpoint = (String)resolvedParameters.get("base_URL_param");
        String region = (String)resolvedParameters.get(AWS_REGION_PARAM_ID);
        if (region != null && !region.trim().isEmpty()) {
            String edpointWithRegionPattern = "bedrock-runtime\\.[a-z0-9-]+\\.amazonaws\\.com";
            String wildcardPattern = ".*";
            if (endpoint != null && endpoint.matches(wildcardPattern + edpointWithRegionPattern + wildcardPattern)) {
                endpoint = endpoint.replaceAll(edpointWithRegionPattern, "bedrock-runtime." + region.trim() + ".amazonaws.com");
            } else {
                String endpointNoRegionPattern = "bedrock-runtime\\.amazonaws\\.com";
                if (endpoint != null && endpoint.matches(wildcardPattern + endpointNoRegionPattern + wildcardPattern)) {
                    endpoint = endpoint.replaceAll(endpointNoRegionPattern, "bedrock-runtime." + region.trim() + ".amazonaws.com");
                } else if (AWS_BEDROCK_BASE_LINK_TEMPLATE.replace("{region}", "us-east-1").equals(endpoint)) {
                    endpoint = AWS_BEDROCK_BASE_LINK_TEMPLATE.replace("{region}", region.trim());
                }
            }
        }
        if (endpoint.trim().isEmpty()) {
            throw new IllegalArgumentException(TRANSLATOR.getTranslation("Ai_service_address_missing"));
        }
        try {
            URIBuilder uriBuilder = new URIBuilder(endpoint);
            String currentPath = uriBuilder.getPath();
            if (!(currentPath == null || currentPath.isEmpty() || currentPath.endsWith("/") || currentPath.endsWith("\\"))) {
                uriBuilder.setPath(currentPath + "/");
                endpoint = uriBuilder.build().toURL().toExternalForm();
            }
        }
        catch (MalformedURLException | URISyntaxException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)e, (Throwable)e);
            }
            throw new IllegalArgumentException(MessageFormat.format(TRANSLATOR.getTranslation("Invalid_ai_service_address"), endpoint));
        }
        return endpoint;
    }

    @Override
    public CompletionRequest configureCompletionRequestForBuiltInConnector(CompletionRequest request) {
        if (request.getModel() == null || request.getModel().isEmpty()) {
            ConnectorUtil.setModelFromResolvedParamsInRequest(request, this.getResolvedParameters(), "model_param");
        }
        return request;
    }

    private static List<Pair<String, String>> getExtraHeaders(Map<String, Object> resolvedParameters) {
        return (List)resolvedParameters.get("extra_headers_param");
    }
}

