/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.connector;

import com.oxygenxml.positron.api.connector.AIConnector;
import com.oxygenxml.positron.api.connector.param.ConnectorParamType;
import com.oxygenxml.positron.connector.api.BuiltInAIConnector;
import com.oxygenxml.positron.connector.api.bedrock.AWSBedrockConnector;
import com.oxygenxml.positron.connector.api.claude.ClaudeConnector;
import com.oxygenxml.positron.connector.auth.OAuthCodeFlowEnabled;
import com.oxygenxml.positron.connector.auth.OAuthCodeFlowHelper;
import com.oxygenxml.positron.connector.gemini.GeminiConnector;
import com.oxygenxml.positron.connector.grok.GrokConnector;
import com.oxygenxml.positron.connector.openai.MSOpenAIConnector;
import com.oxygenxml.positron.connector.openai.OpenAIConnector;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;

class AIConnectorsFactory {
    private static final Logger log = LoggerFactory.getLogger(AIConnectorsFactory.class);
    private List<AIConnector> connectorTypes = new ArrayList<AIConnector>();
    private OAuthCodeFlowHelper oauthCodeFlowHelper;

    protected AIConnectorsFactory() {
        this.loadBuiltInConnectorTypes();
        this.connectorTypes.addAll(this.getCustomExternalConnectorTypes());
        for (AIConnector connector : this.connectorTypes) {
            this.validateConnectorParameters(connector);
        }
    }

    public void setOAuthCodeFlowHelper(OAuthCodeFlowHelper oauthCodeFlowHelper) {
        this.oauthCodeFlowHelper = oauthCodeFlowHelper;
    }

    private void loadBuiltInConnectorTypes() {
        this.connectorTypes.add(new OpenAIConnector());
        this.connectorTypes.add(new MSOpenAIConnector());
        this.connectorTypes.add(new ClaudeConnector());
        this.connectorTypes.add(new AWSBedrockConnector());
        this.connectorTypes.add(new GeminiConnector());
        this.connectorTypes.add(new GrokConnector());
    }

    public AIConnector createConnector(String connectorTypeId) {
        BuiltInAIConnector newInstance = null;
        if ("open-ai-connector".equals(connectorTypeId)) {
            newInstance = new OpenAIConnector();
        } else if ("ms-azure-open-ai-connector".equals(connectorTypeId)) {
            newInstance = new MSOpenAIConnector();
        } else if ("claude-ai-connector".equals(connectorTypeId)) {
            newInstance = new ClaudeConnector();
        } else if ("google-gemini-ai-connector".equals(connectorTypeId)) {
            newInstance = new GeminiConnector();
        } else if ("grok-connector".equals(connectorTypeId)) {
            newInstance = new GrokConnector();
        } else if ("aws-bedrock-connector".equals(connectorTypeId)) {
            newInstance = new AWSBedrockConnector();
        } else {
            List<AIConnector> externalConnectors = this.getCustomExternalConnectorTypes();
            newInstance = externalConnectors.stream().filter(connector -> connector.getConnectorId().equals(connectorTypeId)).findFirst().orElse(null);
        }
        if (this.oauthCodeFlowHelper != null && newInstance instanceof OAuthCodeFlowEnabled) {
            ((OAuthCodeFlowEnabled)((Object)newInstance)).setOAuthCodeFlowHelper(this.oauthCodeFlowHelper);
        }
        return newInstance;
    }

    private List<AIConnector> getCustomExternalConnectorTypes() {
        ArrayList<AIConnector> externalConnectors = new ArrayList<AIConnector>();
        PluginWorkspace pluginWorkspace = PluginWorkspaceProvider.getPluginWorkspace();
        if (pluginWorkspace != null) {
            try {
                Method getAIFunctionsProvider = pluginWorkspace.getClass().getMethod("getExternalAIConnectorsProvider", new Class[0]);
                Object aiFunctionProvider = getAIFunctionsProvider.invoke((Object)pluginWorkspace, new Object[0]);
                Method loadAIFunctions = aiFunctionProvider.getClass().getMethod("loadAIConnectors", new Class[0]);
                Object connectorsObj = loadAIFunctions.invoke(aiFunctionProvider, new Object[0]);
                if (connectorsObj instanceof List) {
                    List connectorsList = (List)connectorsObj;
                    for (Object externalConnector : connectorsList) {
                        if (externalConnector instanceof AIConnector) {
                            externalConnectors.add((AIConnector)externalConnector);
                            continue;
                        }
                        log.error("Cannot load custom AI connector type. This is not instance of AIConnector.");
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return externalConnectors;
    }

    public List<AIConnector> getConnectorTypes() {
        if (this.oauthCodeFlowHelper != null) {
            for (AIConnector aiConnector : this.connectorTypes) {
                if (!(aiConnector instanceof OAuthCodeFlowEnabled)) continue;
                ((OAuthCodeFlowEnabled)aiConnector).setOAuthCodeFlowHelper(this.oauthCodeFlowHelper);
            }
        }
        return this.connectorTypes;
    }

    private void validateConnectorParameters(AIConnector connector) {
        List parameters = connector.getParametersList();
        if (parameters == null) {
            return;
        }
        long modelComboBoxCount = parameters.stream().filter(param -> param != null && param.getType() == ConnectorParamType.MODEL_COMBO_BOX).count();
        if (modelComboBoxCount > 1L) {
            String errorMessage = String.format("Connector type '%s' (ID: %s) has %d MODEL_COMBO_BOX parameters. Only one MODEL_COMBO_BOX parameter is allowed per connector.", connector.getConnectorName(), connector.getConnectorId(), modelComboBoxCount);
            log.error(errorMessage);
            throw new IllegalArgumentException(errorMessage);
        }
    }
}

