/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.util;

import java.awt.AWTKeyStroke;
import java.awt.event.KeyEvent;
import java.util.HashSet;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import ro.sync.basic.util.PlatformDetector;

public class KeyboardUtilities {
    private static final String CTRL_ENTER_FOR_SUBMIT_SHORTCUT = "ctrlEnterForSubmit";
    private static final String ENTER_FOR_SUBMIT_SHORTCUT = "enterForSubmit";
    private static final String SHIFT_ENTER_FOR_NEWLINE = "shiftEnterForNewline";

    private KeyboardUtilities() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static void setSubmitAndNewlineShortcuts(JTextComponent textArea, Action submitAction) {
        int ctrlOrCmdKey = PlatformDetector.isMacOS() ? 256 : 128;
        KeyStroke ctrlEnterKeyStroke = KeyStroke.getKeyStroke(10, ctrlOrCmdKey);
        KeyStroke enterKeyStroke = KeyStroke.getKeyStroke(10, 0);
        KeyboardUtilities.registerToInputMapAndActionMap(textArea, submitAction, ctrlEnterKeyStroke, CTRL_ENTER_FOR_SUBMIT_SHORTCUT);
        KeyboardUtilities.registerToInputMapAndActionMap(textArea, submitAction, enterKeyStroke, ENTER_FOR_SUBMIT_SHORTCUT);
        KeyboardUtilities.tootipActionShortcutToButton(submitAction, enterKeyStroke);
        Action newLineAction = textArea.getActionMap().get("insert-break");
        KeyStroke shiftEnterKeyStroke = KeyStroke.getKeyStroke(10, 64);
        KeyboardUtilities.registerToInputMapAndActionMap(textArea, newLineAction, shiftEnterKeyStroke, SHIFT_ENTER_FOR_NEWLINE);
    }

    private static void registerToInputMapAndActionMap(JComponent component, Action action, KeyStroke keyStroke, String actionKey) {
        action.putValue("AcceleratorKey", keyStroke);
        component.getInputMap(0).put(keyStroke, actionKey);
        component.getActionMap().put(actionKey, action);
    }

    private static void tootipActionShortcutToButton(Action action, KeyStroke keyStroke) {
        String tooltip = (String)action.getValue("Name") + " (" + KeyEvent.getKeyText(keyStroke.getKeyCode()) + ")";
        action.putValue("ShortDescription", tooltip);
    }

    public static void enableTabAndShiftTabFocusTraversal(JTextArea textArea) {
        HashSet<AWTKeyStroke> forwardKeys = new HashSet<AWTKeyStroke>(textArea.getFocusTraversalKeys(0));
        forwardKeys.add(KeyStroke.getKeyStroke("TAB"));
        textArea.setFocusTraversalKeys(0, forwardKeys);
        HashSet<AWTKeyStroke> backwardKeys = new HashSet<AWTKeyStroke>(textArea.getFocusTraversalKeys(1));
        backwardKeys.add(KeyStroke.getKeyStroke("shift TAB"));
        textArea.setFocusTraversalKeys(1, backwardKeys);
    }
}

