/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.util;

import com.oxygenxml.RetinaDetector;
import com.oxygenxml.positron.plugin.util.RetinaIcon;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.swing.ImageIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.URLUtil;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.images.ImageUtilities;
import ro.sync.exml.workspace.api.standalone.StandalonePluginWorkspace;
import ro.sync.exml.workspace.api.util.ColorTheme;

public class IconsLoader {
    private static final String DARK_ICON_MARKER = "_dark";
    private static final String RETINA_ICON_PATH_MARKER = "@2x";
    private static ImageIcon FALLBACK_ICON = new ImageIcon();
    private static final Logger logger;

    private IconsLoader() {
    }

    public static ImageIcon loadIcon(String icon) {
        URL resource;
        ImageIcon imgIcon = FALLBACK_ICON;
        if (icon != null && (resource = IconsLoader.class.getResource(icon)) != null) {
            imgIcon = IconsLoader.loadIcon(resource);
        }
        return imgIcon;
    }

    public static ImageIcon loadIcon(URL iconLocation) {
        ImageUtilities imageUtilities;
        PluginWorkspace pw;
        ImageIcon imgIcon = FALLBACK_ICON;
        if (iconLocation != null && (pw = PluginWorkspaceProvider.getPluginWorkspace()) != null && (imageUtilities = pw.getImageUtilities()) != null) {
            imgIcon = (ImageIcon)imageUtilities.loadIcon(iconLocation);
        }
        return imgIcon;
    }

    public static ImageIcon loadAnimatedIcon(String iconPath) {
        PluginWorkspace pw;
        ImageIcon icon = FALLBACK_ICON;
        if (iconPath != null && (pw = PluginWorkspaceProvider.getPluginWorkspace()) instanceof StandalonePluginWorkspace) {
            String darkPath;
            StandalonePluginWorkspace saPluginWS = (StandalonePluginWorkspace)pw;
            ColorTheme colorTheme = saPluginWS.getColorTheme();
            boolean darkTheme = colorTheme != null && colorTheme.isDarkTheme();
            URL iconResource = null;
            String retinaIconPath = IconsLoader.getRetinaIconPath(iconPath);
            boolean foundRetina = false;
            if (retinaIconPath != null) {
                String darkRetinaPath;
                if (darkTheme && (darkRetinaPath = IconsLoader.getDarkIconPath(retinaIconPath)) != null) {
                    iconResource = IconsLoader.getResource(darkRetinaPath);
                }
                if (iconResource == null) {
                    iconResource = IconsLoader.getResource(retinaIconPath);
                }
                if (iconResource != null) {
                    foundRetina = true;
                }
            }
            if (iconResource == null && darkTheme && (darkPath = IconsLoader.getDarkIconPath(iconPath)) != null) {
                iconResource = IconsLoader.getResource(darkPath);
            }
            if (iconResource == null) {
                iconResource = IconsLoader.getResource(iconPath);
            }
            if (iconResource != null) {
                icon = foundRetina ? new RetinaIcon(iconResource) : new ImageIcon(iconResource);
            } else {
                logger.error("Wrong path for icon: {}", (Object)iconPath);
            }
        }
        return icon;
    }

    private static URL getResource(String iconPath) {
        return IconsLoader.class.getResource(iconPath);
    }

    private static String getRetinaIconPath(String iconPath) {
        int indexSlash;
        float iconScalingFactor = RetinaDetector.getIconScalingFactor();
        if (iconScalingFactor >= 2.0f && (indexSlash = iconPath.lastIndexOf(47)) != -1) {
            String parentPath = iconPath.substring(0, indexSlash + 1);
            String iconName = iconPath.substring(indexSlash + 1);
            String extension = URLUtil.getExtension((String)iconName);
            String name = URLUtil.removeExtension((String)iconName);
            if (name != null && !name.endsWith(RETINA_ICON_PATH_MARKER)) {
                return parentPath + name + "@2x." + extension;
            }
        }
        return null;
    }

    private static String getDarkIconPath(String iconPath) {
        int indexSlash = iconPath.lastIndexOf(47);
        if (indexSlash != -1) {
            String parentPath = iconPath.substring(0, indexSlash + 1);
            String iconName = iconPath.substring(indexSlash + 1);
            String extension = URLUtil.getExtension((String)iconName);
            String name = URLUtil.removeExtension((String)iconName);
            if (name.endsWith(RETINA_ICON_PATH_MARKER)) {
                return parentPath + name.substring(0, name.length() - RETINA_ICON_PATH_MARKER.length()) + "_dark@2x." + extension;
            }
            return parentPath + name + "_dark." + extension;
        }
        return null;
    }

    static {
        BufferedImage noIconImage = new BufferedImage(16, 16, 1);
        Graphics2D g = noIconImage.createGraphics();
        g.setColor(Color.RED);
        g.fillRect(0, 0, 16, 16);
        FALLBACK_ICON.setImage(noIconImage);
        logger = LoggerFactory.getLogger((String)IconsLoader.class.getName());
    }
}

