/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.util;

import com.oxygenxml.positron.connector.SystemEnvUtil;
import com.oxygenxml.positron.utilities.ModelIdentifierUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Optional;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.URLUtil;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.options.WSOptionsStorage;

public class AiPositronServiceAccess {
    private static final Logger log = LoggerFactory.getLogger(AiPositronServiceAccess.class);
    public static final String ALLOW_ACCESS_TO_AI_POSITRON_SERVICE_SYSTEM_PROP = "allow.access.to.ai.positron.service";
    private static final String INSTALLER_FILE_NAME = "install.properties";
    private boolean hasAccessToAiService;

    private AiPositronServiceAccess() {
        this.computeAccess();
    }

    private void computeAccess() {
        this.hasAccessToAiService = AiPositronServiceAccess.isAIPositronServiceAccessAllowedFromInstallation() && AiPositronServiceAccess.isAIPositronServiceAccessAllowedFromSystemProperties();
    }

    private static boolean isAIPositronServiceAccessAllowedFromSystemProperties() {
        String envVal = SystemEnvUtil.getenv((String)ALLOW_ACCESS_TO_AI_POSITRON_SERVICE_SYSTEM_PROP);
        if (envVal != null) {
            return Boolean.parseBoolean(envVal);
        }
        return true;
    }

    public static AiPositronServiceAccess getInstance() {
        return Holder.INSTANCE;
    }

    public boolean hasAccessToAiPositronService() {
        return this.hasAccessToAiService;
    }

    public void resetForTC() {
        this.computeAccess();
    }

    public String buildPositronServiceDefaultModelIdentifier() {
        if (this.hasAccessToAiPositronService()) {
            return ModelIdentifierUtil.buildPositronServiceDefaultModelIdentifier();
        }
        return null;
    }

    private static boolean isAIPositronServiceAccessAllowedFromInstallation() {
        return "true".equals(AiPositronServiceAccess.checkOxygenInstallationProperties(ALLOW_ACCESS_TO_AI_POSITRON_SERVICE_SYSTEM_PROP, "true"));
    }

    private static String checkOxygenInstallationProperties(String optionName, String defaultValue) {
        Optional<Properties> properties;
        File propertiesFile;
        String installHomeDir;
        String propertyValue;
        block5: {
            propertyValue = defaultValue;
            String installHomeUrl = System.getProperty("com.oxygenxml.editor.home.url");
            installHomeDir = new File(".").toString();
            if (installHomeUrl != null) {
                try {
                    File canonicalFileFromFileUrl = URLUtil.getCanonicalFileFromFileUrl((URL)new URL(installHomeUrl));
                    if (canonicalFileFromFileUrl != null) {
                        installHomeDir = canonicalFileFromFileUrl.toString();
                    }
                }
                catch (MalformedURLException e) {
                    if (!log.isDebugEnabled()) break block5;
                    log.debug("Cannot obtain install dir from: " + URLUtil.filterPasswords((String)String.valueOf(installHomeUrl)));
                }
            }
        }
        if ((propertiesFile = new File(installHomeDir, INSTALLER_FILE_NAME)).exists() && (properties = AiPositronServiceAccess.readProperties(propertiesFile)).isPresent()) {
            propertyValue = properties.get().getProperty(optionName, defaultValue);
        }
        return propertyValue;
    }

    private static Optional<Properties> readProperties(File propertiesFile) {
        Properties properties;
        block7: {
            properties = null;
            try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(propertiesFile));){
                properties = new Properties();
                properties.load(stream);
            }
            catch (IOException e) {
                if (!log.isDebugEnabled()) break block7;
                log.debug((Object)e, (Throwable)e);
            }
        }
        return Optional.ofNullable(properties);
    }

    public boolean isAiPositronServiceConnectionEnabledFromAiServicePreferences() {
        String option;
        WSOptionsStorage optionsStorage;
        PluginWorkspace pluginWorkspace = PluginWorkspaceProvider.getPluginWorkspace();
        if (pluginWorkspace != null && (optionsStorage = pluginWorkspace.getOptionsStorage()) != null && (option = optionsStorage.getOption("oxygen.positron.plugin.enable.positron.service", null)) != null) {
            return Boolean.valueOf(option);
        }
        return false;
    }

    private static class Holder {
        private static final AiPositronServiceAccess INSTANCE = new AiPositronServiceAccess();

        private Holder() {
        }
    }
}

