/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.ui.history;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class LimitedSizeHistoryList<T> {
    private int maxSize;
    private ArrayList<T> list;

    public LimitedSizeHistoryList(int maxSize) {
        this.maxSize = maxSize;
        this.list = new ArrayList(maxSize);
    }

    public synchronized void addAtBeginning(T historyObject) {
        this.list.remove(historyObject);
        if (this.list.size() >= this.maxSize) {
            this.list.remove(this.list.size() - 1);
        }
        this.list.add(0, historyObject);
    }

    public synchronized void append(T historyObject) {
        this.list.remove(historyObject);
        if (this.list.size() >= this.maxSize) {
            this.list.remove(0);
        }
        this.list.add(historyObject);
    }

    public synchronized List<T> getStoredObjects() {
        return Collections.unmodifiableList(new ArrayList<T>(this.list));
    }

    public synchronized void clear() {
        this.list.clear();
    }

    public synchronized void initialize(List<T> toCopy) {
        this.list.clear();
        int cpSize = Math.min(toCopy.size(), this.maxSize);
        for (int i = 0; i < cpSize; ++i) {
            this.list.add(toCopy.get(i));
        }
    }

    public synchronized void remove(int index) {
        this.list.remove(index);
    }

    public synchronized int indexOf(T entry) {
        return this.list.indexOf(entry);
    }

    public synchronized T get(int index) {
        return this.list.get(index);
    }

    public synchronized void removeAll(Collection<T> c) {
        this.list.removeAll(c);
    }

    public synchronized <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }
}

