/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.ui.history;

import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.plugin.ui.history.LimitedSizeHistoryList;
import com.oxygenxml.positron.plugin.ui.history.StoredObject;
import com.oxygenxml.positron.plugin.util.IconsLoader;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.standalone.ui.SplitMenuButton;

public abstract class HistoryComponent<H extends StoredObject>
extends SplitMenuButton {
    private final Translator messages = Translator.getInstance();
    private LimitedSizeHistoryList<H> historyObjectList;
    private AbstractAction clearHistoryAction = new AbstractAction(this.messages.getTranslation("Clear_history"), IconsLoader.loadIcon("/images/RemoveAll16.png")){

        @Override
        public void actionPerformed(ActionEvent e) {
            int result;
            if (this.isEnabled() && (result = JOptionPane.showConfirmDialog((Component)PluginWorkspaceProvider.getPluginWorkspace().getParentFrame(), HistoryComponent.this.messages.getTranslation("Clear_history_confirmation"), HistoryComponent.this.messages.getTranslation("Clear_history"), 0)) == 0) {
                HistoryComponent.this.historyObjectList.clear();
                HistoryComponent.this.refreshHistoryActions();
                HistoryComponent.this.clearHistory();
            }
        }
    };

    public HistoryComponent(int maxItems) {
        super(null, (Icon)IconsLoader.loadIcon("/images/ChatHistory16.png"), false, false, true, false);
        this.setToolTipText(this.messages.getTranslation("History"));
        this.historyObjectList = new LimitedSizeHistoryList(maxItems);
        this.refreshHistoryActions();
    }

    public abstract void historyObjectSelected(H var1);

    protected abstract void saveToDisk(H var1);

    protected abstract void clearHistory();

    public void refreshHistoryActions() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HistoryComponent.this.removeAll();
                List historyObjects = HistoryComponent.this.historyObjectList.getStoredObjects();
                for (StoredObject historyObject : historyObjects) {
                    HistoryComponent.this.add(new HistoryAction(HistoryComponent.this, historyObject));
                }
                if (!historyObjects.isEmpty()) {
                    HistoryComponent.this.addSeparator();
                }
                HistoryComponent.this.add(HistoryComponent.this.clearHistoryAction);
                HistoryComponent.this.clearHistoryAction.setEnabled(!historyObjects.isEmpty());
            }
        });
    }

    public final void addHistoryObject(H historyObject) {
        this.addHistoryObject(historyObject, true);
    }

    public final void addHistoryObject(H historyObject, boolean saveToDisk) {
        this.historyObjectList.addAtBeginning(historyObject);
        this.refreshHistoryActions();
        if (saveToDisk) {
            this.saveToDisk(historyObject);
        }
    }

    public List<H> getHistoryObjects() {
        return new ArrayList<H>(this.historyObjectList.getStoredObjects());
    }

    private static class HistoryAction
    extends AbstractAction {
        private final H historyObject;
        final /* synthetic */ HistoryComponent this$0;

        public HistoryAction(H historyObject) {
            this.this$0 = var1_1;
            super(historyObject.getName());
            this.historyObject = historyObject;
            this.putValue("ShortDescription", historyObject.getDescription());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.this$0.historyObjectSelected(this.historyObject);
        }
    }
}

