/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.ui;

import com.oxygenxml.positron.plugin.util.UIUtil;
import java.awt.Graphics;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public class PlaceholderPainter {
    private final JTextComponent textComponent;
    private final String placeHolder;
    private final boolean showFocusHint;

    public PlaceholderPainter(final JTextComponent textComponent, String placeHolder, boolean showFocusHint) {
        this.textComponent = textComponent;
        this.placeHolder = placeHolder;
        this.showFocusHint = showFocusHint;
        textComponent.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                textComponent.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                textComponent.repaint();
            }
        });
        textComponent.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                textComponent.repaint();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                textComponent.repaint();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                textComponent.repaint();
            }
        });
    }

    public void paint(Graphics g) {
        boolean isPlaceHolderDrawable = this.placeHolder != null && !this.placeHolder.isEmpty();
        boolean hasNoText = this.textComponent.getText().isEmpty();
        boolean isEnabled = this.textComponent.isEnabled();
        boolean hasFocus = this.textComponent.isFocusOwner();
        if (isPlaceHolderDrawable && hasNoText && isEnabled && (!hasFocus || this.showFocusHint)) {
            UIUtil.drawMultiLinePlaceholder(this.textComponent, g, this.placeHolder);
        }
    }
}

