/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.ui;

import com.oxygenxml.positron.plugin.ui.ThemeColorProvider;
import com.oxygenxml.positron.plugin.util.UIUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import javax.swing.text.JTextComponent;
import ro.sync.exml.workspace.api.standalone.ui.OxygenUIComponentsFactory;

public class JComposedLinkLabel
extends JPanel {
    private final Action action;
    private final JLabel iconLabel = new JLabel();
    private final JComponent nameLabel;
    private final JComponent descriptionLabel;
    private final Font normalFont;
    private final Font underlineFont;
    private static final Map<? extends AttributedCharacterIterator.Attribute, ?> UNDERLINED_TEXT_ATTRIBUTES_MAP = new HashMap(){
        {
            this.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_LOW_ONE_PIXEL);
        }
    };

    public JComposedLinkLabel(Action action, String name, String description, Icon icon) {
        this.action = action;
        this.setLayout(new GridBagLayout());
        this.setOpaque(false);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets = new Insets(0, 0, 0, this.iconLabel.getIconTextGap());
        constraints.fill = 0;
        constraints.anchor = 17;
        constraints.gridheight = 2;
        this.iconLabel.setIcon(icon);
        this.add((Component)this.iconLabel, constraints);
        this.nameLabel = OxygenUIComponentsFactory.createMultilineLabel((String)name, (boolean)false);
        this.nameLabel.setForeground(ThemeColorProvider.getInstance().getLinkColor());
        this.nameLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        constraints.gridheight = 1;
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.insets = UIUtil.getNoInsets();
        constraints.fill = 2;
        this.add((Component)this.nameLabel, constraints);
        constraints.gridx = 1;
        constraints.gridy = 1;
        this.descriptionLabel = OxygenUIComponentsFactory.createMultilineLabel((String)description, (boolean)false);
        this.descriptionLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.descriptionLabel.setFocusable(false);
        this.add((Component)this.descriptionLabel, constraints);
        Font currentFont = this.nameLabel.getFont();
        this.normalFont = currentFont.deriveFont(currentFont.getSize2D() + 2.0f);
        this.nameLabel.setFont(this.normalFont);
        this.underlineFont = this.normalFont.deriveFont(UNDERLINED_TEXT_ATTRIBUTES_MAP);
        this.installMouseListener();
    }

    private void installMouseListener() {
        this.nameLabel.addMouseListener(new MouseAdapter(){
            private Cursor oldCursor;

            @Override
            public void mouseEntered(MouseEvent e) {
                if (JComposedLinkLabel.this.nameLabel.isEnabled()) {
                    JComposedLinkLabel.this.nameLabel.setFont(JComposedLinkLabel.this.underlineFont);
                    JComposedLinkLabel.this.nameLabel.setForeground(ThemeColorProvider.getInstance().getLinkHoverColor());
                    this.oldCursor = JComposedLinkLabel.this.getCursor();
                    JComposedLinkLabel.this.nameLabel.setCursor(Cursor.getPredefinedCursor(12));
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (JComposedLinkLabel.this.nameLabel.isEnabled()) {
                    JComposedLinkLabel.this.nameLabel.setFont(JComposedLinkLabel.this.normalFont);
                    JComposedLinkLabel.this.nameLabel.setForeground(ThemeColorProvider.getInstance().getLinkColor());
                    if (this.oldCursor != null) {
                        JComposedLinkLabel.this.nameLabel.setCursor(this.oldCursor);
                    } else {
                        JComposedLinkLabel.this.nameLabel.setCursor(new Cursor(0));
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (JComposedLinkLabel.this.action.isEnabled()) {
                    this.mouseExited(null);
                    JComposedLinkLabel.this.action.actionPerformed(null);
                }
            }
        });
    }

    @Override
    public JToolTip createToolTip() {
        return OxygenUIComponentsFactory.installMultilineTooltip((JComponent)this);
    }

    public String getNameLabelText() {
        return Optional.of(this.nameLabel).filter(JTextComponent.class::isInstance).map(JTextComponent.class::cast).map(JTextComponent::getText).orElse(null);
    }

    public String getDesciptionLabelText() {
        return Optional.of(this.descriptionLabel).filter(JTextComponent.class::isInstance).map(JTextComponent.class::cast).map(JTextComponent::getText).orElse(null);
    }
}

