/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.ui;

import com.oxygenxml.positron.plugin.ui.ComboBoxItem;
import com.oxygenxml.positron.plugin.ui.ThemeColorProvider;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;

public class GroupComboBoxRenderer
implements ListCellRenderer<ComboBoxItem> {
    private static final String DEFAULT_MODEL_ID = "default";
    private final DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();

    @Override
    public Component getListCellRendererComponent(JList<? extends ComboBoxItem> list, ComboBoxItem value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel renderer = (JLabel)this.defaultRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        if (value != null && value.getValue() == null && value.getCategory() != null) {
            renderer.setText(value.getCategory());
            renderer.setToolTipText(value.getCategory());
            renderer.setFont(renderer.getFont().deriveFont(1));
            renderer.setForeground(ThemeColorProvider.getInstance().getGroupSeparatorColor());
            renderer.setBackground(UIManager.getColor("ComboBox.background"));
        } else if (value != null && value.getValue() != null) {
            boolean isInDropdown;
            boolean bl = isInDropdown = index >= 0;
            if (isInDropdown) {
                renderer.setText("    " + value.getDisplayText());
            } else {
                boolean bothCategoryAndNameAreDefault;
                Object textInField = value.getDisplayText();
                boolean isDefaultModel = ((String)textInField).toLowerCase().contains(DEFAULT_MODEL_ID);
                boolean isDefaultCategory = value.getCategory() != null && value.getCategory().toLowerCase().contains(DEFAULT_MODEL_ID);
                boolean bl2 = bothCategoryAndNameAreDefault = isDefaultModel && isDefaultCategory;
                if (value.getCategory() != null && !bothCategoryAndNameAreDefault) {
                    textInField = (String)textInField + " [" + value.getCategory() + "]";
                }
                renderer.setText((String)textInField);
            }
            renderer.setFont(renderer.getFont().deriveFont(0));
            renderer.setEnabled(true);
            String itemTooltip = value.getDescription();
            if (itemTooltip != null) {
                renderer.setToolTipText("<html><body style='width:400px;'>" + itemTooltip + "</html>");
            } else {
                renderer.setToolTipText(null);
            }
        }
        return renderer;
    }
}

