/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.refactoring;

import com.oxygenxml.positron.api.connector.dto.Pair;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.core.util.AIModelsUtil;
import com.oxygenxml.positron.plugin.refactoring.RefactorController;
import com.oxygenxml.positron.plugin.refactoring.RefactoringCost;
import com.oxygenxml.positron.plugin.refactoring.RefactoringCostProvider;
import com.oxygenxml.positron.plugin.refactoring.UnknownFilesProperties;
import com.oxygenxml.positron.plugin.util.DirectConnectionConfigurationHelper;
import com.oxygenxml.positron.utilities.AIProviderConstants;
import com.oxygenxml.positron.utilities.credits.CreditsConverterUtil;
import com.oxygenxml.positron.utilities.json.AIActionDetails;
import com.oxygenxml.positron.utilities.json.Engine;
import com.oxygenxml.positron.utilities.json.Parameters;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.URLUtil;
import ro.sync.document.DocumentPositionedInfo;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.results.ResultsManager;

public class RefactoringCostProviderImpl
implements RefactoringCostProvider {
    private static final int CHARACTER_COUNT_PER_TOKEN = 4;
    private static final Logger LOGGER = LoggerFactory.getLogger(RefactoringCostProviderImpl.class);
    private static final Translator TRANSLATOR = Translator.getInstance();
    private RefactoringCost filteredFilesRefactoringCost;

    public RefactoringCostProviderImpl(List<URL> fileURLs) {
        Pair<List<URL>, UnknownFilesProperties> filesRecursively = RefactorController.getResourcesRecursively(fileURLs);
        this.setFilteredFilesRefactoringCost(new RefactoringCost(((List)filesRecursively.getFirst()).size(), this.getTokenCostOfRefactoring((List)filesRecursively.getFirst()), (UnknownFilesProperties)filesRecursively.getSecond()));
    }

    @Override
    public RefactoringCost getRefactoringCostForAction(AIActionDetails aiActionDetails) {
        if (this.filteredFilesRefactoringCost == null) {
            LOGGER.debug("Called method before the costs were set, bad flow");
        }
        String currentModel = this.getCurrentModel(aiActionDetails);
        this.updateCostsBasedOnModel(currentModel);
        return this.filteredFilesRefactoringCost;
    }

    private String getCurrentModel(AIActionDetails aiActionDetails) {
        String currentModel = Optional.ofNullable(AIModelsUtil.getAIModelFromOptions((String)"default.engine.model")).orElse(AIProviderConstants.DEFAULT_ENGINE.getId());
        if (aiActionDetails != null) {
            Parameters parameters = aiActionDetails.getParameters();
            if (parameters == null) {
                LOGGER.debug("No parameters were set for this action");
            } else {
                Engine engine = parameters.getEngine();
                if (engine == null) {
                    LOGGER.debug("No engine was set for this action");
                } else {
                    currentModel = engine.getId();
                }
            }
        }
        return currentModel;
    }

    private void updateCostsBasedOnModel(String currentModel) {
        Optional<Integer> cost = this.filteredFilesRefactoringCost.getNrOfTokens();
        try {
            Optional<Integer> nrOfTokens = this.filteredFilesRefactoringCost.getNrOfTokens();
            if (nrOfTokens.isEmpty()) {
                return;
            }
            cost = Optional.of(CreditsConverterUtil.getNoOfCredits((int)nrOfTokens.get(), (String)currentModel, (boolean)true));
            this.filteredFilesRefactoringCost.setCost(RefactoringCostProvider.formatNumber(cost));
        }
        catch (Exception e) {
            LOGGER.debug("Incorrect engine model. Could not aproximate cost. %s", (Throwable)e);
        }
    }

    private Optional<Integer> getTokenCostOfRefactoring(List<URL> fileURLs) {
        boolean isAnyFileRemote = fileURLs.stream().anyMatch(url -> URLUtil.getCanonicalFileFromFileUrl((URL)url) == null);
        if (isAnyFileRemote || DirectConnectionConfigurationHelper.isDirectConnection()) {
            return Optional.empty();
        }
        int totalTokenCost = 0;
        for (URL url2 : fileURLs) {
            File fileFromFileUrl = URLUtil.getCanonicalFileFromFileUrl((URL)url2);
            long sizeOfFile = 0L;
            try {
                sizeOfFile = Files.size(Path.of(fileFromFileUrl.toURI()));
                totalTokenCost = (int)((long)totalTokenCost + sizeOfFile / 4L);
            }
            catch (IOException e) {
                PluginWorkspaceProvider.getPluginWorkspace().getResultsManager().addResult(TRANSLATOR.getTranslation("Refactor_Title"), new DocumentPositionedInfo(0, e.toString()), ResultsManager.ResultType.GENERIC, false, false);
                LOGGER.debug("The files chosen by the user have problems with their path. %s", (Throwable)e);
            }
        }
        return Optional.of(totalTokenCost);
    }

    public void setFilteredFilesRefactoringCost(RefactoringCost filteredFilesRefactoringCost) {
        this.filteredFilesRefactoringCost = filteredFilesRefactoringCost;
    }

    public RefactoringCost getFilteredFilesRefactoringCost() {
        return this.filteredFilesRefactoringCost;
    }
}

