/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.refactoring;

import com.google.common.annotations.VisibleForTesting;
import com.oxygenxml.positron.api.connector.dto.Message;
import com.oxygenxml.positron.api.connector.dto.MessageContent;
import com.oxygenxml.positron.api.connector.dto.MessageTextContent;
import com.oxygenxml.positron.api.connector.dto.RoleType;
import com.oxygenxml.positron.core.AICompletionDetailsProvider;
import com.oxygenxml.positron.core.AICompletionResponse;
import com.oxygenxml.positron.core.CannotComputeCompletionDetailsException;
import com.oxygenxml.positron.core.actions.DefaultActionInteractor;
import com.oxygenxml.positron.core.actions.ParamsExpander;
import com.oxygenxml.positron.core.actions.types.ActionInteractorFactory;
import com.oxygenxml.positron.core.actions.types.BaseActionInteractor;
import com.oxygenxml.positron.core.aiignore.AiIgnoreManager;
import com.oxygenxml.positron.core.aiignore.AiIgnoreManagerProvider;
import com.oxygenxml.positron.core.interactions.ContentInserter;
import com.oxygenxml.positron.core.interactions.DefaultContentInserterForAuthorPage;
import com.oxygenxml.positron.core.interactions.DocumentContentInteractor;
import com.oxygenxml.positron.core.interactions.authorpage.OpenAIPrefixExtractorForAuthorPage;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.core.service.PositronServiceUtil;
import com.oxygenxml.positron.core.util.TextUtils;
import com.oxygenxml.positron.plugin.refactoring.RefactorProgressUpdater;
import com.oxygenxml.positron.plugin.refactoring.RefactoredContent;
import com.oxygenxml.positron.utilities.exceptions.InvalidMessageException;
import com.oxygenxml.positron.utilities.json.AIActionDetails;
import com.oxygenxml.positron.utilities.json.ActionType;
import com.oxygenxml.positron.utilities.json.InsertMode;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.swing.text.BadLocationException;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.execution.StoppedByUserException;
import ro.sync.basic.io.IOUtil;
import ro.sync.basic.util.URLUtil;
import ro.sync.document.DocumentPositionedInfo;
import ro.sync.ecss.extensions.api.component.AuthorComponentException;
import ro.sync.ecss.extensions.api.component.AuthorComponentFactory;
import ro.sync.ecss.extensions.api.component.EditorComponentProvider;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.editor.page.author.WSAuthorEditorPage;
import ro.sync.exml.workspace.api.results.ResultsManager;
import ro.sync.exml.workspace.api.standalone.StandalonePluginWorkspace;

class RefactorProgressUpdaterImpl
implements RefactorProgressUpdater {
    private static final Logger log = LoggerFactory.getLogger(RefactorProgressUpdaterImpl.class);
    @NonNull
    private List<URL> listofFilesToRefactor;
    private AICompletionDetailsProvider aiCompletionProvider = null;
    private Optional<String> userPromptDescriptionFromDialog;
    private int currentIndexOfFileToRefactor = 0;
    private List<RefactoredContent> filesRefactored = new ArrayList<RefactoredContent>();
    private AIActionDetails actionToExecute;
    private boolean stopped = false;

    public RefactorProgressUpdaterImpl(AIActionDetails actionToExecute, Optional<String> customPromptToExecute, List<URL> filesToRefactor, AICompletionDetailsProvider aiCompletionProvider) {
        this.actionToExecute = actionToExecute;
        this.userPromptDescriptionFromDialog = customPromptToExecute;
        this.aiCompletionProvider = aiCompletionProvider;
        this.listofFilesToRefactor = filesToRefactor;
    }

    @Override
    public void cancel() {
        this.stopped = true;
    }

    @Override
    public int getCurrentNumberOfProcessedFiles() {
        return this.currentIndexOfFileToRefactor;
    }

    @Override
    public int getNumberOfFilesToProcess() {
        return this.listofFilesToRefactor.size();
    }

    @Override
    public void processFile() throws CannotComputeCompletionDetailsException {
        block7: {
            if (this.actionToExecute == null) {
                throw new CannotComputeCompletionDetailsException("The AI refactoring action is unavailable.");
            }
            URL fileToRefactor = null;
            try {
                fileToRefactor = URLUtil.correct((URL)this.listofFilesToRefactor.get(this.currentIndexOfFileToRefactor));
                if (log.isDebugEnabled()) {
                    log.debug("Start AI refactoring for: " + URLUtil.clearUserInfo((String)fileToRefactor.toExternalForm()));
                }
                if (this.isFileIgnoredByAIIgnore(fileToRefactor)) {
                    this.logToResultsPanel(fileToRefactor, Translator.getInstance().getTranslation("File_ignored_based_on_ai_ignore_settings"), 0);
                } else {
                    Reader contentReader = PluginWorkspaceProvider.getPluginWorkspace().getUtilAccess().createReader(fileToRefactor, null);
                    String initialContent = IOUtil.read((Reader)contentReader).toString();
                    String result = this.processContent(initialContent, fileToRefactor);
                    if (!this.stopped && result != null) {
                        this.getRefactoredFiles().add(new RefactoredContent(this.listofFilesToRefactor.get(this.currentIndexOfFileToRefactor), initialContent, result));
                    }
                }
            }
            catch (CannotComputeCompletionDetailsException | IOException | StoppedByUserException e) {
                this.logToResultsPanel(fileToRefactor, e.getMessage(), 2);
                if (!(e instanceof CannotComputeCompletionDetailsException) || !PositronServiceUtil.isBlockerCompletionException((CannotComputeCompletionDetailsException)((CannotComputeCompletionDetailsException)e))) break block7;
                throw (CannotComputeCompletionDetailsException)e;
            }
        }
        ++this.currentIndexOfFileToRefactor;
    }

    private void logToResultsPanel(URL fileToRefactor, String message, int severity) {
        DocumentPositionedInfo documentPositionedInfo = new DocumentPositionedInfo(severity, message);
        if (fileToRefactor != null) {
            documentPositionedInfo.setSystemID(fileToRefactor.toExternalForm());
        }
        PluginWorkspaceProvider.getPluginWorkspace().getResultsManager().addResult(Translator.getInstance().getTranslation("Refactor_Title"), documentPositionedInfo, ResultsManager.ResultType.PROBLEM, false, false);
    }

    private boolean isFileIgnoredByAIIgnore(URL fileToRefactor) {
        AiIgnoreManager aiIgnoreChecker = AiIgnoreManagerProvider.getAiIgnoreChecker();
        if (aiIgnoreChecker != null) {
            return aiIgnoreChecker.isIgnoredFromAiIgnoreFile(fileToRefactor);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    String processContent(String content, URL file) throws IOException, CannotComputeCompletionDetailsException, StoppedByUserException {
        String result = null;
        ArrayList<Message> aiMessages = new ArrayList<Message>();
        aiMessages.add(new Message(RoleType.USER, (MessageContent)new MessageTextContent(content)));
        EditorComponentProvider editorProvider = null;
        try {
            StandalonePluginWorkspace pluginWorkspace = (StandalonePluginWorkspace)PluginWorkspaceProvider.getPluginWorkspace();
            editorProvider = pluginWorkspace.createEditorComponentProvider(new String[]{"Author"}, "Author");
            DefaultContentInserterForAuthorPage contentInserter = null;
            if (editorProvider != null) {
                editorProvider.load(file, null);
                log.debug("File loaded in internal editor for refactoring.");
                WSAuthorEditorPage page = (WSAuthorEditorPage)editorProvider.getWSEditorAccess().getCurrentPage();
                contentInserter = new DefaultContentInserterForAuthorPage(page.getDocumentController(), page, message -> page.getAuthorAccess().getWorkspaceAccess().showErrorMessage(message), null){

                    public boolean previewReplaceSelectionWithSuggestion(String suggestion, boolean interpretingCompletionAsMarkup, int startOffset, int endOffset) {
                        return false;
                    }

                    public boolean previewInsert(int startOffset, int endOffset, String suggestion, List<InsertMode> insertModes, boolean asMarkup, boolean deleteSelection) {
                        return false;
                    }
                };
            }
            boolean isPseudoActionForCustomPrompt = "ai-based-refactoring".equals(this.actionToExecute.getId());
            Map actionExpandParams = ParamsExpander.expandParams((String)this.actionToExecute.getId(), (List)this.actionToExecute.getExpandParams(), contentInserter);
            if (isPseudoActionForCustomPrompt) {
                actionExpandParams.put("aiInstruction", this.userPromptDescriptionFromDialog.get());
            }
            AICompletionResponse aiResponse = this.aiCompletionProvider.executeAction(this.actionToExecute, aiMessages, actionExpandParams);
            if (log.isDebugEnabled()) {
                log.debug("Content returned by AI: " + aiResponse.getResponseContent() != null ? Integer.valueOf(aiResponse.getResponseContent().length()) : "null");
            }
            result = TextUtils.extractInsertionContentFromResponseForURL((String)aiResponse.getResponseContent(), (String)file.toExternalForm());
            if (log.isDebugEnabled()) {
                log.debug("Processed content before inserting it in internal editor: " + result != null ? Integer.valueOf(result.length()) : "null");
            }
            if (!isPseudoActionForCustomPrompt && this.actionToExecute.getComputedType() != ActionType.REPLACE_SELECTION) {
                result = this.getEntireContentsWithInsertedSuggestion(result, editorProvider, contentInserter);
            }
            if (log.isDebugEnabled()) {
                log.debug("Completion integrated in internal editor: " + result != null ? Integer.valueOf(result.length()) : "null");
            }
            if (editorProvider == null) return result;
        }
        catch (InvalidMessageException | IOException | BadLocationException | AuthorComponentException e) {
            String string;
            try {
                log.debug(e.getMessage(), e);
                PluginWorkspaceProvider.getPluginWorkspace().getResultsManager().addResult(Translator.getInstance().getTranslation("Refactor_Title"), new DocumentPositionedInfo(0, e.toString()), ResultsManager.ResultType.PROBLEM, false, false);
                string = null;
                if (editorProvider == null) return string;
            }
            catch (Throwable throwable) {
                if (editorProvider == null) throw throwable;
                AuthorComponentFactory.getInstance().disposeEditorComponentProvider(editorProvider);
                throw throwable;
            }
            AuthorComponentFactory.getInstance().disposeEditorComponentProvider(editorProvider);
            return string;
        }
        AuthorComponentFactory.getInstance().disposeEditorComponentProvider(editorProvider);
        return result;
    }

    private String getEntireContentsWithInsertedSuggestion(String resultFromServer, EditorComponentProvider editorProvider, DefaultContentInserterForAuthorPage contentInserter) throws BadLocationException, IOException {
        WSAuthorEditorPage page = (WSAuthorEditorPage)editorProvider.getWSEditorAccess().getCurrentPage();
        BaseActionInteractor interactor = ActionInteractorFactory.createActionInteractor((AIActionDetails)this.actionToExecute);
        log.debug("Use the following action interactor: " + interactor.getClass());
        interactor.setCompletionInserter((ContentInserter)contentInserter);
        interactor.setAiInitialSuggestion(resultFromServer, 0, page.getDocumentController().getAuthorDocumentNode().getEndOffset());
        if (interactor instanceof DefaultActionInteractor) {
            DefaultActionInteractor defaultInteractor = (DefaultActionInteractor)interactor;
            defaultInteractor.setDocumentExtractor((DocumentContentInteractor)new OpenAIPrefixExtractorForAuthorPage(page.getDocumentController(), page));
        }
        interactor.applyChangesToDocument(resultFromServer);
        return RefactorProgressUpdaterImpl.getContentResultFromDocument(editorProvider);
    }

    private static String getContentResultFromDocument(EditorComponentProvider editorCompProvider) throws IOException {
        Reader contentReaderOverResult = editorCompProvider.getWSEditorAccess().createContentReader();
        return IOUtil.read((Reader)contentReaderOverResult).toString();
    }

    @Override
    public boolean hasNextFile() {
        return !this.stopped && this.currentIndexOfFileToRefactor < this.listofFilesToRefactor.size();
    }

    public List<RefactoredContent> getRefactoredFiles() {
        return this.filesRefactored;
    }

    @Override
    public URL getCurrentFileThatIsBeingProcessed() {
        return this.hasNextFile() ? this.listofFilesToRefactor.get(this.currentIndexOfFileToRefactor) : null;
    }
}

