/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.refactoring;

import com.oxygenxml.positron.actions.dialog.internal.DialogType;
import com.oxygenxml.positron.actions.dialog.internal.MessageDialogBuilder;
import com.oxygenxml.positron.core.AiCompletionErrorInfoProvider;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.plugin.refactoring.RefactorProgressUpdater;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.net.URL;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import ro.sync.basic.util.BasicTextUtil;
import ro.sync.basic.util.URLUtil;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.standalone.ui.OKCancelDialog;

public class RefactorProgressDialog
extends OKCancelDialog {
    private static final int MAXIMUM_FILE_LENGTH = 50;
    private static final Translator TRANSLATOR = Translator.getInstance();
    private RefactorProgressUpdater updateInterface;
    private static final int DLG_MIN_WIDTH = 400;
    private JProgressBar progressBar;
    private JLabel currentProgressLabel;
    private JLabel currentFileLabel;
    private AiCompletionErrorInfoProvider errorProvider;

    public RefactorProgressDialog(RefactorProgressUpdater updateInterface, AiCompletionErrorInfoProvider errorProvider) {
        super(PluginWorkspaceProvider.getPluginWorkspace() != null ? (JFrame)PluginWorkspaceProvider.getPluginWorkspace().getParentFrame() : null, TRANSLATOR.getTranslation("Refactor_Title"), true);
        this.updateInterface = updateInterface;
        this.errorProvider = errorProvider;
        this.getOkButton().setVisible(false);
        this.setCancelButtonText(TRANSLATOR.getTranslation("Stop"));
        this.getContentPane().add(this.createMainPanel(updateInterface));
        this.setMinimumSize(new Dimension(400, (int)this.getPreferredSize().getHeight()));
        this.setPreferredSize(this.getPreferredSize());
        this.pack();
    }

    private JPanel createMainPanel(RefactorProgressUpdater updateInterface) {
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 1;
        gbc.anchor = 18;
        this.currentProgressLabel = new JLabel(this.getFormattedMessageFromUpdater());
        this.currentProgressLabel.setBorder(BorderFactory.createEmptyBorder());
        mainPanel.add((Component)this.currentProgressLabel, gbc);
        gbc.insets.top = 5;
        gbc.insets.bottom = 0;
        this.progressBar = new JProgressBar(0, updateInterface.getNumberOfFilesToProcess());
        ++gbc.gridy;
        gbc.fill = 2;
        mainPanel.add((Component)this.progressBar, gbc);
        this.currentFileLabel = new JLabel(this.getFormattedNameOfFileFromUpdater());
        this.currentFileLabel.setPreferredSize(new Dimension(400, (int)this.getPreferredSize().getHeight()));
        this.currentFileLabel.setBorder(BorderFactory.createEmptyBorder());
        ++gbc.gridy;
        mainPanel.add((Component)this.currentFileLabel, gbc);
        JPanel fillerPanel = new JPanel();
        ++gbc.gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.gridwidth = 1;
        gbc.fill = 1;
        mainPanel.add((Component)fillerPanel, gbc);
        return mainPanel;
    }

    private String getFormattedNameOfFileFromUpdater() {
        URL currentFileThatIsBeingProcessed = this.updateInterface.getCurrentFileThatIsBeingProcessed();
        if (currentFileThatIsBeingProcessed == null) {
            return null;
        }
        return BasicTextUtil.truncateName((String)URLUtil.getDescription((URL)currentFileThatIsBeingProcessed), (int)50);
    }

    private String getFormattedMessageFromUpdater() {
        return MessageFormat.format(TRANSLATOR.getTranslation("Refactor_Current_Progress"), this.updateInterface.getCurrentNumberOfProcessedFiles() + 1, this.updateInterface.getNumberOfFilesToProcess());
    }

    public void startRefactoring() {
        new Thread(){

            @Override
            public void run() {
                RefactorProgressDialog.this.refactorFilesInternal();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RefactorProgressDialog.this.doOK();
                    }
                });
            }
        }.start();
        this.setVisible(true);
    }

    protected void refactorFilesInternal() {
        try {
            while (this.updateInterface.hasNextFile()) {
                this.updateInterface.processFile();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RefactorProgressDialog.this.progressBar.setValue(RefactorProgressDialog.this.updateInterface.getCurrentNumberOfProcessedFiles());
                        RefactorProgressDialog.this.currentProgressLabel.setText(RefactorProgressDialog.this.getFormattedMessageFromUpdater());
                        RefactorProgressDialog.this.currentFileLabel.setText(RefactorProgressDialog.this.getFormattedNameOfFileFromUpdater());
                    }
                });
            }
        }
        catch (Throwable e) {
            this.showErrorDialog(e);
        }
    }

    protected void showErrorDialog(Throwable e) {
        MessageDialogBuilder messageDialogBuilder = new MessageDialogBuilder(Translator.getInstance().getTranslation("Error"), DialogType.ERROR);
        messageDialogBuilder = messageDialogBuilder.setLinks(this.errorProvider.computeErrorLink(e));
        messageDialogBuilder.setCancelButtonVisible(false).setMessage(this.errorProvider.getHumanReadableErrorMessageToPresent(e)).buildAndShow();
    }

    protected void doCancel() {
        this.updateInterface.cancel();
        super.doCancel();
    }
}

