/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.refactoring;

import com.google.common.annotations.VisibleForTesting;
import com.oxygenxml.positron.api.connector.dto.Pair;
import com.oxygenxml.positron.core.AICompletionDetailsProvider;
import com.oxygenxml.positron.core.AiCompletionErrorInfoProvider;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.plugin.completion.CompletionActionsManager;
import com.oxygenxml.positron.plugin.refactoring.RefactorDescriptionDialog;
import com.oxygenxml.positron.plugin.refactoring.RefactorProgressDialog;
import com.oxygenxml.positron.plugin.refactoring.RefactorProgressUpdaterImpl;
import com.oxygenxml.positron.plugin.refactoring.RefactoredContent;
import com.oxygenxml.positron.plugin.refactoring.RefactoringCostProviderImpl;
import com.oxygenxml.positron.plugin.refactoring.UnknownFilesProperties;
import com.oxygenxml.positron.utilities.json.AIActionDetails;
import com.oxygenxml.positron.utilities.json.ActionType;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.io.FileSystemUtil;
import ro.sync.basic.util.URLUtil;
import ro.sync.document.DocumentPositionedInfo;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.listeners.BatchOperationInfo;
import ro.sync.exml.workspace.api.listeners.BatchOperationsListener;
import ro.sync.exml.workspace.api.results.ResultsManager;
import ro.sync.exml.workspace.api.standalone.DiffAndMergeTools;
import ro.sync.exml.workspace.api.standalone.StandalonePluginWorkspace;
import ro.sync.exml.workspace.api.util.UtilAccess;

public class RefactorController {
    private static final Translator TRANSLATOR = Translator.getInstance();
    private static final Logger logger = LoggerFactory.getLogger(RefactorController.class);
    private AICompletionDetailsProvider aiCompletionProvider;
    private CompletionActionsManager completionActionsManager;

    public RefactorController(CompletionActionsManager completionActionsManager, AICompletionDetailsProvider aiCompletionProvider) {
        this.completionActionsManager = completionActionsManager;
        this.aiCompletionProvider = aiCompletionProvider;
    }

    public void refactorContent(List<URL> resources) {
        Optional<String> userPromptDescriptionFromDialog;
        RefactorDescriptionDialog promptDescriptionDialog = RefactorDescriptionDialog.getInstance();
        int userResult = promptDescriptionDialog.showDialog(RefactorController.getAIRefactoringSuitableActions(this.completionActionsManager.getCompletionActionsDetails()), new RefactoringCostProviderImpl(resources), this.completionActionsManager);
        if (userResult == 0) {
            return;
        }
        List<RefactoredContent> filesRefactored = this.refactor(resources = (List)RefactorController.getResourcesRecursively(resources).getFirst(), userPromptDescriptionFromDialog = Optional.of(promptDescriptionDialog.getPromptDescription()), promptDescriptionDialog.getActionToExecute());
        if (!filesRefactored.isEmpty()) {
            this.makeChangesToFiles(filesRefactored);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void makeChangesToFiles(List<RefactoredContent> filesRefactored) {
        List<URL> acceptedURLs = null;
        try {
            acceptedURLs = this.previewResourcesToModify(filesRefactored);
        }
        catch (Exception e1) {
            logger.error((Object)e1, (Throwable)e1);
        }
        if (acceptedURLs == null) {
            return;
        }
        BatchOperationsListener batchOperationsListener = null;
        try {
            StandalonePluginWorkspace pluginWorkspace = (StandalonePluginWorkspace)PluginWorkspaceProvider.getPluginWorkspace();
            Method method = PluginWorkspace.class.getMethod("getBatchOperationsListenersAccess", new Class[0]);
            batchOperationsListener = (BatchOperationsListener)method.invoke((Object)pluginWorkspace, null);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        if (batchOperationsListener != null) {
            batchOperationsListener.operationAboutToStart(new BatchOperationInfo(BatchOperationInfo.Type.REPLACE_ALL));
        }
        try {
            for (RefactoredContent content : filesRefactored) {
                URL fileToRefactorURL = content.getFileToRefactor();
                if (!acceptedURLs.contains(fileToRefactorURL)) continue;
                try {
                    content.applyAllChangesToResource(batchOperationsListener);
                }
                catch (IOException e) {
                    PluginWorkspaceProvider.getPluginWorkspace().getResultsManager().addResult(TRANSLATOR.getTranslation("Refactor_Title"), new DocumentPositionedInfo(0, e.toString()), ResultsManager.ResultType.GENERIC, false, false);
                }
            }
        }
        finally {
            if (batchOperationsListener != null) {
                batchOperationsListener.operationFinished(new BatchOperationInfo(BatchOperationInfo.Type.REPLACE_ALL));
            }
        }
    }

    private List<URL> previewResourcesToModify(List<RefactoredContent> filesRefactored) throws Exception {
        StandalonePluginWorkspace pluginWorkspace = (StandalonePluginWorkspace)PluginWorkspaceProvider.getPluginWorkspace();
        Method method = DiffAndMergeTools.class.getMethod("openPreviewDialog", String.class, String.class, LinkedHashMap.class);
        LinkedHashMap<URL, URL> filePairThatMightBeRefactored = new LinkedHashMap<URL, URL>();
        for (RefactoredContent content : filesRefactored) {
            try {
                URL temporaryFileWithUpdates = content.getTemporaryFileWithUpdates();
                filePairThatMightBeRefactored.put(URLUtil.correct((URL)content.getFileToRefactor()), temporaryFileWithUpdates);
            }
            catch (Exception e) {
                PluginWorkspaceProvider.getPluginWorkspace().getResultsManager().addResult(TRANSLATOR.getTranslation("Refactor_Title"), new DocumentPositionedInfo(0, e.toString()), ResultsManager.ResultType.GENERIC, false, false);
            }
        }
        List acceptedURLs = (List)method.invoke((Object)pluginWorkspace, TRANSLATOR.getTranslation("Refactor_Preview_Button"), TRANSLATOR.getTranslation("Refactor_Update_Button"), filePairThatMightBeRefactored);
        for (RefactoredContent content : filesRefactored) {
            content.deleteTempFile();
        }
        return acceptedURLs;
    }

    public static Pair<List<URL>, UnknownFilesProperties> getResourcesRecursively(List<URL> urlList) {
        PluginWorkspace pluginWorkspace = PluginWorkspaceProvider.getPluginWorkspace();
        UtilAccess utilAccess = pluginWorkspace.getUtilAccess();
        ArrayList<Object> collectedURLs = new ArrayList<Object>();
        for (URL url2 : urlList) {
            File fileFromFileUrl = URLUtil.getCanonicalFileFromFileUrl((URL)url2);
            if (fileFromFileUrl != null && fileFromFileUrl.isDirectory()) {
                ArrayList collectedFiles = new ArrayList();
                File[] fileArray = new File[]{fileFromFileUrl};
                FileSystemUtil.listRecursively((File[])fileArray, (boolean)false, null, collectedFiles);
                List mappedURLs = collectedFiles.stream().map(file -> {
                    try {
                        return utilAccess.convertFileToURL(file);
                    }
                    catch (MalformedURLException e) {
                        PluginWorkspaceProvider.getPluginWorkspace().getResultsManager().addResult(TRANSLATOR.getTranslation("Refactor_Title"), new DocumentPositionedInfo(0, e.toString()), ResultsManager.ResultType.GENERIC, false, false);
                        return null;
                    }
                }).filter(Objects::nonNull).collect(Collectors.toList());
                collectedURLs.addAll(mappedURLs);
                continue;
            }
            collectedURLs.add(url2);
        }
        UnknownFilesProperties unknownFileProperties = new UnknownFilesProperties(0);
        List xmlFileUrls = collectedURLs.stream().filter(url -> {
            boolean includeFile = false;
            boolean isBinaryResource = utilAccess.isUnhandledBinaryResourceURL(url);
            boolean isImageFile = utilAccess.isSupportedImageURL(url);
            String contentType = utilAccess.getContentType(url.toExternalForm());
            if (!isBinaryResource && !isImageFile) {
                if (contentType != null) {
                    includeFile = "text/xml".equals(contentType);
                } else {
                    unknownFileProperties.setNrOfFilesWithUnknownExtensions(unknownFileProperties.getNrOfFilesWithUnknownExtensions() + 1);
                }
            }
            return includeFile;
        }).collect(Collectors.toList());
        return new Pair(xmlFileUrls, (Object)unknownFileProperties);
    }

    @VisibleForTesting
    static List<AIActionDetails> getAIRefactoringSuitableActions(List<AIActionDetails> list) {
        return list.stream().filter(t -> !"action.translate.to.lang".equals(t.getId()) && (ActionType.INSERT_SCHEMA_AWARE == t.getComputedType() || ActionType.REPLACE_SELECTION == t.getComputedType())).collect(Collectors.toList());
    }

    private List<RefactoredContent> refactor(List<URL> list, Optional<String> userPromptDescriptionFromDialog, AIActionDetails actionToExecute) {
        RefactorProgressUpdaterImpl updateInterfaceImpl = new RefactorProgressUpdaterImpl(actionToExecute, userPromptDescriptionFromDialog, list, this.aiCompletionProvider);
        RefactorProgressDialog refactorProgressDialog = new RefactorProgressDialog(updateInterfaceImpl, (AiCompletionErrorInfoProvider)this.aiCompletionProvider);
        refactorProgressDialog.startRefactoring();
        return updateInterfaceImpl.getRefactoredFiles();
    }
}

