/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.recordexamples;

import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.plugin.recordexamples.ActionTypeComboBoxRenderer;
import com.oxygenxml.positron.plugin.recordexamples.PositronActionDetails;
import com.oxygenxml.positron.plugin.ui.LinkLabel;
import com.oxygenxml.positron.plugin.ui.MultilineLabel;
import com.oxygenxml.positron.plugin.util.IconsLoader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import ro.sync.basic.util.StringUtil;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.options.WSOptionChangedEvent;
import ro.sync.exml.workspace.api.options.WSOptionListener;
import ro.sync.exml.workspace.api.options.WSOptionsStorage;
import ro.sync.exml.workspace.api.standalone.ui.OKCancelDialog;
import ro.sync.exml.workspace.api.standalone.ui.OxygenUIComponentsFactory;
import ro.sync.exml.workspace.api.standalone.ui.TextField;
import ro.sync.exml.workspace.api.standalone.ui.ToolbarButton;
import ro.sync.exml.workspace.api.util.UtilAccess;

public class InstructionsSaverDialog
extends OKCancelDialog {
    private static final Translator TRANSLATOR = Translator.getInstance();
    private static final int DLG_MINIMUM_WIDTH = 375;
    private InstructionsSavingMode userDecision;
    private String instructionsText;
    private JTextArea instructionsTextArea;
    private TextField favoritePromptNameField;
    private TextField actionNameField;
    private JComboBox<PositronActionDetails.PositronActionType> actionTypeCombo;
    private TextField actionDescrField;
    private TextField actionLocationField;
    private WSOptionListener actionsFolderOptionListener = new WSOptionListener("oxygen.positron.plugin.actions.folder"){

        public void optionValueChanged(WSOptionChangedEvent event) {
            if (InstructionsSaverDialog.this.isShowing()) {
                String newActionFolderOptionValue = (String)event.getNewValueObject();
                UtilAccess utilAccess = PluginWorkspaceProvider.getPluginWorkspace().getUtilAccess();
                String actionsFolder = utilAccess.expandEditorVariables(newActionFolderOptionValue, null);
                String actionLocation = InstructionsSaverDialog.this.actionLocationField.getText();
                String actionFileName = actionLocation.substring(actionLocation.lastIndexOf(File.separator));
                InstructionsSaverDialog.this.actionLocationField.setText(actionsFolder + actionFileName);
            }
        }
    };

    public InstructionsSaverDialog(String promptText) {
        super(PluginWorkspaceProvider.getPluginWorkspace() != null ? (JFrame)PluginWorkspaceProvider.getPluginWorkspace().getParentFrame() : null, TRANSLATOR.getTranslation("Save_instructions"), true);
        this.instructionsText = promptText;
        this.setOkButtonText(TRANSLATOR.getTranslation("Save_instructions"));
        this.getContentPane().add(this.createMainPanel());
        this.setResizable(true);
        this.pack();
        this.setMinimumSize(new Dimension(375, (int)this.getPreferredSize().getHeight()));
    }

    private JPanel createMainPanel() {
        JPanel mainPanel = new JPanel(new GridBagLayout());
        JLabel promptCreatedLabel = new JLabel(TRANSLATOR.getTranslation("Following_instructions_with_examples_generated"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        mainPanel.add((Component)promptCreatedLabel, gbc);
        JPanel promptPanel = this.createInstructionsPanel();
        ++gbc.gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets.top = 5;
        mainPanel.add((Component)promptPanel, gbc);
        JLabel howToSavePromptLabel = new JLabel(TRANSLATOR.getTranslation("How_to_save_instructions_message"));
        ++gbc.gridy;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        gbc.insets.bottom = 5;
        mainPanel.add((Component)howToSavePromptLabel, gbc);
        JPanel radioButtonsPanel = this.createRadioButtonsPanel();
        ++gbc.gridy;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets.bottom = 11;
        mainPanel.add((Component)radioButtonsPanel, gbc);
        return mainPanel;
    }

    private JPanel createInstructionsPanel() {
        JPanel promptPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.instructionsTextArea = OxygenUIComponentsFactory.createTextArea((String)"");
        this.instructionsTextArea.setLineWrap(true);
        this.instructionsTextArea.setWrapStyleWord(true);
        this.instructionsTextArea.setText(this.instructionsText);
        JScrollPane scrollPane = OxygenUIComponentsFactory.createScrollPane((Component)this.instructionsTextArea, (int)20, (int)31);
        scrollPane.setPreferredSize(new Dimension(500, 200));
        promptPanel.add((Component)scrollPane, gbc);
        JPanel fillerPanel = new JPanel();
        ++gbc.gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 1;
        gbc.fill = 2;
        promptPanel.add((Component)fillerPanel, gbc);
        JPanel textAreaTolbarPanel = this.createInstructionsTextAreaToolbarPanel();
        ++gbc.gridx;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.anchor = 13;
        gbc.insets.top = 2;
        promptPanel.add((Component)textAreaTolbarPanel, gbc);
        return promptPanel;
    }

    private JPanel createInstructionsTextAreaToolbarPanel() {
        JPanel textAreaTolbarPanel = new JPanel();
        textAreaTolbarPanel.setLayout(new BoxLayout(textAreaTolbarPanel, 0));
        JButton copyButton = OxygenUIComponentsFactory.createToolbarButton((Action)new AbstractAction(TRANSLATOR.getTranslation("Edit_Copy"), IconsLoader.loadIcon("/images/Copy16.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                String text = InstructionsSaverDialog.this.instructionsTextArea.getText();
                if (text == null || text.trim().isEmpty()) {
                    PluginWorkspaceProvider.getPluginWorkspace().showErrorMessage(TRANSLATOR.getTranslation("No_content_to_copy"));
                } else {
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(new StringSelection(text), null);
                }
            }
        }, (boolean)false);
        textAreaTolbarPanel.add(copyButton);
        JButton reloadButton = OxygenUIComponentsFactory.createToolbarButton((Action)new AbstractAction(TRANSLATOR.getTranslation("Revert_to_original_instructions"), IconsLoader.loadIcon("/images/Refresh16.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                InstructionsSaverDialog.this.instructionsTextArea.setText(InstructionsSaverDialog.this.instructionsText);
            }
        }, (boolean)false);
        textAreaTolbarPanel.add(reloadButton);
        return textAreaTolbarPanel;
    }

    private JPanel createRadioButtonsPanel() {
        JPanel radioButtonsPanel = new JPanel(new GridBagLayout());
        final JRadioButton saveAsPositronActionRadioBtn = new JRadioButton(TRANSLATOR.getTranslation("As_positron_action_radio"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.gridwidth = 2;
        radioButtonsPanel.add((Component)saveAsPositronActionRadioBtn, gbc);
        JLabel actionNameLabel = new JLabel(TRANSLATOR.getTranslation("Name") + ":");
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.insets.left = 21;
        gbc.anchor = 17;
        gbc.insets.bottom = 7;
        radioButtonsPanel.add((Component)actionNameLabel, gbc);
        this.actionNameField = OxygenUIComponentsFactory.createTextField();
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.insets.left = 5;
        gbc.fill = 2;
        radioButtonsPanel.add((Component)this.actionNameField, gbc);
        this.actionNameField.getDocument().addDocumentListener(this.createActionNameFieldDocumentListener());
        JLabel actionDescrLabel = new JLabel(TRANSLATOR.getTranslation("Description") + ":");
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weightx = 0.0;
        gbc.insets.left = 21;
        gbc.fill = 0;
        radioButtonsPanel.add((Component)actionDescrLabel, gbc);
        this.actionDescrField = OxygenUIComponentsFactory.createTextField();
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.insets.right = 0;
        gbc.insets.left = 5;
        gbc.fill = 2;
        radioButtonsPanel.add((Component)this.actionDescrField, gbc);
        JLabel actionTypeLabel = new JLabel(TRANSLATOR.getTranslation("Action_Type") + ":");
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weightx = 0.0;
        gbc.insets.left = 21;
        gbc.fill = 0;
        radioButtonsPanel.add((Component)actionTypeLabel, gbc);
        this.actionTypeCombo = OxygenUIComponentsFactory.createComboBox(new DefaultComboBoxModel<PositronActionDetails.PositronActionType>(PositronActionDetails.PositronActionType.values()));
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.insets.left = 5;
        gbc.fill = 2;
        this.actionTypeCombo.setRenderer(new ActionTypeComboBoxRenderer(this.actionTypeCombo.getRenderer()));
        radioButtonsPanel.add(this.actionTypeCombo, gbc);
        JLabel actionLocationLabel = new JLabel(TRANSLATOR.getTranslation("Location") + ":");
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weightx = 0.0;
        gbc.insets.left = 21;
        gbc.fill = 0;
        radioButtonsPanel.add((Component)actionLocationLabel, gbc);
        JPanel actionLocationSubPanel = new JPanel(new GridBagLayout());
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.insets.right = 0;
        gbc.insets.left = 5;
        gbc.insets.bottom = 2;
        gbc.fill = 2;
        radioButtonsPanel.add((Component)actionLocationSubPanel, gbc);
        this.actionLocationField = OxygenUIComponentsFactory.createTextField();
        GridBagConstraints actionLocationGBC = new GridBagConstraints();
        actionLocationGBC.gridx = 0;
        actionLocationGBC.gridy = 0;
        actionLocationGBC.weightx = 1.0;
        actionLocationGBC.fill = 2;
        actionLocationGBC.anchor = 17;
        actionLocationSubPanel.add((Component)this.actionLocationField, actionLocationGBC);
        this.setInitialActionLocation();
        JButton locationBrowserButton = this.createBrowseForActionFileButton((JTextField)this.actionLocationField);
        ++actionLocationGBC.gridx;
        actionLocationGBC.weightx = 0.0;
        actionLocationGBC.fill = 0;
        actionLocationSubPanel.add((Component)locationBrowserButton, actionLocationGBC);
        this.addActionFolderOptionListener();
        DocumentListener actionFieldsDocListener = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.documentContentChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.documentContentChanged();
            }

            private void documentContentChanged() {
                if (!saveAsPositronActionRadioBtn.isSelected()) {
                    saveAsPositronActionRadioBtn.setSelected(true);
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        };
        this.actionNameField.getDocument().addDocumentListener(actionFieldsDocListener);
        this.actionDescrField.getDocument().addDocumentListener(actionFieldsDocListener);
        this.actionLocationField.getDocument().addDocumentListener(actionFieldsDocListener);
        JPanel fillerPanel = new JPanel();
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.insets.right = 0;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.insets.bottom = 5;
        radioButtonsPanel.add((Component)fillerPanel, gbc);
        JPanel actionLocationInfoPanel = new JPanel(new GridBagLayout());
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        radioButtonsPanel.add((Component)actionLocationInfoPanel, gbc);
        GridBagConstraints locationInfoGBC = new GridBagConstraints();
        locationInfoGBC.gridx = 0;
        locationInfoGBC.gridy = 0;
        locationInfoGBC.weightx = 1.0;
        locationInfoGBC.fill = 2;
        locationInfoGBC.anchor = 17;
        MultilineLabel actionLocationInfo = new MultilineLabel(TRANSLATOR.getTranslation("Positron_action_file_location_info"));
        Font font = actionLocationInfo.getFont();
        actionLocationInfo.setFont(font.deriveFont((float)font.getSize() - 1.0f));
        actionLocationInfoPanel.add((Component)actionLocationInfo, locationInfoGBC);
        LinkLabel goToPrefsLink = new LinkLabel(TRANSLATOR.getTranslation("Go_to_positron_preferences")){

            @Override
            public void performAction() {
                String preferencesPageKey = "Positron_addon_preferences_page";
                PluginWorkspaceProvider.getPluginWorkspace().showPreferencesPages(new String[]{preferencesPageKey}, preferencesPageKey, true);
            }
        };
        Font linkFont = goToPrefsLink.getFont();
        goToPrefsLink.setFont(linkFont.deriveFont((float)linkFont.getSize() - 1.0f));
        ++locationInfoGBC.gridy;
        locationInfoGBC.weightx = 0.0;
        locationInfoGBC.fill = 0;
        actionLocationInfoPanel.add((Component)goToPrefsLink, locationInfoGBC);
        final JRadioButton saveAsFavoritePromptRadioBtn = new JRadioButton(TRANSLATOR.getTranslation("As_favorite_prompt_radio"));
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 2;
        gbc.insets.left = 0;
        gbc.insets.bottom = 0;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        radioButtonsPanel.add((Component)saveAsFavoritePromptRadioBtn, gbc);
        JLabel favoritePromptNameLabel = new JLabel(TRANSLATOR.getTranslation("Name") + ":");
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.insets.left = 21;
        radioButtonsPanel.add((Component)favoritePromptNameLabel, gbc);
        this.favoritePromptNameField = OxygenUIComponentsFactory.createTextField();
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.insets.left = 5;
        gbc.fill = 2;
        radioButtonsPanel.add((Component)this.favoritePromptNameField, gbc);
        this.favoritePromptNameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.documentContentChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.documentContentChanged();
            }

            private void documentContentChanged() {
                if (!saveAsFavoritePromptRadioBtn.isSelected()) {
                    saveAsFavoritePromptRadioBtn.setSelected(true);
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        ButtonGroup group = new ButtonGroup();
        group.add(saveAsPositronActionRadioBtn);
        group.add(saveAsFavoritePromptRadioBtn);
        ItemListener itemListener = e -> {
            if (e.getStateChange() == 1) {
                Object eventSource = e.getSource();
                if (eventSource == saveAsPositronActionRadioBtn) {
                    this.userDecision = InstructionsSavingMode.AS_POSITRON_ACTION;
                } else if (eventSource == saveAsFavoritePromptRadioBtn) {
                    this.userDecision = InstructionsSavingMode.AS_FAVORITE_PROMPT;
                }
            }
        };
        saveAsPositronActionRadioBtn.addItemListener(itemListener);
        saveAsFavoritePromptRadioBtn.addItemListener(itemListener);
        saveAsPositronActionRadioBtn.setSelected(true);
        return radioButtonsPanel;
    }

    public JButton createBrowseForActionFileButton(final JTextField textField) {
        AbstractAction browseAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File actionFile = PluginWorkspaceProvider.getPluginWorkspace().chooseFile(new File(InstructionsSaverDialog.this.actionLocationField.getText()), TRANSLATOR.getTranslation("Positron_action_file"), new String[]{"json"}, null, true);
                if (actionFile != null) {
                    textField.setText(actionFile.getAbsolutePath());
                }
            }
        };
        ToolbarButton browseButton = new ToolbarButton((Action)browseAction, false);
        browseButton.setIcon((Icon)IconsLoader.loadIcon("/images/Open16.png"));
        return browseButton;
    }

    private void addActionFolderOptionListener() {
        PluginWorkspace pluginWorkspace = PluginWorkspaceProvider.getPluginWorkspace();
        WSOptionsStorage optionsStorage = pluginWorkspace.getOptionsStorage();
        optionsStorage.addOptionListener(this.actionsFolderOptionListener);
    }

    private DocumentListener createActionNameFieldDocumentListener() {
        return new DocumentListener(){

            private void updateActionFileName() {
                String actionLocation = InstructionsSaverDialog.this.actionLocationField.getText();
                actionLocation = actionLocation.substring(0, actionLocation.lastIndexOf(File.separator) + 1);
                String actionName = InstructionsSaverDialog.this.actionNameField.getText();
                String newFilename = actionName.trim().replaceAll(" +", " ").replace(" ", "_");
                InstructionsSaverDialog.this.actionLocationField.setText(actionLocation + newFilename + ".json");
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateActionFileName();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateActionFileName();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        };
    }

    private void setInitialActionLocation() {
        PluginWorkspace pluginWorkspace = PluginWorkspaceProvider.getPluginWorkspace();
        String dirToSaveIn = pluginWorkspace.getOptionsStorage().getOption("oxygen.positron.plugin.actions.folder", "");
        UtilAccess utilAccess = pluginWorkspace.getUtilAccess();
        dirToSaveIn = dirToSaveIn.isBlank() ? utilAccess.expandEditorVariables("${pd}", null) : utilAccess.expandEditorVariables(dirToSaveIn, null);
        File actionFile = new File(dirToSaveIn, "my_custom_action.json");
        this.actionLocationField.setText(actionFile.getAbsolutePath());
    }

    public int showDialog() {
        this.instructionsTextArea.requestFocusInWindow();
        this.setVisible(true);
        return this.getResult();
    }

    public InstructionsSavingMode getInstructionsSavingModeChosenByUser() {
        return this.userDecision;
    }

    public String getFavoritePromptName() {
        return this.favoritePromptNameField.getText().trim();
    }

    void setFavoritePromptName(String favPromptName) {
        this.favoritePromptNameField.setText(favPromptName);
    }

    void setPositronActionName(String actionName) {
        this.actionNameField.setText(actionName);
    }

    void setPositronActionDescription(String actionDescr) {
        this.actionDescrField.setText(actionDescr);
    }

    void setPositronActionFilepath(String actionFilepath) {
        this.actionLocationField.setText(actionFilepath);
    }

    public String getInstructionsText() {
        return this.instructionsTextArea.getText();
    }

    void setInstructionsText(String text) {
        this.instructionsTextArea.setText(text);
    }

    WSOptionListener getActionsFolderOptionListener() {
        return this.actionsFolderOptionListener;
    }

    String getPositronActionLocationFromField() {
        return this.actionLocationField.getText();
    }

    public PositronActionDetails getPositronActionDetails() {
        String actionLocation = this.actionLocationField.getText().trim();
        UtilAccess utilAccess = PluginWorkspaceProvider.getPluginWorkspace().getUtilAccess();
        actionLocation = utilAccess.expandEditorVariables(actionLocation, null);
        File actionFile = new File(actionLocation);
        return new PositronActionDetails(this.actionNameField.getText().trim(), this.actionDescrField.getText().trim(), actionFile);
    }

    protected void doOK() {
        File actionFile;
        boolean shouldAbortClosingDialog = false;
        PluginWorkspace pluginWS = PluginWorkspaceProvider.getPluginWorkspace();
        boolean areAllPositronActionFieldsValid = this.validateFields();
        boolean bl = shouldAbortClosingDialog = !areAllPositronActionFieldsValid;
        if (!shouldAbortClosingDialog && (actionFile = new File(this.actionLocationField.getText().trim())).exists()) {
            int confirmationResult = pluginWS.showConfirmDialog(TRANSLATOR.getTranslation("Save_instructions"), MessageFormat.format(TRANSLATOR.getTranslation("The_named_file_already_exists"), actionFile.getAbsolutePath()) + TRANSLATOR.getTranslation("Overwrite_it_question"), new String[]{TRANSLATOR.getTranslation("Overwrite"), TRANSLATOR.getTranslation("Cancel")}, new int[]{1, 0});
            boolean bl2 = shouldAbortClosingDialog = confirmationResult == 0;
        }
        if (shouldAbortClosingDialog) {
            return;
        }
        super.doOK();
    }

    private boolean validateFields() {
        boolean areAllFieldsValid = true;
        PluginWorkspace pluginWS = PluginWorkspaceProvider.getPluginWorkspace();
        String promptTextContent = this.instructionsTextArea.getText();
        if (promptTextContent.isBlank()) {
            pluginWS.showErrorMessage(TRANSLATOR.getTranslation("Instructions_mandatory"));
            areAllFieldsValid = false;
        } else if (this.getInstructionsSavingModeChosenByUser() == InstructionsSavingMode.AS_FAVORITE_PROMPT && this.getFavoritePromptName().isEmpty()) {
            pluginWS.showErrorMessage(TRANSLATOR.getTranslation("Favorite_prompt_name_required"));
            areAllFieldsValid = false;
        } else if (this.getInstructionsSavingModeChosenByUser() == InstructionsSavingMode.AS_POSITRON_ACTION) {
            if (!promptTextContent.contains("###")) {
                pluginWS.showErrorMessage(TRANSLATOR.getTranslation("Instructions_separator_missing_error_message") + "\n\n" + MessageFormat.format(TRANSLATOR.getTranslation("Expected_instructions_text_message"), this.getInstructionsFormatExampleForAction()));
                areAllFieldsValid = false;
            } else if (!this.areInputAndOutputExamplesSymmetric()) {
                pluginWS.showErrorMessage(TRANSLATOR.getTranslation("Wrong_examples_format") + "\n\n" + MessageFormat.format(TRANSLATOR.getTranslation("Expected_instructions_text_message"), this.getInstructionsFormatExampleForAction()));
                areAllFieldsValid = false;
            } else if (this.actionNameField.getText().isBlank()) {
                pluginWS.showErrorMessage(TRANSLATOR.getTranslation("Positron_action_name_required"));
                areAllFieldsValid = false;
            } else if (this.actionLocationField.getText().isBlank()) {
                pluginWS.showErrorMessage(TRANSLATOR.getTranslation("Positron_action_file_location_required"));
                areAllFieldsValid = false;
            }
        }
        return areAllFieldsValid;
    }

    private boolean areInputAndOutputExamplesSymmetric() {
        int outputOccurences;
        String prompt = this.instructionsTextArea.getText();
        int inputOccurences = StringUtil.countMatches((String)prompt, (String)"Input:");
        return inputOccurences == (outputOccurences = StringUtil.countMatches((String)prompt, (String)"Output:"));
    }

    private String getInstructionsFormatExampleForAction() {
        return "You are a technical documentation writer. Rewrite the following DITA XML content to change ordered lists to unordered lists, while preserving the rest of the XML structure unchanged.\n###\nInput: <ol><li>item</li></ol>\nOutput: <ul><li>item</li></ul>";
    }

    public PositronActionDetails.PositronActionType getUserActionType() {
        return (PositronActionDetails.PositronActionType)((Object)this.actionTypeCombo.getSelectedItem());
    }

    public static enum InstructionsSavingMode {
        AS_POSITRON_ACTION,
        AS_FAVORITE_PROMPT;

    }
}

