/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.recordexamples;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import com.oxygenxml.positron.plugin.CustomActionsLoader;
import com.oxygenxml.positron.plugin.chat.ChatUserInputInteractor;
import com.oxygenxml.positron.plugin.chat.favorites.FavoritesManager;
import com.oxygenxml.positron.plugin.recordexamples.DiffEntry;
import com.oxygenxml.positron.plugin.recordexamples.InstructionsSaverDialog;
import com.oxygenxml.positron.plugin.recordexamples.InstructionsWithExamples;
import com.oxygenxml.positron.plugin.recordexamples.PositronActionDetails;
import com.oxygenxml.positron.utilities.json.OutputAction;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.io.IOUtil;
import ro.sync.ecss.extensions.api.CancelledByUserException;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;

public class InstructionsSaver {
    private static final String EOL = "\n";
    private static final String INDENT = "  ";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)InstructionsSaver.class.getName());
    private static final String INPUT_AND_USER_SELECTION = "Input: ${selection}";
    static final String INPUT_LABEL = "Input:";
    static final String OUTPUT_LABEL = "Output:";
    static final String SEPARATOR = "###";
    private Supplier<CustomActionsLoader> customActionsLoaderSupplier;
    private FavoritesManager favoritesManager;
    private Supplier<ChatUserInputInteractor> chatUserInputInteractorSupplier;

    public InstructionsSaver(Supplier<CustomActionsLoader> customActionsLoaderSupplier, FavoritesManager favoritesManager, Supplier<ChatUserInputInteractor> chatUserInputInteractorSupplier) {
        this.customActionsLoaderSupplier = customActionsLoaderSupplier;
        this.favoritesManager = favoritesManager;
        this.chatUserInputInteractorSupplier = chatUserInputInteractorSupplier;
    }

    public void saveAsChosenByUser(InstructionsWithExamples prompt) throws CancelledByUserException, IOException {
        String serializedPrompt = this.serializeInstructionsWithExamples(prompt);
        InstructionsSaverDialog promptSaverDialog = new InstructionsSaverDialog(serializedPrompt);
        if (promptSaverDialog.showDialog() == 1) {
            String promptTextFromDlg = promptSaverDialog.getInstructionsText();
            InstructionsSaverDialog.InstructionsSavingMode promptUsageChosenByUser = promptSaverDialog.getInstructionsSavingModeChosenByUser();
            switch (promptUsageChosenByUser) {
                case AS_POSITRON_ACTION: {
                    PositronActionDetails positronActionDetails = promptSaverDialog.getPositronActionDetails();
                    positronActionDetails.setActionType(promptSaverDialog.getUserActionType());
                    this.saveAsPositronAction(this.deserializeInstructionsWithExamplesText(promptTextFromDlg), positronActionDetails);
                    try {
                        PluginWorkspaceProvider.getPluginWorkspace().open(positronActionDetails.getActionFile().toURI().toURL(), "Text");
                    }
                    catch (IOException e) {
                        LOGGER.error((Object)e, (Throwable)e);
                    }
                    break;
                }
                case AS_FAVORITE_PROMPT: {
                    this.favoritesManager.addFavoritePrompt(promptTextFromDlg, promptSaverDialog.getFavoritePromptName(), true);
                    this.chatUserInputInteractorSupplier.get().setUserInput(promptTextFromDlg);
                    break;
                }
            }
        } else {
            throw new CancelledByUserException();
        }
    }

    @VisibleForTesting
    InstructionsWithExamples deserializeInstructionsWithExamplesText(String text) {
        String[] split = text.split(SEPARATOR);
        String description = split[0].trim();
        String examplesText = split[1].trim();
        int indexOfUserSelectionInput = examplesText.indexOf(INPUT_AND_USER_SELECTION);
        if (indexOfUserSelectionInput != -1) {
            examplesText = examplesText.substring(0, indexOfUserSelectionInput).trim();
        }
        ArrayList<DiffEntry> examples = new ArrayList<DiffEntry>();
        while (!examplesText.isBlank()) {
            String input = examplesText.substring(0, examplesText.indexOf(OUTPUT_LABEL));
            int indexOfNextInput = (examplesText = examplesText.replace(input, "")).indexOf(INPUT_LABEL);
            String output = indexOfNextInput != -1 ? examplesText.substring(0, indexOfNextInput) : examplesText.substring(0);
            examplesText = examplesText.replace(output, "");
            examples.add(new DiffEntry(input.replace(INPUT_LABEL, "").trim(), output.replace(OUTPUT_LABEL, "").trim()));
        }
        return new InstructionsWithExamples(description, examples);
    }

    @VisibleForTesting
    void saveAsPositronAction(InstructionsWithExamples prompt, PositronActionDetails positronActionDetails) throws IOException {
        String jsonSerialization = this.serializeAsPositronActionJSON(prompt, positronActionDetails.getName(), positronActionDetails.getDescription(), positronActionDetails.getActionType());
        File actionFile = positronActionDetails.getActionFile();
        File parentFile = actionFile.getParentFile();
        if (parentFile != null && !parentFile.exists()) {
            parentFile.mkdirs();
        }
        IOUtil.saveInURLWithUTF8((URL)actionFile.toURI().toURL(), (String)jsonSerialization);
        this.customActionsLoaderSupplier.get().loadCustomActions();
    }

    @VisibleForTesting
    String serializeAsPositronActionJSON(InstructionsWithExamples prompt, String actionName, String actionDescr, PositronActionDetails.PositronActionType positronActionType) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
        DefaultPrettyPrinter pp = new DefaultPrettyPrinter().withObjectIndenter((DefaultPrettyPrinter.Indenter)new DefaultIndenter(INDENT, EOL));
        mapper.setDefaultPrettyPrinter((PrettyPrinter)pp);
        ArrayNode actions = mapper.createArrayNode();
        ObjectNode action = mapper.createObjectNode();
        String id = actionName.toLowerCase().trim().replaceAll(" +", " ").replace(" ", ".");
        action.put("id", id);
        action.put("title", actionName);
        if (!actionDescr.isBlank()) {
            action.put("description", actionDescr);
        }
        action.put("output-action", this.serializeActionType(positronActionType));
        action.put("prompt", prompt.getInstructionsText());
        ArrayNode exampleNodes = mapper.createArrayNode();
        List<DiffEntry> examples = prompt.getExamples();
        if (!examples.isEmpty()) {
            examples.forEach(diffEntry -> {
                ObjectNode example = mapper.createObjectNode();
                example.put("prompt", diffEntry.getInitialContent().replace(EOL, " "));
                example.put("completion", diffEntry.getModifiedContent().replace(EOL, " "));
                exampleNodes.add((JsonNode)example);
            });
            action.set("examples", (JsonNode)exampleNodes);
        }
        actions.add((JsonNode)action);
        return mapper.writer().writeValueAsString((Object)actions);
    }

    private String serializeActionType(PositronActionDetails.PositronActionType actionType) {
        return actionType == PositronActionDetails.PositronActionType.REPLACE_CONTENT ? OutputAction.REPLACE.toString() : OutputAction.INSERT.toString();
    }

    @VisibleForTesting
    String serializeInstructionsWithExamples(InstructionsWithExamples prompt) {
        StringBuilder strb = new StringBuilder();
        strb.append(prompt.getInstructionsText()).append(EOL);
        strb.append(SEPARATOR).append(EOL);
        prompt.getExamples().forEach(diffEntry -> {
            strb.append(INPUT_LABEL).append(EOL);
            strb.append(diffEntry.getInitialContent()).append(EOL);
            strb.append(OUTPUT_LABEL).append(EOL);
            strb.append(diffEntry.getModifiedContent()).append(EOL);
        });
        strb.append(INPUT_AND_USER_SELECTION).append(EOL);
        strb.append(OUTPUT_LABEL).append(EOL);
        return strb.toString();
    }
}

