/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.preferences;

import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.plugin.ui.TextAreaWithPlaceHolder;
import com.oxygenxml.positron.plugin.util.IconsLoader;
import com.oxygenxml.positron.plugin.util.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import ro.sync.exml.plugin.option.OptionPagePluginExtension;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.options.WSOptionChangedEvent;
import ro.sync.exml.workspace.api.options.WSOptionListener;
import ro.sync.exml.workspace.api.options.WSOptionsStorage;
import ro.sync.exml.workspace.api.standalone.ui.OxygenUIComponentsFactory;

public class SavedMemoriesOptionPageExtension
extends OptionPagePluginExtension {
    private static final Translator TRANSLATOR = Translator.getInstance();
    private JCheckBox enableMemory;
    private JTextArea memoryField;

    public JComponent init(PluginWorkspace pluginWorkspace) {
        Translator translator = Translator.getInstance();
        JPanel optionPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        JPanel memoryAndInfo = new JPanel(new FlowLayout(0, 0, 0));
        this.enableMemory = new JCheckBox(translator.getTranslation("Enable_memory_store") + ":");
        memoryAndInfo.add(this.enableMemory);
        this.enableMemory.addChangeListener(event -> this.memoryField.setEnabled(this.enableMemory.isSelected()));
        JButton linkButon = OxygenUIComponentsFactory.createToolbarButton((Action)new AbstractAction(TRANSLATOR.getTranslation("Saved_memories_info"), IconsLoader.loadIcon("/images/Info12.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                PluginWorkspaceProvider.getPluginWorkspace().showInformationMessage(TRANSLATOR.getTranslation("Saved_memories_info"));
            }
        }, (boolean)false);
        linkButon.setMargin(new Insets(1, 1, 1, 1));
        memoryAndInfo.add(linkButon);
        optionPanel.add((Component)memoryAndInfo, gbc);
        this.memoryField = new TextAreaWithPlaceHolder(TRANSLATOR.getTranslation("Saved_memories_info"));
        this.memoryField.setLineWrap(true);
        this.memoryField.setWrapStyleWord(true);
        this.memoryField.setToolTipText(TRANSLATOR.getTranslation("Saved_memories_info"));
        final WSOptionsStorage optionsStorage = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage();
        optionsStorage.addOptionListener(new WSOptionListener("oxygen.positron.plugin.memory"){

            public void optionValueChanged(WSOptionChangedEvent arg0) {
                SavedMemoriesOptionPageExtension.this.memoryField.setText(optionsStorage.getOption("oxygen.positron.plugin.memory", ""));
            }
        });
        gbc.insets.left = 5;
        gbc.insets.top = 10;
        ++gbc.gridy;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        JScrollPane memoryScrollPane = UIUtil.createScrollPane(this.memoryField, 20, 30);
        memoryScrollPane.setPreferredSize(new Dimension(memoryScrollPane.getPreferredSize().width, Math.max(60, memoryScrollPane.getPreferredSize().height)));
        optionPanel.add((Component)memoryScrollPane, gbc);
        this.loadPageState(pluginWorkspace);
        return optionPanel;
    }

    public void apply(PluginWorkspace pluginWorkspace) {
        WSOptionsStorage optionsStorage = pluginWorkspace.getOptionsStorage();
        if (optionsStorage != null) {
            optionsStorage.setOption("oxygen.positron.plugin.memory", this.memoryField.getText());
            optionsStorage.setOption("oxygen.positron.plugin.enable.memory", String.valueOf(this.enableMemory.isSelected()));
        }
    }

    private void loadPageState(PluginWorkspace pluginWorkspace) {
        WSOptionsStorage optionsStorage = pluginWorkspace.getOptionsStorage();
        if (optionsStorage != null) {
            this.enableMemory.setSelected(Boolean.valueOf(optionsStorage.getOption("oxygen.positron.plugin.enable.memory", "true")));
            this.memoryField.setText(optionsStorage.getOption("oxygen.positron.plugin.memory", ""));
            this.memoryField.setCaretPosition(0);
        }
    }

    public void restoreDefaults() {
        this.memoryField.setText("");
        this.enableMemory.setEnabled(true);
    }

    public String getTitle() {
        return Translator.getInstance().getTranslation("Saved_memories");
    }

    public String[] getProjectLevelOptionKeys() {
        return new String[]{"oxygen.positron.plugin.memory", "oxygen.positron.plugin.enable.memory"};
    }

    public String getKey() {
        return "saved_memories_preferences_page";
    }

    public String getHelpPageURL() {
        return "https://www.oxygenxml.com/doc/ug-positron-desktop/ai/saved_memories_preferences.html";
    }
}

