/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.preferences;

import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.functions.SAToolsExecutor;
import com.oxygenxml.positron.plugin.ui.MultilineLabel;
import com.oxygenxml.positron.plugin.util.IconsLoader;
import com.oxygenxml.positron.plugin.util.RAGFunctionsUtil;
import com.oxygenxml.positron.plugin.util.UIUtil;
import com.oxygenxml.positron.utilities.functions.FunctionsAndRAGHelperProvider;
import com.oxygenxml.positron.utilities.functions.IFunctionSignaturesRepository;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import ro.sync.basic.util.PlatformDetector;
import ro.sync.exml.plugin.option.OptionPagePluginExtension;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.options.WSOptionChangedEvent;
import ro.sync.exml.workspace.api.options.WSOptionListener;
import ro.sync.exml.workspace.api.options.WSOptionsStorage;
import ro.sync.exml.workspace.api.standalone.ui.OxygenUIComponentsFactory;

public class RAGConfigurationPage
extends OptionPagePluginExtension {
    private static final String HELP_PAGE_URL = "https://www.oxygenxml.com/doc/ug-positron-desktop/ai/tools_rag_preferences.html";
    private static final int TEXTAREA_HEIGHT_IN_ROWS = PlatformDetector.isMacOS() ? 5 : 7;
    private static final int PREFERRED_MAX_WIDTH_OF_PAGE = 300;
    private static final JCheckBox DUMMY_CHECKBOX = new JCheckBox();
    private static final int JCHECKBOX_WIDTH = RAGConfigurationPage.DUMMY_CHECKBOX.getPreferredSize().width;
    private static final Translator TRANSLATOR = Translator.getInstance();
    private SAToolsExecutor toolsExecutor = new SAToolsExecutor();
    private JCheckBox enableRAGCheckBox;
    private JCheckBox enableProjectWrite;
    private JCheckBox askConfirmationRAGCheckbox;
    private JCheckBox enableExternalRAGCheckBox;
    private JCheckBox enableFunctions;
    private JCheckBox projectRetrievalSandboxCheckbox;
    private JTextField limitContentTextField;
    private JTextField retrievalSandboxTextField;
    private JTextField webHelpFeedbackTokenTextField;
    private JTextField webHelpFeedbackDescriptionTextField;
    private MultilineLabel ragFunctions;
    private MultilineLabel writingFunctions;
    private JLabel limitContentLabel;
    private JPanel functionsDependentOptionsPanel;

    public JComponent init(PluginWorkspace pluginWorkspace) {
        JPanel mainPanel = new JPanel(new GridBagLayout());
        boolean isProjectSearchAPIAvailable = FunctionsAndRAGHelperProvider.getProjectRAGHelper().isRagAvailable();
        if (isProjectSearchAPIAvailable) {
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.fill = 2;
            gbc.anchor = 17;
            this.enableFunctions = new JCheckBox(TRANSLATOR.getTranslation("Enable_Rag_Functions"));
            this.enableFunctions.setToolTipText(TRANSLATOR.getTranslation("Enable_Rag_Functions_Tooltip"));
            this.enableFunctions.addChangeListener(e -> this.updateFunctionsDependentComponentsEnablingState());
            mainPanel.add((Component)this.enableFunctions, gbc);
            ++gbc.gridy;
            gbc.insets.top = 5;
            gbc.weightx = 1.0;
            gbc.gridwidth = 3;
            gbc.fill = 2;
            int leftInsetFromDummy = RAGConfigurationPage.DUMMY_CHECKBOX.getInsets().left;
            gbc.insets.left = JCHECKBOX_WIDTH - leftInsetFromDummy;
            this.functionsDependentOptionsPanel = this.createFunctionsDependentOptionsPanel();
            mainPanel.add((Component)this.functionsDependentOptionsPanel, gbc);
            this.initOptions();
            gbc.gridx = 0;
            ++gbc.gridy;
            gbc.gridwidth = 3;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.fill = 1;
            gbc.insets = UIUtil.getNoInsets();
            mainPanel.add((Component)new JPanel(), gbc);
        } else {
            mainPanel.setLayout(new GridLayout(1, 1));
            JComponent invalidVersionMsgLabel = OxygenUIComponentsFactory.createMultilineLabel((String)TRANSLATOR.getTranslation("Rag_Oxygen_Version_Error"), (boolean)false);
            mainPanel.add(invalidVersionMsgLabel);
        }
        mainPanel.setPreferredSize(new Dimension(300, mainPanel.getPreferredSize().height));
        return mainPanel;
    }

    private JPanel createFunctionsDependentOptionsPanel() {
        JPanel optionPanel = new JPanel(new GridBagLayout());
        final WSOptionsStorage optionsStorage = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage();
        optionPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.anchor = 17;
        this.enableRAGCheckBox = new JCheckBox(TRANSLATOR.getTranslation("Enable_Project_Rag")){

            @Override
            public JToolTip createToolTip() {
                return OxygenUIComponentsFactory.installMultilineTooltip((JComponent)RAGConfigurationPage.this.enableRAGCheckBox);
            }
        };
        this.enableRAGCheckBox.setToolTipText("<html>" + TRANSLATOR.getTranslation("Rag_Project_Checkbox_Explanation") + "<br/><a href=\"https://www.oxygenxml.com/doc/ug-positron-desktop/ai/tools_rag_preferences.html\">" + TRANSLATOR.getTranslation("Read_more") + "</a></html>");
        this.enableRAGCheckBox.addChangeListener(e -> this.updateEnableRAGCheckboxDependentComponents());
        optionPanel.add((Component)this.enableRAGCheckBox, gbc);
        ++gbc.gridy;
        gbc.insets.top = 5;
        gbc.weightx = 1.0;
        gbc.gridwidth = 3;
        gbc.fill = 2;
        int leftInsetFromDummy = RAGConfigurationPage.DUMMY_CHECKBOX.getInsets().left;
        gbc.insets.left = JCHECKBOX_WIDTH - leftInsetFromDummy;
        String ragExplanation = TRANSLATOR.getTranslation("Rag_Explanation") + "\n" + TRANSLATOR.getTranslation("Rag_Functions_List");
        optionPanel.add((Component)new MultilineLabel(ragExplanation), gbc);
        ++gbc.gridy;
        gbc.weightx = 1.0;
        gbc.gridwidth = 3;
        gbc.fill = 2;
        this.ragFunctions = new MultilineLabel(RAGFunctionsUtil.createRAGFunctionsEnumeration((IFunctionSignaturesRepository)this.toolsExecutor, true));
        this.ragFunctions.setLineWrap(false);
        JScrollPane scroll = OxygenUIComponentsFactory.createScrollPane((Component)this.ragFunctions, (int)22, (int)30);
        int fontHeight = scroll.getFontMetrics(scroll.getFont()).getHeight();
        int height = TEXTAREA_HEIGHT_IN_ROWS * fontHeight;
        scroll.setPreferredSize(new Dimension(scroll.getPreferredSize().width, height));
        scroll.setMinimumSize(new Dimension(scroll.getMinimumSize().width, height));
        optionPanel.add((Component)scroll, gbc);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.insets.top = 10;
        gbc.insets.left = JCHECKBOX_WIDTH - 2 * leftInsetFromDummy;
        this.askConfirmationRAGCheckbox = new JCheckBox(TRANSLATOR.getTranslation("Ask_confirm_functions"));
        optionsStorage.addOptionListener(new WSOptionListener("oxygen.positron.plugin.ask.confirmation.rag"){

            public void optionValueChanged(WSOptionChangedEvent arg0) {
                String value = optionsStorage.getOption("oxygen.positron.plugin.ask.confirmation.rag", Boolean.toString(true));
                RAGConfigurationPage.this.askConfirmationRAGCheckbox.setSelected(Boolean.parseBoolean(value));
            }
        });
        optionPanel.add((Component)this.askConfirmationRAGCheckbox, gbc);
        ++gbc.gridy;
        gbc.insets.top = 5;
        gbc.gridwidth = 1;
        gbc.insets.left = JCHECKBOX_WIDTH - leftInsetFromDummy;
        this.limitContentLabel = new JLabel(TRANSLATOR.getTranslation("Limit_Content_Rag") + ":");
        optionPanel.add((Component)this.limitContentLabel, gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.gridwidth = 2;
        gbc.insets.left = 5;
        this.limitContentTextField = OxygenUIComponentsFactory.createTextField();
        this.limitContentTextField.setToolTipText(TRANSLATOR.getTranslation("RAG_Limit_Tooltip"));
        optionPanel.add((Component)this.limitContentTextField, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets.top = 10;
        gbc.insets.left = 0;
        this.enableExternalRAGCheckBox = new JCheckBox(TRANSLATOR.getTranslation("External_RAG_sources"));
        optionPanel.add((Component)this.enableExternalRAGCheckBox, gbc);
        this.enableExternalRAGCheckBox.addChangeListener(e -> this.updateExternalRAGCheckboxDependentComponents());
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weightx = 0.0;
        gbc.insets.left = JCHECKBOX_WIDTH - leftInsetFromDummy;
        gbc.insets.top = 5;
        gbc.fill = 0;
        gbc.gridwidth = 1;
        JLabel wbTokenLabel = new JLabel(TRANSLATOR.getTranslation("Webhelp_Token_Label"));
        optionPanel.add((Component)wbTokenLabel, gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets.left = 5;
        gbc.fill = 2;
        this.webHelpFeedbackTokenTextField = OxygenUIComponentsFactory.createTextField();
        this.webHelpFeedbackTokenTextField.setToolTipText(TRANSLATOR.getTranslation("Webhelp_Token_Tooltip"));
        optionPanel.add((Component)this.webHelpFeedbackTokenTextField, gbc);
        ++gbc.gridx;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.insets.left = 3;
        gbc.weightx = 0.0;
        JButton linkButon = OxygenUIComponentsFactory.createToolbarButton((Action)new AbstractAction(TRANSLATOR.getTranslation("More_details"), IconsLoader.loadIcon("/images/Info12.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                PluginWorkspaceProvider.getPluginWorkspace().showInformationMessage(TRANSLATOR.getTranslation("Oxygen_feedback_token_explanation"));
            }
        }, (boolean)false);
        linkButon.setMargin(new Insets(1, 1, 1, 1));
        optionPanel.add((Component)linkButon, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.insets.left = JCHECKBOX_WIDTH - leftInsetFromDummy;
        gbc.gridwidth = 1;
        optionPanel.add((Component)new JLabel(TRANSLATOR.getTranslation("Webhelp_site_description")), gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.insets.left = 5;
        this.webHelpFeedbackDescriptionTextField = OxygenUIComponentsFactory.createTextField();
        this.webHelpFeedbackDescriptionTextField.setToolTipText(TRANSLATOR.getTranslation("Oxygen_feedback_RAG_description_tooltip"));
        optionPanel.add((Component)this.webHelpFeedbackDescriptionTextField, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.anchor = 17;
        gbc.insets.top = 10;
        gbc.insets.left = 0;
        this.enableProjectWrite = new JCheckBox(TRANSLATOR.getTranslation("Enable_writing_content_in_project"));
        this.enableProjectWrite.addChangeListener(e -> this.updateEnableProjectWriteDependentComponents());
        optionPanel.add((Component)this.enableProjectWrite, gbc);
        ++gbc.gridy;
        gbc.weightx = 1.0;
        gbc.gridwidth = 3;
        gbc.fill = 2;
        gbc.insets.top = 5;
        gbc.insets.left = JCHECKBOX_WIDTH - leftInsetFromDummy;
        String writeExplanation = TRANSLATOR.getTranslation("Project_write_Explanation") + "\n" + TRANSLATOR.getTranslation("Rag_Functions_List");
        optionPanel.add((Component)new MultilineLabel(writeExplanation), gbc);
        ++gbc.gridy;
        gbc.insets.top = 5;
        this.writingFunctions = new MultilineLabel(RAGFunctionsUtil.createRAGFunctionsEnumeration((IFunctionSignaturesRepository)this.toolsExecutor, false));
        this.writingFunctions.setLineWrap(false);
        scroll = OxygenUIComponentsFactory.createScrollPane((Component)this.writingFunctions, (int)22, (int)30);
        fontHeight = scroll.getFontMetrics(scroll.getFont()).getHeight();
        int height2 = TEXTAREA_HEIGHT_IN_ROWS * fontHeight;
        scroll.setPreferredSize(new Dimension(scroll.getPreferredSize().width, height2));
        scroll.setMinimumSize(new Dimension(scroll.getMinimumSize().width, height2));
        optionPanel.add((Component)scroll, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weightx = 0.0;
        gbc.insets.left = 0;
        gbc.insets.top = 5;
        gbc.fill = 0;
        gbc.gridwidth = 1;
        this.projectRetrievalSandboxCheckbox = new JCheckBox(TRANSLATOR.getTranslation("Project_retrieval_sandbox") + ":");
        optionPanel.add((Component)this.projectRetrievalSandboxCheckbox, gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.insets.left = 5;
        gbc.fill = 2;
        this.retrievalSandboxTextField = OxygenUIComponentsFactory.createTextField();
        this.retrievalSandboxTextField.setToolTipText(TRANSLATOR.getTranslation("Project_retrieval_sandbox_tooltip"));
        optionPanel.add((Component)this.retrievalSandboxTextField, gbc);
        this.projectRetrievalSandboxCheckbox.addChangeListener(e -> this.retrievalSandboxTextField.setEnabled(this.projectRetrievalSandboxCheckbox.isSelected()));
        return optionPanel;
    }

    private void updateEnableProjectWriteDependentComponents() {
        this.writingFunctions.setEnabled(this.enableProjectWrite.isSelected());
        this.updateEnabledForLimitReadWriteAccess();
    }

    private void updateExternalRAGCheckboxDependentComponents() {
        this.webHelpFeedbackTokenTextField.setEnabled(this.enableExternalRAGCheckBox.isSelected());
        this.webHelpFeedbackDescriptionTextField.setEnabled(this.enableExternalRAGCheckBox.isSelected());
    }

    private void updateEnabledForLimitReadWriteAccess() {
        boolean isProjectReadOrWriteEnabled = this.enableProjectWrite.isEnabled() && this.enableProjectWrite.isSelected() || this.enableRAGCheckBox.isEnabled() && this.enableRAGCheckBox.isSelected();
        this.projectRetrievalSandboxCheckbox.setEnabled(isProjectReadOrWriteEnabled);
        this.retrievalSandboxTextField.setEnabled(this.projectRetrievalSandboxCheckbox.isEnabled() && this.projectRetrievalSandboxCheckbox.isSelected());
    }

    private void updateEnableRAGCheckboxDependentComponents() {
        boolean enabledStateOfComponents = this.enableRAGCheckBox.isEnabled() && this.enableRAGCheckBox.isSelected();
        this.ragFunctions.setEnabled(enabledStateOfComponents);
        this.limitContentTextField.setEnabled(enabledStateOfComponents);
        this.askConfirmationRAGCheckbox.setEnabled(enabledStateOfComponents);
        this.limitContentLabel.setEnabled(enabledStateOfComponents);
        this.updateEnabledForLimitReadWriteAccess();
    }

    private void initOptions() {
        WSOptionsStorage optionsStorage = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage();
        if (optionsStorage != null) {
            String enableProjectValue = optionsStorage.getOption("oxygen.positron.plugin.enable.project.rag.for.chat.actions", Boolean.toString(true));
            this.enableRAGCheckBox.setSelected(Boolean.parseBoolean(enableProjectValue));
            String limitContentValue = optionsStorage.getOption("oxygen.positron.plugin.limit.content.rag", Integer.toString(15000));
            this.limitContentTextField.setText(limitContentValue);
            String sandboxValue = optionsStorage.getOption("oxygen.positron.plugin.retrieval.sandbox.rag", "${pdu}, ${rootMapDirURL}");
            this.retrievalSandboxTextField.setText(sandboxValue);
            String enableExternalRagValue = optionsStorage.getOption("oxygen.positron.plugin.enable.external.rag", Boolean.toString(true));
            this.enableExternalRAGCheckBox.setSelected(Boolean.parseBoolean(enableExternalRagValue));
            String token = optionsStorage.getOption("oxygen.positron.plugin.webhelp.token", "");
            this.webHelpFeedbackTokenTextField.setText(token);
            String description = optionsStorage.getOption("oxygen.positron.plugin.webhelp.site.description", "");
            this.webHelpFeedbackDescriptionTextField.setText(description);
            String enableWriteProject = optionsStorage.getOption("oxygen.positron.plugin.enable.project.write", Boolean.toString(true));
            this.enableProjectWrite.setSelected(Boolean.parseBoolean(enableWriteProject));
            String enableRAGPage = optionsStorage.getOption("oxygen.positron.plugin.enable.rag", Boolean.toString(true));
            this.enableFunctions.setSelected(Boolean.parseBoolean(enableRAGPage));
            String enableRAGSandbox = optionsStorage.getOption("oxygen.positron.plugin.enable.sandbox.rag", Boolean.toString(true));
            this.projectRetrievalSandboxCheckbox.setSelected(Boolean.parseBoolean(enableRAGSandbox));
            String askConfirmFunctions = optionsStorage.getOption("oxygen.positron.plugin.ask.confirmation.rag", Boolean.toString(true));
            this.askConfirmationRAGCheckbox.setSelected(Boolean.parseBoolean(askConfirmFunctions));
        }
        this.updateEnableRAGCheckboxDependentComponents();
        this.updateFunctionsDependentComponentsEnablingState();
    }

    private void updateFunctionsDependentComponentsEnablingState() {
        if (this.functionsDependentOptionsPanel != null) {
            UIUtil.setAllDescendantsEnabled(this.functionsDependentOptionsPanel, this.enableFunctions.isSelected());
            if (this.enableFunctions.isSelected()) {
                this.updateEnableRAGCheckboxDependentComponents();
                this.updateEnableProjectWriteDependentComponents();
                this.updateExternalRAGCheckboxDependentComponents();
            }
        }
    }

    public void apply(PluginWorkspace pluginWorkspace) {
        WSOptionsStorage optionsStorage = pluginWorkspace.getOptionsStorage();
        boolean isProjectSearchAPIAvailable = FunctionsAndRAGHelperProvider.getProjectRAGHelper().isRagAvailable();
        if (optionsStorage != null) {
            if (isProjectSearchAPIAvailable) {
                optionsStorage.setOption("oxygen.positron.plugin.enable.project.rag.for.chat.actions", String.valueOf(this.enableRAGCheckBox.isSelected()));
                optionsStorage.setOption("oxygen.positron.plugin.limit.content.rag", this.limitContentTextField.getText());
                optionsStorage.setOption("oxygen.positron.plugin.retrieval.sandbox.rag", this.retrievalSandboxTextField.getText());
            }
            optionsStorage.setOption("oxygen.positron.plugin.webhelp.token", this.webHelpFeedbackTokenTextField.getText());
            optionsStorage.setOption("oxygen.positron.plugin.webhelp.site.description", this.webHelpFeedbackDescriptionTextField.getText());
            optionsStorage.setOption("oxygen.positron.plugin.enable.external.rag", String.valueOf(this.enableExternalRAGCheckBox.isSelected()));
            optionsStorage.setOption("oxygen.positron.plugin.enable.project.write", String.valueOf(this.enableProjectWrite.isSelected()));
            optionsStorage.setOption("oxygen.positron.plugin.ask.confirmation.rag", String.valueOf(this.askConfirmationRAGCheckbox.isSelected()));
            optionsStorage.setOption("oxygen.positron.plugin.enable.rag", String.valueOf(this.enableFunctions.isSelected()));
            optionsStorage.setOption("oxygen.positron.plugin.enable.sandbox.rag", String.valueOf(this.projectRetrievalSandboxCheckbox.isSelected()));
        }
    }

    public void restoreDefaults() {
        this.enableRAGCheckBox.setSelected(true);
        this.limitContentTextField.setText(Integer.toString(15000));
        this.retrievalSandboxTextField.setText("${pdu}, ${rootMapDirURL}");
        this.enableExternalRAGCheckBox.setSelected(true);
        this.webHelpFeedbackTokenTextField.setText("");
        this.webHelpFeedbackDescriptionTextField.setText("");
        this.enableProjectWrite.setSelected(true);
        this.askConfirmationRAGCheckbox.setSelected(true);
        this.enableFunctions.setSelected(true);
        this.projectRetrievalSandboxCheckbox.setSelected(true);
    }

    public String getTitle() {
        return TRANSLATOR.getTranslation("RAG_Preference_Page");
    }

    public String getKey() {
        return "Positron_addon_rag_config_page";
    }

    public String[] getProjectLevelOptionKeys() {
        return new String[]{"oxygen.positron.plugin.enable.project.rag.for.chat.actions", "oxygen.positron.plugin.ask.confirmation.rag", "oxygen.positron.plugin.limit.content.rag", "oxygen.positron.plugin.retrieval.sandbox.rag", "oxygen.positron.plugin.enable.external.rag", "oxygen.positron.plugin.webhelp.token", "oxygen.positron.plugin.webhelp.site.description", "oxygen.positron.plugin.enable.project.write", "oxygen.positron.plugin.enable.rag", "oxygen.positron.plugin.enable.sandbox.rag"};
    }

    public String getHelpPageURL() {
        return HELP_PAGE_URL;
    }
}

