/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.preferences;

import com.oxygenxml.positron.core.plugin.OptionConstants;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.plugin.ui.SectionPane;
import com.oxygenxml.positron.plugin.ui.TextAreaWithPlaceHolder;
import com.oxygenxml.positron.plugin.util.IconsLoader;
import com.oxygenxml.positron.plugin.util.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import ro.sync.exml.plugin.option.OptionPagePluginExtension;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.options.WSOptionsStorage;
import ro.sync.exml.workspace.api.standalone.ui.OxygenUIComponentsFactory;
import ro.sync.exml.workspace.api.standalone.ui.TextField;

public class PositronOptionPageExtension
extends OptionPagePluginExtension {
    private static final Translator TRANSLATOR = Translator.getInstance();
    public static final int TEXT_FIELD_DEFAULT_WIDTH_LIMIT = 200;
    private JTextArea contextInfoInputField;
    private JCheckBox enablePositronFeaturesCheckBox;
    private TextField additionalContextFileFields;
    private JCheckBox autoValidateWholeDocCheckBox;
    private JCheckBox autoValidateInsertion;
    private JCheckBox autoValidateXMLFragmentCheckBox;

    public JComponent init(PluginWorkspace pluginWorkspace) {
        Translator translator = Translator.getInstance();
        JPanel optionPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        this.enablePositronFeaturesCheckBox = new JCheckBox(translator.getTranslation("Positron_Enable_Checkbox"));
        this.enablePositronFeaturesCheckBox.setToolTipText(translator.getTranslation("Positron_Enable_Checkbox_Tooltip"));
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.anchor = 17;
        gbc.gridwidth = 3;
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        gbc.fill = 2;
        optionPanel.add((Component)this.enablePositronFeaturesCheckBox, gbc);
        gbc.anchor = 17;
        ++gbc.gridy;
        gbc.insets.top = 10;
        gbc.insets.left = 0;
        JPanel contextAndInfo = new JPanel(new FlowLayout(0));
        contextAndInfo.add(new JLabel(translator.getTranslation("Context_prompt") + ":"));
        String contextDescription = TRANSLATOR.getTranslation("Context_Info_Label") + "\n\nE.g.:\n# Project context\nThe current DITA XML project contains technical documentation for repairing wind turbines.\n\n# Audience\nOur clients are technicians and their understanding of English may vary.\n\n# Style guide\n\nThere is a set of company-specific Style Guide rules that are important to follow when rewriting or creating new content. The most important rules are:\n\n- Avoid using metaphors, similes, or other figures of speech.\n- Avoid using a long word if a shorter one is sufficient.\n- Keep sentences short, eliminating words whenever possible.\n- Avoid using passive voice whenever active is possible.";
        JButton linkButon = OxygenUIComponentsFactory.createToolbarButton((Action)new AbstractAction(contextDescription, IconsLoader.loadIcon("/images/Info12.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                PluginWorkspaceProvider.getPluginWorkspace().showInformationMessage(TRANSLATOR.getTranslation("Context_Info_Label"));
            }
        }, (boolean)false);
        linkButon.setMargin(new Insets(1, 1, 1, 1));
        contextAndInfo.add(linkButon);
        optionPanel.add((Component)contextAndInfo, gbc);
        this.contextInfoInputField = new TextAreaWithPlaceHolder(contextDescription);
        this.contextInfoInputField.setLineWrap(true);
        this.contextInfoInputField.setWrapStyleWord(true);
        this.contextInfoInputField.setToolTipText(contextDescription);
        gbc.insets.left = 5;
        gbc.insets.top = 0;
        ++gbc.gridy;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        JScrollPane contextInfoScrollPane = UIUtil.createScrollPane(this.contextInfoInputField, 20, 30);
        contextInfoScrollPane.setPreferredSize(new Dimension(contextInfoScrollPane.getPreferredSize().width, Math.max(60, contextInfoScrollPane.getPreferredSize().height)));
        optionPanel.add((Component)contextInfoScrollPane, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets.left = 5;
        gbc.insets.top = 5;
        optionPanel.add((Component)new JLabel(Translator.getInstance().getTranslation("Additional_context_files") + ":"), gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        this.additionalContextFileFields = OxygenUIComponentsFactory.createTextField();
        this.additionalContextFileFields.setWidthLimit(200);
        this.additionalContextFileFields.setToolTipText(Translator.getInstance().getTranslation("Additional_context_files_info"));
        optionPanel.add((Component)this.additionalContextFileFields, gbc);
        ++gbc.gridx;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.insets.left = 5;
        optionPanel.add((Component)UIUtil.createBrowseForDirOrFileButton((JTextField)this.additionalContextFileFields, false), gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets.top = 10;
        optionPanel.add((Component)new SectionPane(TRANSLATOR.getTranslation("Automatic_Validation_Settings"), true), gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets.top = 5;
        gbc.anchor = 17;
        optionPanel.add((Component)new JLabel(TRANSLATOR.getTranslation("Auto_Validate_On_AI_Generation")), gbc);
        this.autoValidateWholeDocCheckBox = new JCheckBox(TRANSLATOR.getTranslation("Auto_Validate_AI_Document"));
        this.autoValidateWholeDocCheckBox.setToolTipText(TRANSLATOR.getTranslation("Auto_Validate_AI_Document_Tooltip"));
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets.left = 20;
        optionPanel.add((Component)this.autoValidateWholeDocCheckBox, gbc);
        this.autoValidateXMLFragmentCheckBox = new JCheckBox(TRANSLATOR.getTranslation("Auto_Validate_AI_Xml_Fragment"));
        this.autoValidateXMLFragmentCheckBox.setToolTipText(TRANSLATOR.getTranslation("Auto_Validate_AI_Xml_Fragment_Tooltip"));
        ++gbc.gridy;
        optionPanel.add((Component)this.autoValidateXMLFragmentCheckBox, gbc);
        this.autoValidateInsertion = new JCheckBox(TRANSLATOR.getTranslation("Auto_Validate_On_Insertion"));
        this.autoValidateInsertion.setToolTipText(TRANSLATOR.getTranslation("Auto_Validate_On_Insertion_Tooltip"));
        ++gbc.gridy;
        optionPanel.add((Component)this.autoValidateInsertion, gbc);
        this.loadPageState(pluginWorkspace);
        return optionPanel;
    }

    public void apply(PluginWorkspace pluginWorkspace) {
        WSOptionsStorage optionsStorage = pluginWorkspace.getOptionsStorage();
        if (optionsStorage != null) {
            optionsStorage.setOption("oxygen.positron.plugin.context.info", this.contextInfoInputField.getText());
            optionsStorage.setOption("oxygen.positron.plugin.additional.context.file", this.additionalContextFileFields.getText());
            optionsStorage.setOption("oxygen.positron.plugin.enable.positron", String.valueOf(this.enablePositronFeaturesCheckBox.isSelected()));
            optionsStorage.setOption("oxygen.positron.plugin.auto.validate.insertion", String.valueOf(this.autoValidateInsertion.isSelected()));
            optionsStorage.setOption("oxygen.positron.plugin.auto.validate.whole.document", String.valueOf(this.autoValidateWholeDocCheckBox.isSelected()));
            optionsStorage.setOption("oxygen.positron.plugin.auto.validate.xml.fragments", String.valueOf(this.autoValidateXMLFragmentCheckBox.isSelected()));
        }
    }

    private void loadPageState(PluginWorkspace pluginWorkspace) {
        WSOptionsStorage optionsStorage = pluginWorkspace.getOptionsStorage();
        if (optionsStorage != null) {
            this.contextInfoInputField.setText(optionsStorage.getOption("oxygen.positron.plugin.context.info", ""));
            this.contextInfoInputField.setCaretPosition(0);
            this.additionalContextFileFields.setText(optionsStorage.getOption("oxygen.positron.plugin.additional.context.file", "${pd}/ai-context.md, ${pd}/positron-ai/ai-context.md, ${pd}/positron-ai-actions/ai-context.md"));
            this.enablePositronFeaturesCheckBox.setSelected(Boolean.parseBoolean(optionsStorage.getOption("oxygen.positron.plugin.enable.positron", String.valueOf(Boolean.TRUE))));
            this.autoValidateInsertion.setSelected(Boolean.parseBoolean(optionsStorage.getOption("oxygen.positron.plugin.auto.validate.insertion", OptionConstants.AUTO_VALIDATE_INSERTION_DEFAULT)));
            this.autoValidateWholeDocCheckBox.setSelected(Boolean.parseBoolean(optionsStorage.getOption("oxygen.positron.plugin.auto.validate.whole.document", OptionConstants.AUTO_VALIDATE_WHOLE_DOCUMENT_DEFAULT)));
            this.autoValidateXMLFragmentCheckBox.setSelected(Boolean.parseBoolean(optionsStorage.getOption("oxygen.positron.plugin.auto.validate.xml.fragments", OptionConstants.AUTO_VALIDATE_XML_FRAGMENT_DEFAULT)));
        }
    }

    public void restoreDefaults() {
        this.contextInfoInputField.setText("");
        this.additionalContextFileFields.setText("${pd}/ai-context.md, ${pd}/positron-ai/ai-context.md, ${pd}/positron-ai-actions/ai-context.md");
        this.enablePositronFeaturesCheckBox.setSelected(true);
        this.autoValidateInsertion.setSelected(true);
        this.autoValidateWholeDocCheckBox.setSelected(true);
        this.autoValidateXMLFragmentCheckBox.setSelected(false);
    }

    public String getTitle() {
        return "Oxygen AI Positron";
    }

    public String[] getProjectLevelOptionKeys() {
        return new String[]{"oxygen.positron.plugin.additional.context.file", "oxygen.positron.plugin.context.info", "oxygen.positron.plugin.enable.positron", "oxygen.positron.plugin.auto.validate.insertion", "oxygen.positron.plugin.auto.validate.whole.document", "oxygen.positron.plugin.auto.validate.xml.fragments"};
    }

    public String getKey() {
        return "Positron_addon_preferences_page";
    }

    public String getHelpPageURL() {
        return "https://www.oxygenxml.com/doc/ug-positron-desktop/ai/preferences.html";
    }
}

