/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.preferences;

import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.mcp.MCPManager;
import com.oxygenxml.positron.mcp.MCPStatusListener;
import com.oxygenxml.positron.plugin.MCPInstaller;
import com.oxygenxml.positron.plugin.preferences.AcceptMCPLocalEULADialog;
import com.oxygenxml.positron.plugin.ui.MultilineLabel;
import com.oxygenxml.positron.plugin.util.IconsLoader;
import com.oxygenxml.positron.plugin.util.OxygenUtils;
import com.oxygenxml.positron.plugin.util.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import ro.sync.exml.plugin.option.OptionPagePluginExtension;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.options.WSOptionsStorage;
import ro.sync.exml.workspace.api.standalone.ui.OxygenUIComponentsFactory;
import ro.sync.exml.workspace.api.standalone.ui.TextField;

public class MCPOptionPageExtension
extends OptionPagePluginExtension {
    private static final int TEXT_FIELD_DEFAULT_WIDTH_LIMIT = 200;
    private TextField mcpConfigFileTextField;
    private JCheckBox mcpEnableLocalMCPServers;
    private JCheckBox mcpEnableRunningOxygenAsMCPServer;
    private TextField connectionTimeout;
    private JCheckBox addMCPToolsToAllChatModes;
    private MultilineLabel mcpStatus;
    private MCPStatusListener currentStatusListener;
    private static StringBuilder initialStatus = new StringBuilder();
    private static MCPManager mcpManager;

    public JComponent init(PluginWorkspace pluginWorkspace) {
        JPanel optionPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        this.addConfigSection(optionPanel, gbc);
        this.loadPageState(pluginWorkspace);
        return optionPanel;
    }

    private void addConfigSection(JPanel mainPanel, GridBagConstraints gbc) {
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        gbc.anchor = 17;
        gbc.insets = UIUtil.getNoInsets();
        gbc.insets.bottom = 10;
        final Translator translator = Translator.getInstance();
        mainPanel.add((Component)new MultilineLabel(translator.getTranslation("Model_Context_Protocol_Description")), gbc);
        gbc.fill = 0;
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        gbc.insets = UIUtil.getNoInsets();
        JLabel mcpConfigLabel = new JLabel(translator.getTranslation("MCP_Config_File_Label") + ":");
        mainPanel.add((Component)mcpConfigLabel, gbc);
        JPanel actionPathAndButton = new JPanel(new GridBagLayout());
        GridBagConstraints c1 = new GridBagConstraints();
        c1.gridx = 0;
        c1.gridy = 0;
        c1.gridwidth = 1;
        c1.weightx = 1.0;
        c1.fill = 2;
        c1.anchor = 17;
        this.mcpConfigFileTextField = OxygenUIComponentsFactory.createTextField();
        this.mcpConfigFileTextField.setWidthLimit(200);
        actionPathAndButton.add((Component)this.mcpConfigFileTextField, c1);
        ++c1.gridx;
        c1.weightx = 0.0;
        c1.fill = 0;
        c1.insets.left = 5;
        actionPathAndButton.add((Component)UIUtil.createBrowseForDirOrFileButton((JTextField)this.mcpConfigFileTextField, false, new String[]{"json"}), c1);
        ++gbc.gridx;
        gbc.gridwidth = 2;
        gbc.insets.left = 5;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        mainPanel.add((Component)actionPathAndButton, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.gridwidth = 3;
        gbc.anchor = 13;
        gbc.insets = UIUtil.getNoInsets();
        gbc.insets.bottom = 10;
        JLabel linkLabel = UIUtil.createLinkLabel(this.getHelpPageURL(), translator.getTranslation("Mcp_config_file_structure"));
        mainPanel.add((Component)linkLabel, gbc);
        gbc.weightx = 0.0;
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        gbc.anchor = 17;
        gbc.fill = 0;
        mainPanel.add((Component)new JLabel(translator.getTranslation("Connection_timeout") + ":"), gbc);
        ++gbc.gridx;
        gbc.weightx = 1.0;
        gbc.gridwidth = 2;
        gbc.insets.left = 5;
        gbc.fill = 2;
        this.connectionTimeout = OxygenUIComponentsFactory.createTextField();
        mainPanel.add((Component)this.connectionTimeout, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weightx = 0.0;
        gbc.gridwidth = 3;
        gbc.insets.left = 0;
        gbc.insets.bottom = 5;
        this.mcpEnableLocalMCPServers = new JCheckBox(translator.getTranslation("Allow_running_local_mcp_servers"));
        this.mcpEnableLocalMCPServers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MCPOptionPageExtension.this.mcpEnableLocalMCPServers.isSelected()) {
                    PluginWorkspaceProvider.getPluginWorkspace().showWarningMessage(translator.getTranslation("Allow_running_local_mcp_servers_warning"));
                }
            }
        });
        mainPanel.add((Component)this.mcpEnableLocalMCPServers, gbc);
        ++gbc.gridy;
        gbc.fill = 0;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.insets.bottom = 10;
        this.addMCPToolsToAllChatModes = new JCheckBox(translator.getTranslation("Add_mcp_tools_all_chat_modes"));
        mainPanel.add((Component)this.addMCPToolsToAllChatModes, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 3;
        gbc.fill = 1;
        gbc.insets.bottom = 5;
        JPanel statusAndReload = new JPanel(new FlowLayout(0, 2, 0));
        mainPanel.add((Component)statusAndReload, gbc);
        statusAndReload.add(OxygenUIComponentsFactory.createToolbarButton((Action)new AbstractAction(translator.getTranslation("Reload_mcp_servers"), IconsLoader.loadIcon("/images/Refresh16.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                MCPInstaller.reloadMCPServers();
            }
        }, (boolean)false));
        statusAndReload.add(new JLabel(translator.getTranslation("Model_Context_Protocol_Connection_Status") + ":"));
        gbc.weightx = 1.0;
        ++gbc.gridy;
        this.mcpStatus = new MultilineLabel(initialStatus.toString());
        JScrollPane scroll = OxygenUIComponentsFactory.createScrollPane((Component)this.mcpStatus, (int)20, (int)30);
        scroll.setPreferredSize(new Dimension(scroll.getPreferredSize().width, 280));
        if (mcpManager != null) {
            if (this.currentStatusListener != null) {
                mcpManager.removeStatusListener(this.currentStatusListener);
            }
            this.currentStatusListener = new MCPStatusListener(){

                public void statusUpdated(String details) {
                    MCPOptionPageExtension.this.mcpStatus.append(details);
                }

                public void startReloadingServers() {
                    MCPOptionPageExtension.this.mcpStatus.setText("");
                }
            };
            mcpManager.addStatusListener(this.currentStatusListener);
        }
        mainPanel.add((Component)scroll, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.weightx = 0.0;
        gbc.gridwidth = 3;
        gbc.insets.left = 0;
        gbc.insets.bottom = 5;
        this.mcpEnableRunningOxygenAsMCPServer = new JCheckBox(translator.getTranslation("Allow_running_oxygen_mcp_server") + " (Experimental)");
        this.mcpEnableRunningOxygenAsMCPServer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MCPOptionPageExtension.this.mcpEnableRunningOxygenAsMCPServer.isSelected()) {
                    AcceptMCPLocalEULADialog eulaDialog = new AcceptMCPLocalEULADialog();
                    eulaDialog.setVisible(true);
                    int result = eulaDialog.getResult();
                    if (result != 1) {
                        MCPOptionPageExtension.this.mcpEnableRunningOxygenAsMCPServer.setSelected(false);
                    }
                }
            }
        });
        if (OxygenUtils.getCurrentMajorVersion() > 27) {
            mainPanel.add((Component)this.mcpEnableRunningOxygenAsMCPServer, gbc);
        }
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 3;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.insets = UIUtil.getNoInsets();
        mainPanel.add((Component)new JPanel(), gbc);
    }

    public void apply(PluginWorkspace pluginWorkspace) {
        WSOptionsStorage optionsStorage = pluginWorkspace.getOptionsStorage();
        if (optionsStorage != null) {
            optionsStorage.setOption("oxygen.positron.plugin.mcp.config.file", this.mcpConfigFileTextField.getText());
            optionsStorage.setOption("oxygen.positron.plugin.mcp.local.servers.enable", String.valueOf(this.mcpEnableLocalMCPServers.isSelected()));
            optionsStorage.setOption("oxygen.positron.plugin.mcp.timeout", this.connectionTimeout.getText());
            optionsStorage.setOption("oxygen.positron.plugin.mcp.add.tools.all.chatmodes", String.valueOf(this.addMCPToolsToAllChatModes.isSelected()));
            optionsStorage.setOption("oxygen.positron.plugin.mcp.oxygen.app.mcp.server.enable", String.valueOf(this.mcpEnableRunningOxygenAsMCPServer.isSelected()));
        }
    }

    private void loadPageState(PluginWorkspace pluginWorkspace) {
        WSOptionsStorage optionsStorage = pluginWorkspace.getOptionsStorage();
        if (optionsStorage != null) {
            this.mcpConfigFileTextField.setText(optionsStorage.getOption("oxygen.positron.plugin.mcp.config.file", "${pd}/positron-ai-actions/mcp-config.json"));
            this.mcpEnableLocalMCPServers.setSelected(Boolean.valueOf(optionsStorage.getOption("oxygen.positron.plugin.mcp.local.servers.enable", "false")));
            this.connectionTimeout.setText(optionsStorage.getOption("oxygen.positron.plugin.mcp.timeout", "10"));
            this.addMCPToolsToAllChatModes.setSelected(Boolean.valueOf(optionsStorage.getOption("oxygen.positron.plugin.mcp.add.tools.all.chatmodes", "true")));
            this.mcpEnableRunningOxygenAsMCPServer.setSelected(Boolean.valueOf(optionsStorage.getOption("oxygen.positron.plugin.mcp.oxygen.app.mcp.server.enable", "false")));
        }
    }

    public void restoreDefaults() {
        this.mcpConfigFileTextField.setText("${pd}/positron-ai-actions/mcp-config.json");
        this.mcpEnableLocalMCPServers.setSelected(Boolean.valueOf("false"));
        this.connectionTimeout.setText("10");
        this.addMCPToolsToAllChatModes.setSelected(Boolean.valueOf("true"));
        this.mcpEnableRunningOxygenAsMCPServer.setSelected(Boolean.valueOf("false"));
    }

    public String getTitle() {
        return Translator.getInstance().getTranslation("Model_Context_Protocol");
    }

    public String[] getProjectLevelOptionKeys() {
        return new String[]{"oxygen.positron.plugin.mcp.config.file", "oxygen.positron.plugin.mcp.local.servers.enable", "oxygen.positron.plugin.mcp.timeout", "oxygen.positron.plugin.mcp.add.tools.all.chatmodes"};
    }

    public String getKey() {
        return "mcp_preferences_page";
    }

    public String getHelpPageURL() {
        return "https://www.oxygenxml.com/doc/ug-positron-desktop/ai/model_context_protocol_preferences.html";
    }

    public static void setMCPManager(MCPManager mcpManager) {
        MCPOptionPageExtension.mcpManager = mcpManager;
        mcpManager.addStatusListener(new MCPStatusListener(){

            public void statusUpdated(String details) {
                initialStatus.append(details);
            }

            public void startReloadingServers() {
                initialStatus.setLength(0);
            }
        });
    }
}

