/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.preferences;

import com.oxygenxml.positron.connector.ConnectorConfigurationData;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.plugin.preferences.ConnectionTableModel;
import com.oxygenxml.positron.plugin.util.IconsLoader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.TableModel;
import ro.sync.exml.workspace.api.standalone.ui.OxygenUIComponentsFactory;
import ro.sync.exml.workspace.api.standalone.ui.Table;

public class ConnectionTablePanel
extends JPanel {
    private static final Translator TRANSLATOR = Translator.getInstance();
    private ConnectionTableModel model;
    private JTable table;
    private JButton addButton;
    private JButton editButton;
    private JButton deleteButton;
    private JButton upButton;
    private JButton downButton;
    private AddConnectionListener addConnectionListener;
    private EditConnectionListener editConnectionListener;

    public ConnectionTablePanel(List<ConnectorConfigurationData> initialConnections) {
        super(new GridBagLayout());
        this.initializeComponents(initialConnections);
        this.layoutComponents();
    }

    private void initializeComponents(List<ConnectorConfigurationData> initialConnections) {
        this.model = new ConnectionTableModel();
        this.table = this.createTable();
        if (initialConnections != null) {
            this.model.setConnections(initialConnections);
        }
        AbstractAction addAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ConnectionTablePanel.this.addConnectionListener != null) {
                    ConnectionTablePanel.this.addConnectionListener.onAddConnection();
                }
            }
        };
        addAction.putValue("SmallIcon", IconsLoader.loadIcon("/images/Add16.png"));
        addAction.putValue("ShortDescription", TRANSLATOR.getTranslation("Add"));
        AbstractAction editAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedRow = ConnectionTablePanel.this.table.getSelectedRow();
                if (selectedRow >= 0 && ConnectionTablePanel.this.editConnectionListener != null) {
                    ConnectorConfigurationData connectionData = ConnectionTablePanel.this.model.getConnectionAt(selectedRow);
                    ConnectionTablePanel.this.editConnectionListener.onEditConnection(connectionData);
                }
            }
        };
        editAction.putValue("SmallIcon", IconsLoader.loadIcon("/images/Wrench16.png"));
        editAction.putValue("ShortDescription", TRANSLATOR.getTranslation("Edit"));
        AbstractAction deleteAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedRow = ConnectionTablePanel.this.table.getSelectedRow();
                if (selectedRow >= 0) {
                    ConnectionTablePanel.this.model.deleteConnection(selectedRow);
                    ConnectionTablePanel.this.updateButtonStates();
                }
            }
        };
        deleteAction.putValue("SmallIcon", IconsLoader.loadIcon("/images/Remove16.png"));
        deleteAction.putValue("ShortDescription", TRANSLATOR.getTranslation("Delete"));
        AbstractAction upAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedRow = ConnectionTablePanel.this.table.getSelectedRow();
                if (selectedRow > 0) {
                    ConnectionTablePanel.this.model.moveConnectionUp(selectedRow);
                    ConnectionTablePanel.this.table.setRowSelectionInterval(selectedRow - 1, selectedRow - 1);
                    ConnectionTablePanel.this.updateButtonStates();
                }
            }
        };
        upAction.putValue("SmallIcon", IconsLoader.loadIcon("/images/UpArrowYellow16.png"));
        upAction.putValue("ShortDescription", TRANSLATOR.getTranslation("Move_Up"));
        AbstractAction downAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedRow = ConnectionTablePanel.this.table.getSelectedRow();
                if (selectedRow >= 0 && selectedRow < ConnectionTablePanel.this.model.getRowCount() - 1) {
                    ConnectionTablePanel.this.model.moveConnectionDown(selectedRow);
                    ConnectionTablePanel.this.table.setRowSelectionInterval(selectedRow + 1, selectedRow + 1);
                    ConnectionTablePanel.this.updateButtonStates();
                }
            }
        };
        downAction.putValue("SmallIcon", IconsLoader.loadIcon("/images/DownArrowYellow16.png"));
        downAction.putValue("ShortDescription", TRANSLATOR.getTranslation("Move_Down"));
        this.addButton = OxygenUIComponentsFactory.createToolbarButton((Action)addAction, (boolean)false);
        this.editButton = OxygenUIComponentsFactory.createToolbarButton((Action)editAction, (boolean)false);
        this.deleteButton = OxygenUIComponentsFactory.createToolbarButton((Action)deleteAction, (boolean)false);
        this.upButton = OxygenUIComponentsFactory.createToolbarButton((Action)upAction, (boolean)false);
        this.downButton = OxygenUIComponentsFactory.createToolbarButton((Action)downAction, (boolean)false);
        this.editButton.setEnabled(false);
        this.deleteButton.setEnabled(false);
        this.upButton.setEnabled(false);
        this.downButton.setEnabled(false);
    }

    private JTable createTable() {
        Table connectionsTable = OxygenUIComponentsFactory.createTable((TableModel)this.model);
        connectionsTable.setFillsViewportHeight(true);
        connectionsTable.setSelectionMode(0);
        connectionsTable.getTableHeader().setReorderingAllowed(false);
        connectionsTable.getTableHeader().setVisible(true);
        connectionsTable.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                this.updateButtonStates();
            }
        });
        connectionsTable.addMouseListener(new MouseAdapter((JTable)connectionsTable){
            final /* synthetic */ JTable val$connectionsTable;
            {
                this.val$connectionsTable = jTable;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                int selectedRow;
                if (e.getClickCount() == 2 && ConnectionTablePanel.this.editConnectionListener != null && (selectedRow = this.val$connectionsTable.getSelectedRow()) >= 0) {
                    ConnectorConfigurationData connectionData = ConnectionTablePanel.this.model.getConnectionAt(selectedRow);
                    ConnectionTablePanel.this.editConnectionListener.onEditConnection(connectionData);
                }
            }
        });
        return connectionsTable;
    }

    private void layoutComponents() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.anchor = 17;
        gbc.insets = new Insets(0, 0, 5, 0);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        JScrollPane tableScrollPane = new JScrollPane(this.table);
        tableScrollPane.setPreferredSize(new Dimension(400, 150));
        this.add((Component)tableScrollPane, gbc);
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 0, 0);
        ++gbc.gridy;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        this.add((Component)this.createButtonsPanel(), gbc);
    }

    private JPanel createButtonsPanel() {
        JPanel buttonsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        buttonsPanel.add((Component)new JPanel(), gbc);
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        toolBar.setOpaque(false);
        toolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        toolBar.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        ++gbc.gridx;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.anchor = 13;
        buttonsPanel.add((Component)toolBar, gbc);
        toolBar.add(this.addButton);
        toolBar.add(this.editButton);
        toolBar.add(this.deleteButton);
        toolBar.add(Box.createHorizontalStrut(3));
        toolBar.add(new JToolBar.Separator());
        toolBar.add(Box.createHorizontalStrut(3));
        toolBar.add(this.upButton);
        toolBar.add(this.downButton);
        return buttonsPanel;
    }

    private void updateButtonStates() {
        int selectedRow = this.table.getSelectedRow();
        boolean hasSelection = selectedRow >= 0;
        boolean isEnabled = this.table.isEnabled();
        int rowCount = this.model.getRowCount();
        this.editButton.setEnabled(hasSelection && isEnabled);
        this.deleteButton.setEnabled(hasSelection && isEnabled);
        this.upButton.setEnabled(hasSelection && isEnabled && selectedRow > 0);
        this.downButton.setEnabled(hasSelection && isEnabled && selectedRow < rowCount - 1);
    }

    public ConnectionTableModel getModel() {
        return this.model;
    }

    public void setAddConnectionListener(AddConnectionListener listener) {
        this.addConnectionListener = listener;
    }

    public void setEditConnectionListener(EditConnectionListener listener) {
        this.editConnectionListener = listener;
    }

    public void addConnection(ConnectorConfigurationData configData) {
        this.model.addConnection(configData);
    }

    public ConnectorConfigurationData getSelectedConnection() {
        int selectedRow = this.table.getSelectedRow();
        if (selectedRow >= 0) {
            return this.model.getConnectionAt(selectedRow);
        }
        return null;
    }

    public static interface AddConnectionListener {
        public void onAddConnection();
    }

    public static interface EditConnectionListener {
        public void onEditConnection(ConnectorConfigurationData var1);
    }
}

