/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.oauth;

import com.oxygenxml.positron.connector.auth.OAuthAuthorizationCodeManager;
import com.oxygenxml.positron.connector.auth.OAuthAuthorizationListener;
import com.oxygenxml.positron.connector.auth.OAuthCodeFlowHelper;
import com.oxygenxml.positron.plugin.oauth.DesktopOAuthAuthorizationDialog;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.options.WSOptionsStorage;

public class DesktopOAuthAuthorizationCodeProvider
implements OAuthCodeFlowHelper {
    private static final Logger log = LoggerFactory.getLogger(DesktopOAuthAuthorizationCodeProvider.class);
    private final OAuthAuthorizationCodeManager authorizationManager = new OAuthAuthorizationCodeManager();

    public CompletableFuture<String> startAuthorization(String title, String description, String authorizationUrl, String redirectUri) {
        DesktopOAuthAuthorizationDialog currentDialog = new DesktopOAuthAuthorizationDialog(title, description, this.authorizationManager);
        CompletableFuture authorizationFuture = this.authorizationManager.prepareAuthorization(authorizationUrl, redirectUri, (OAuthAuthorizationListener)currentDialog);
        currentDialog.showDialog();
        return authorizationFuture;
    }

    public void saveAccessToken(String serviceName, String token) {
        WSOptionsStorage options = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage();
        String storageKey = "oxygen.positron.plugin.oauth.access.token." + serviceName;
        String encryptedToken = PluginWorkspaceProvider.getPluginWorkspace().getUtilAccess().encrypt(token);
        options.setOption(storageKey, encryptedToken);
    }

    public String loadAccessToken(String serviceName) {
        String storageKey;
        WSOptionsStorage options = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage();
        String encryptedToken = options.getOption(storageKey = "oxygen.positron.plugin.oauth.access.token." + serviceName, null);
        if (encryptedToken == null) {
            return null;
        }
        return PluginWorkspaceProvider.getPluginWorkspace().getUtilAccess().decrypt(encryptedToken);
    }

    public void clearAccessToken(String serviceName) {
        WSOptionsStorage options = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage();
        String storageKey = "oxygen.positron.plugin.oauth.access.token." + serviceName;
        options.setOption(storageKey, null);
    }

    public OAuthAuthorizationCodeManager getAuthorizationManager() {
        return this.authorizationManager;
    }
}

