/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.license;

import com.google.common.collect.ImmutableSet;
import com.oxygenxml.ai.positron.license.EnterpriseLicenseChecker;
import com.oxygenxml.ai.positron.license.exception.InvalidLicenseException;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.plugin.license.AskForLicensDialogProvider;
import com.oxygenxml.positron.plugin.license.AskForLicenseDialogInterface;
import com.oxygenxml.positron.plugin.license.DefaultLicenseInfoProvider;
import com.oxygenxml.positron.plugin.license.DirectConnectionLicenseChangedListener;
import com.oxygenxml.positron.plugin.license.LicenseInfoProvider;
import com.oxygenxml.positron.plugin.util.SecurityHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.license.LicenseInformationProvider;

public class DirectConnectionLicenseManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DirectConnectionLicenseManager.class);
    private final List<DirectConnectionLicenseChangedListener> directConnectionLicenseChangedListeners = new ArrayList<DirectConnectionLicenseChangedListener>();
    private final LicenseInfoProvider licenseInfoProvider = new DefaultLicenseInfoProvider();
    private static final Set<String> OXYGEN_ENTEPRISE_CATEGORIES = ImmutableSet.of((Object)"Enterprise", (Object)"Enterprise-Floating", (Object)"Enterprise-Managed-Named-User", (Object)"Enterprise-Corporate", (Object)"Enterprise-Site");
    private static AskForLicensDialogProvider askForLicenseDialogProvider;

    private DirectConnectionLicenseManager() {
    }

    public static DirectConnectionLicenseManager getInstance() {
        return SingletonHelper.INSTANCE;
    }

    public static void setAskForLicensDialogProvider(AskForLicensDialogProvider askForLicenseDialogProvider) {
        DirectConnectionLicenseManager.askForLicenseDialogProvider = askForLicenseDialogProvider;
    }

    public void askForLicense() {
        block3: {
            AskForLicenseDialogInterface licenseDialog = askForLicenseDialogProvider.getAskForLicenseDialog();
            if (licenseDialog.show(this.licenseInfoProvider, () -> {
                PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage().setOption("oxygen.positron.plugin.direct.connection.key", null);
                this.directConnectionLicenseChangedListeners.forEach(DirectConnectionLicenseChangedListener::licenseChanged);
            })) {
                try {
                    String licensePlainText = licenseDialog.getLicenseText();
                    this.checkLicenseInternal(licensePlainText);
                    PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage().setOption("oxygen.positron.plugin.direct.connection.key", SecurityHelper.getInstance().encryptText(licensePlainText));
                    this.directConnectionLicenseChangedListeners.forEach(DirectConnectionLicenseChangedListener::licenseChanged);
                }
                catch (InvalidLicenseException ex) {
                    LOGGER.debug(ex.getMessage(), (Throwable)ex);
                    if (PluginWorkspaceProvider.getPluginWorkspace().showWarningDialog(Translator.getInstance().getTranslation("Error"), ex.getMessage(), new String[]{"OK"}, new int[]{1}) != 1) break block3;
                    this.askForLicense();
                }
            }
        }
    }

    public void checkDirectConnectionLicense() throws InvalidLicenseException {
        if (!this.isCoveredByOxygenEnterpriseLicense()) {
            String encryptedLicenseKey = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage().getOption("oxygen.positron.plugin.direct.connection.key", null);
            this.checkLicenseInternal(SecurityHelper.getInstance().decryptText(encryptedLicenseKey));
        }
    }

    public boolean isCoveredByOxygenEnterpriseLicense() {
        LicenseInformationProvider licenseInformationProvider;
        if (PluginWorkspaceProvider.getPluginWorkspace() != null && (licenseInformationProvider = PluginWorkspaceProvider.getPluginWorkspace().getLicenseInformationProvider()) != null) {
            String category = licenseInformationProvider.getCategory();
            return category != null && OXYGEN_ENTEPRISE_CATEGORIES.contains(category);
        }
        return false;
    }

    private void checkLicenseInternal(String licenseText) throws InvalidLicenseException {
        EnterpriseLicenseChecker.getInstance().checkAIPositronLicense(licenseText);
    }

    public void addDirectConnectionLicenseListener(DirectConnectionLicenseChangedListener directLicenseChangedListener) {
        this.directConnectionLicenseChangedListeners.add(directLicenseChangedListener);
    }

    private static final class SingletonHelper {
        static final DirectConnectionLicenseManager INSTANCE = new DirectConnectionLicenseManager();

        private SingletonHelper() {
        }
    }
}

