/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.ghosttext;

import com.oxygenxml.positron.core.actions.types.AIAutocompletionProvider;
import com.oxygenxml.positron.core.actions.types.PositronFollowInstructionAction;
import com.oxygenxml.positron.core.interactions.ContentInserter;
import com.oxygenxml.positron.plugin.completion.CompletionActionsManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.editor.WSEditor;
import ro.sync.exml.workspace.api.editor.page.WSEditorPage;
import ro.sync.exml.workspace.api.editor.page.text.WSTextEditorPage;
import ro.sync.exml.workspace.api.listeners.WSEditorChangeListener;

public class FollowInstructionProvider {
    private static final Logger log = LoggerFactory.getLogger(FollowInstructionProvider.class);
    private static final char ENTER_CHAR = '\n';
    private static final char SPACE_CHAR = ' ';
    private WSEditorChangeListener editorListener;
    private PositronFollowInstructionAction followInstructionAction = new PositronFollowInstructionAction();
    private final Map<String, EditorListeners> editorListenersMap = new ConcurrentHashMap<String, EditorListeners>();
    private final GhostTextState ghostTextState = new GhostTextState();
    private CompletionActionsManager completionActionsManager;
    private static final int AI_SUGGESTION_DELAY_MS = 400;
    private static final String TRIGGER_CHARACTERS = " \n.,;:!?\"'()[]{}</>\\|&=+-*%#@$^~_";
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private final ConcurrentHashMap<String, ScheduledFuture<?>> scheduledSuggestions = new ConcurrentHashMap();
    private PluginWorkspace pluginWorkspaceAccess;

    private static boolean shouldTriggerAISuggestion(char c) {
        return Character.isLetterOrDigit(c) || TRIGGER_CHARACTERS.indexOf(c) >= 0;
    }

    public void install(final PluginWorkspace pluginWorkspaceAccess, CompletionActionsManager actionsManager) {
        this.pluginWorkspaceAccess = pluginWorkspaceAccess;
        this.completionActionsManager = actionsManager;
        this.editorListener = new WSEditorChangeListener(){

            public void editorOpened(URL editorLocation) {
                FollowInstructionProvider.this.handleEditorEvent(pluginWorkspaceAccess.getEditorAccess(editorLocation, 0), EditorEventType.OPENED);
            }

            public void editorPageChanged(URL editorLocation) {
                FollowInstructionProvider.this.handleEditorEvent(pluginWorkspaceAccess.getEditorAccess(editorLocation, 0), EditorEventType.PAGE_CHANGED);
            }

            public void editorClosed(URL editorLocation) {
                FollowInstructionProvider.this.handleEditorEvent(pluginWorkspaceAccess.getEditorAccess(editorLocation, 0), EditorEventType.CLOSED);
            }
        };
        pluginWorkspaceAccess.addEditorChangeListener(this.editorListener, 0);
    }

    private void handleEditorEvent(WSEditor openEditor, EditorEventType eventType) {
        if (openEditor != null) {
            String editorSystemId = openEditor.getEditorLocation().toExternalForm();
            if (eventType == EditorEventType.PAGE_CHANGED && this.editorListenersMap.containsKey(editorSystemId)) {
                return;
            }
            if (AIAutocompletionProvider.getActionId((String)openEditor.getContentType()) != null) {
                switch (eventType) {
                    case OPENED: 
                    case PAGE_CHANGED: {
                        this.registerGhostTextForEditor(openEditor, editorSystemId);
                        break;
                    }
                    case CLOSED: {
                        this.unregisterGhostTextForEditor(openEditor, editorSystemId);
                    }
                }
            }
        }
    }

    public void uninstall(PluginWorkspace pluginWorkspaceAccess) {
        if (this.editorListener != null) {
            pluginWorkspaceAccess.removeEditorChangeListener(this.editorListener, 0);
            this.editorListener = null;
        }
        this.cleanupAllListeners();
    }

    private void registerGhostTextForEditor(WSEditor editor, String editorSystemId) {
        WSEditorPage currentPage = editor.getCurrentPage();
        if (currentPage instanceof WSTextEditorPage) {
            this.registerListeners((WSTextEditorPage)currentPage, editorSystemId);
        }
    }

    private boolean isSmartAutocompletionEnabled() {
        return Boolean.parseBoolean(this.pluginWorkspaceAccess.getOptionsStorage().getOption("oxygen.positron.plugin.enable.ai.autocompletion.in.text.page", "false"));
    }

    private void registerListeners(WSTextEditorPage textPage, final String editorSystemId) {
        if (textPage.getTextComponent() instanceof JTextArea) {
            final JTextArea textArea = (JTextArea)textPage.getTextComponent();
            Document editorDocument = textPage.getDocument();
            CaretListener caretListener = new CaretListener(){

                @Override
                public void caretUpdate(CaretEvent caretEvent) {
                    if (FollowInstructionProvider.this.isSmartAutocompletionEnabled() && FollowInstructionProvider.this.followInstructionAction.getLatestAiSuggestion() != null && FollowInstructionProvider.this.followInstructionAction.getCaretPosition() != textArea.getCaretPosition()) {
                        FollowInstructionProvider.this.hideSuggestion();
                        FollowInstructionProvider.this.refreshTextArea(textArea);
                    }
                }
            };
            KeyAdapter keyListener = new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (FollowInstructionProvider.this.isSmartAutocompletionEnabled()) {
                        if (e.getKeyCode() == 27) {
                            FollowInstructionProvider.this.hideSuggestion();
                            FollowInstructionProvider.this.refreshTextArea(textArea);
                        }
                        if (e.getKeyCode() == 9) {
                            FollowInstructionProvider.this.handleTabPressed(e);
                        }
                    }
                }
            };
            DocumentListener documentListener = new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    if (!FollowInstructionProvider.this.isSmartAutocompletionEnabled()) {
                        return;
                    }
                    try {
                        String insertedText = e.getDocument().getText(e.getOffset(), e.getLength());
                        if (insertedText.isEmpty()) {
                            return;
                        }
                        if (insertedText.length() > 1) {
                            if (!insertedText.isBlank()) {
                                FollowInstructionProvider.this.fragmentMatchSuggestion(insertedText);
                            } else if (insertedText.contains("\n")) {
                                FollowInstructionProvider.this.ghostTextState.setEnterPressed(true);
                                FollowInstructionProvider.this.triggerNewSuggestion(editorSystemId);
                            }
                            return;
                        }
                        char insertedChar = insertedText.charAt(0);
                        if (insertedChar == '\n') {
                            FollowInstructionProvider.this.handleEnterKey(editorSystemId);
                        } else {
                            FollowInstructionProvider.this.handleVisibleKeyForTextSuggestion(editorSystemId, insertedChar);
                        }
                    }
                    catch (BadLocationException ex) {
                        FollowInstructionProvider.this.clearLatestAiSuggestion();
                    }
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    if (FollowInstructionProvider.this.isSmartAutocompletionEnabled()) {
                        FollowInstructionProvider.this.handleBackSpaceKey();
                    }
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                }
            };
            MouseAdapter mouseListener = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    FollowInstructionProvider.this.ghostTextState.setMousePressed(true);
                }
            };
            MouseAdapter mouseMotionListener = new MouseAdapter(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    int currentSelectionLength;
                    if (FollowInstructionProvider.this.ghostTextState.isMousePressed() && (currentSelectionLength = textArea.getSelectionEnd() - textArea.getSelectionStart()) > 0) {
                        FollowInstructionProvider.this.hideSuggestion();
                        FollowInstructionProvider.this.refreshTextArea(textArea);
                    }
                }
            };
            EditorListeners listeners = new EditorListeners(caretListener, documentListener, keyListener, mouseListener, mouseMotionListener);
            this.editorListenersMap.putIfAbsent(editorSystemId, listeners);
            editorDocument.addDocumentListener(documentListener);
            textArea.addKeyListener(keyListener);
            textArea.addCaretListener(caretListener);
            textArea.addMouseListener(mouseListener);
            textArea.addMouseMotionListener(mouseMotionListener);
        }
    }

    private void handleTabPressed(KeyEvent e) {
        String latestSuggestion = this.followInstructionAction.getLatestAiSuggestion();
        if (!this.isSuggestionVisible() || latestSuggestion == null) {
            return;
        }
        if (e.isShiftDown()) {
            this.handleShiftTabPressed();
        } else {
            this.insertLatestSuggestion(latestSuggestion);
        }
        e.consume();
    }

    private void hideSuggestion() {
        this.followInstructionAction.hideSuggestion();
    }

    private void showSuggestion() {
        this.followInstructionAction.showSuggestion();
    }

    public boolean isSuggestionVisible() {
        return this.followInstructionAction != null && !this.followInstructionAction.isSuggestionHidden();
    }

    private void handleVisibleKeyForTextSuggestion(String editorSystemId, char pressedChar) {
        if (this.followInstructionAction.getLatestAiSuggestion() != null) {
            this.handleSuggestionInteraction(editorSystemId, pressedChar);
        } else if (FollowInstructionProvider.shouldTriggerAISuggestion(pressedChar)) {
            this.triggerNewSuggestion(editorSystemId);
        }
    }

    private void fragmentMatchSuggestion(String insertedText) {
        String latestSuggestion = this.followInstructionAction.getLatestAiSuggestion();
        if (latestSuggestion != null && latestSuggestion.startsWith(insertedText)) {
            for (int i = 0; i < insertedText.length(); ++i) {
                this.followInstructionAction.removeFirstCharacterFromLatestAISuggestion();
            }
        }
    }

    void insertLatestSuggestion(String latestSuggestion) {
        ContentInserter contentInserter = this.completionActionsManager.getLastContentInserter();
        int caretPosition = this.followInstructionAction.getCaretPosition();
        contentInserter.insert(caretPosition, caretPosition + latestSuggestion.length(), latestSuggestion, null, false, false, false);
    }

    private void handleSuggestionInteraction(String editorSystemId, char typedChar) {
        this.ghostTextState.setEnterPressed(false);
        String suggestion = this.followInstructionAction.getLatestAiSuggestion();
        this.handleSimilarSuggestionGhostText(typedChar, suggestion);
    }

    private void handleBackSpaceKey() {
        if (this.followInstructionAction.getLatestAiSuggestion() != null && this.followInstructionAction.isStackEmpty()) {
            this.hideSuggestion();
        } else {
            this.followInstructionAction.addCharacterToLatestAISuggestion();
            if (this.followInstructionAction.getLatestAiSuggestion() != null && this.followInstructionAction.isStackEmpty()) {
                this.hideSuggestion();
            }
        }
    }

    private void handleSimilarSuggestionGhostText(char typedChar, String suggestion) {
        WSEditor currentEditor = this.pluginWorkspaceAccess.getCurrentEditorAccess(0);
        WSTextEditorPage textEditorPage = (WSTextEditorPage)currentEditor.getCurrentPage();
        if (!suggestion.isEmpty() && typedChar == suggestion.charAt(0) && this.followInstructionAction.getCaretPosition() >= textEditorPage.getCaretOffset()) {
            this.showSuggestion();
            this.followInstructionAction.removeFirstCharacterFromLatestAISuggestion();
        } else if (' ' == typedChar) {
            this.followInstructionAction.addSpaceToLatestAISuggestion();
        } else if (FollowInstructionProvider.shouldTriggerAISuggestion(typedChar)) {
            this.triggerNewSuggestion(suggestion);
        }
    }

    private void handleEnterKey(String editorSystemId) {
        this.ghostTextState.setEnterPressed(true);
        this.triggerNewSuggestion(editorSystemId);
    }

    private void triggerNewSuggestion(String editorSystemId) {
        this.showSuggestion();
        this.clearLatestAiSuggestion();
        this.scheduleAISuggestion(editorSystemId);
    }

    private void unregisterGhostTextForEditor(WSEditor openEditor, String editorSystemId) {
        EditorListeners listeners = this.editorListenersMap.remove(editorSystemId);
        if (listeners != null) {
            WSTextEditorPage textEditorPage = (WSTextEditorPage)openEditor.getCurrentPage();
            JTextArea textArea = (JTextArea)textEditorPage.getTextComponent();
            Document document = textEditorPage.getDocument();
            textArea.removeCaretListener(listeners.getCaretListener());
            textArea.removeKeyListener(listeners.getKeyListener());
            textArea.removeMouseListener(listeners.getMouseListener());
            textArea.removeMouseMotionListener(listeners.getMouseMotionListener());
            document.removeDocumentListener(listeners.getDocumentListener());
        }
        this.followInstructionAction = null;
        ScheduledFuture<?> task = this.scheduledSuggestions.remove(editorSystemId);
        if (task != null) {
            task.cancel(true);
        }
    }

    private void cleanupAllListeners() {
        this.editorListenersMap.clear();
        this.followInstructionAction = null;
        this.scheduledSuggestions.values().forEach(f -> f.cancel(true));
        this.scheduledSuggestions.clear();
    }

    public void scheduleAISuggestion(String editorSystemId) {
        this.scheduledSuggestions.compute(editorSystemId, (id, existingTask) -> {
            if (existingTask != null) {
                existingTask.cancel(false);
            }
            return this.scheduler.schedule(() -> {
                try {
                    this.generateAISuggestion();
                }
                finally {
                    this.scheduledSuggestions.remove(id);
                }
            }, 400L, TimeUnit.MILLISECONDS);
        });
    }

    public void generateAISuggestion() {
        WSEditor currentEditor = this.pluginWorkspaceAccess.getCurrentEditorAccess(0);
        if (currentEditor == null || !(currentEditor.getCurrentPage() instanceof WSTextEditorPage)) {
            return;
        }
        this.followInstructionAction.performLineCompletion(currentEditor);
        WSTextEditorPage editorPage = (WSTextEditorPage)currentEditor.getCurrentPage();
        JTextArea textArea = (JTextArea)editorPage.getTextComponent();
        String latestSuggestion = this.followInstructionAction.getLatestAiSuggestion();
        if (latestSuggestion != null && !latestSuggestion.isEmpty()) {
            this.followInstructionAction.setCaretPosition(editorPage.getCaretOffset());
            this.refreshTextArea(textArea);
        }
    }

    void refreshTextArea(JTextArea textArea) {
        SwingUtilities.invokeLater(() -> {
            textArea.revalidate();
            textArea.repaint();
        });
    }

    public int getCaretPosition() {
        if (this.followInstructionAction == null) {
            return -1;
        }
        return this.followInstructionAction.getCaretPosition();
    }

    public void clearLatestAiSuggestion() {
        if (this.followInstructionAction != null) {
            this.followInstructionAction.clearLatestAiSuggestion();
        }
        this.ghostTextState.reset();
    }

    public String getLatestAiSuggestion() {
        if (this.followInstructionAction == null) {
            return "";
        }
        return this.followInstructionAction.getLatestAiSuggestion();
    }

    private void handleShiftTabPressed() {
        this.pluginWorkspaceAccess.showPreferencesPages(new String[]{"ai_autocompletion_preferences_page"}, "ai_autocompletion_preferences_page", true);
    }

    public Map<String, EditorListeners> getEditorListenersMap() {
        return this.editorListenersMap;
    }

    public ConcurrentHashMap<String, ScheduledFuture<?>> getScheduledSuggestions() {
        return this.scheduledSuggestions;
    }

    static class GhostTextState {
        private boolean isEnterPressed;
        private boolean isMousePressed;

        public void reset() {
            this.isEnterPressed = false;
            this.isMousePressed = false;
        }

        public boolean isEnterPressed() {
            return this.isEnterPressed;
        }

        public boolean isMousePressed() {
            return this.isMousePressed;
        }

        public void setEnterPressed(boolean isEnterPressed) {
            this.isEnterPressed = isEnterPressed;
        }

        public void setMousePressed(boolean isMousePressed) {
            this.isMousePressed = isMousePressed;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GhostTextState)) {
                return false;
            }
            GhostTextState other = (GhostTextState)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnterPressed() != other.isEnterPressed()) {
                return false;
            }
            return this.isMousePressed() == other.isMousePressed();
        }

        protected boolean canEqual(Object other) {
            return other instanceof GhostTextState;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnterPressed() ? 79 : 97);
            result = result * 59 + (this.isMousePressed() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "FollowInstructionProvider.GhostTextState(isEnterPressed=" + this.isEnterPressed() + ", isMousePressed=" + this.isMousePressed() + ")";
        }
    }

    private static enum EditorEventType {
        OPENED,
        PAGE_CHANGED,
        CLOSED;

    }

    static class EditorListeners {
        private final CaretListener caretListener;
        private final DocumentListener documentListener;
        private final KeyListener keyListener;
        private final MouseListener mouseListener;
        private final MouseMotionListener mouseMotionListener;

        public EditorListeners(CaretListener caretListener, DocumentListener documentListener, KeyListener keyListener, MouseListener mouseListener, MouseMotionListener mouseMotionListener) {
            this.caretListener = caretListener;
            this.documentListener = documentListener;
            this.keyListener = keyListener;
            this.mouseListener = mouseListener;
            this.mouseMotionListener = mouseMotionListener;
        }

        public CaretListener getCaretListener() {
            return this.caretListener;
        }

        public DocumentListener getDocumentListener() {
            return this.documentListener;
        }

        public KeyListener getKeyListener() {
            return this.keyListener;
        }

        public MouseListener getMouseListener() {
            return this.mouseListener;
        }

        public MouseMotionListener getMouseMotionListener() {
            return this.mouseMotionListener;
        }
    }
}

