/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.fix;

import com.oxygenxml.positron.core.actions.types.PositronAIActionBase;
import com.oxygenxml.positron.core.actions.types.PositronAIFixAction;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.plugin.completion.CompletionActionsManager;
import java.lang.reflect.Method;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.document.DocumentPositionedInfo;
import ro.sync.exml.validate.ValidationProblemDPI;
import ro.sync.quickfix.IQuickFix;
import ro.sync.quickfix.QuickFixType;
import ro.sync.quickfix.SystemIDXMLOperationPair;

public class QuickFixUtil {
    private static final Logger log = LoggerFactory.getLogger(QuickFixUtil.class);
    private static int UNIQUE_ID = 0;
    private static final String QUICK_FIX_DESCRIPTION = "Use the AI Positron Fix action to ask the AI Positron for help with fixing the problem. It will propose in the chat pane the content that can be used to solve the problem.";

    private QuickFixUtil() {
    }

    private static SystemIDXMLOperationPair createFakeSystemIDXMLOperationPair() throws Exception {
        Class<SystemIDXMLOperationPair> systemIDXMLOperationPairClass = SystemIDXMLOperationPair.class;
        return (SystemIDXMLOperationPair)systemIDXMLOperationPairClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    static PositronAIFixAction getFixAction(CompletionActionsManager completionActionsManager) {
        PositronAIFixAction fixAction = null;
        List<PositronAIActionBase> pseudoActions = completionActionsManager.getPseudoActions();
        for (PositronAIActionBase actionIterator : pseudoActions) {
            if (!(actionIterator instanceof PositronAIFixAction)) continue;
            fixAction = (PositronAIFixAction)actionIterator;
            break;
        }
        return fixAction;
    }

    public static void addQuickFixForAIProblem(final ValidationProblemDPI currentDPI, final CompletionActionsManager completionActionsManager) {
        try {
            Class<ValidationProblemDPI> validationProblemDPI = ValidationProblemDPI.class;
            Method addQuickFixMethod = validationProblemDPI.getDeclaredMethod("addQuickFix", IQuickFix.class);
            addQuickFixMethod.setAccessible(true);
            final String quickFixID = "Ai_Fix_Action_Name_" + UNIQUE_ID++;
            addQuickFixMethod.invoke((Object)currentDPI, new IQuickFix(){

                public QuickFixType getQuickFixType() {
                    return null;
                }

                public List<SystemIDXMLOperationPair> getOperations() {
                    log.debug("Executing AI fix action for validation problem {}", (Object)currentDPI.getMessage());
                    try {
                        PositronAIFixAction positronAIFixAction = QuickFixUtil.getFixAction(completionActionsManager);
                        if (positronAIFixAction != null) {
                            positronAIFixAction.performFix((DocumentPositionedInfo)currentDPI);
                            log.debug("AI fix action executed successfully");
                        } else {
                            log.debug("No AI fix action available in the completion actions manager");
                        }
                    }
                    catch (Exception e) {
                        log.warn("Error executing AI fix action", (Throwable)e);
                    }
                    try {
                        return List.of(QuickFixUtil.createFakeSystemIDXMLOperationPair());
                    }
                    catch (Exception e) {
                        log.warn("Error creating fake SystemIDXMLOperationPair", (Throwable)e);
                        return List.of();
                    }
                }

                public String getName() {
                    return Translator.getInstance().getTranslation("Ai_Fix_Action_Name");
                }

                public String getFixedProblemDescription() {
                    return currentDPI.getMessage();
                }

                public String getFixId() {
                    return quickFixID;
                }

                public String getDescription() {
                    return QuickFixUtil.QUICK_FIX_DESCRIPTION;
                }
            });
        }
        catch (Throwable e) {
            log.warn("Error adding AI quick fix to validation problem", e);
        }
    }
}

