/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.fix;

import com.oxygenxml.positron.core.actions.types.PositronAIActionBase;
import com.oxygenxml.positron.core.actions.types.PositronAIFixAction;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.plugin.completion.CompletionActionsManager;
import com.oxygenxml.positron.plugin.util.IconsLoader;
import java.awt.event.ActionEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.URLUtil;
import ro.sync.document.DocumentPositionedInfo;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.listeners.WSEditorChangeListener;
import ro.sync.exml.workspace.api.results.ResultsTabEvent;
import ro.sync.exml.workspace.api.results.ResultsTabEventHandler;
import ro.sync.exml.workspace.api.results.ResultsTabPopUpMenuCustomizer;

public class AIFixProvider {
    private static final Logger log = LoggerFactory.getLogger(AIFixProvider.class);
    private static CompletionActionsManager openAICompletionActionsManager;
    private static Map<String, AIFixExecutor> installedTabKeys;
    private static WSEditorChangeListener editorListener;

    public static void install(final PluginWorkspace pluginWorkspaceAccess, CompletionActionsManager actionsManager) {
        openAICompletionActionsManager = actionsManager;
        editorListener = new WSEditorChangeListener(){

            public void editorOpened(URL editorLocation) {
                AIFixProvider.refreshTabKeyListeners(pluginWorkspaceAccess);
            }

            public void editorClosed(URL editorLocation) {
                AIFixProvider.refreshTabKeyListeners(pluginWorkspaceAccess);
            }
        };
        pluginWorkspaceAccess.addEditorChangeListener(editorListener, 1);
        AIFixProvider.refreshTabKeyListeners(pluginWorkspaceAccess);
    }

    public static void uninstall(PluginWorkspace pluginWorkspaceAccess) {
        if (editorListener != null) {
            pluginWorkspaceAccess.removeEditorChangeListener(editorListener, 1);
        }
        AIFixProvider.uninstallCustomizers(pluginWorkspaceAccess);
    }

    private static void refreshTabKeyListeners(PluginWorkspace pluginWorkspaceAccess) {
        AIFixProvider.uninstallCustomizers(pluginWorkspaceAccess);
        String problemsTab = Translator.getInstance().getTranslation("Problems");
        installedTabKeys.put(problemsTab, new AIFixExecutor(pluginWorkspaceAccess, problemsTab));
        URL[] allDMMEditors = pluginWorkspaceAccess.getAllEditorLocations(1);
        if (allDMMEditors != null) {
            for (URL url : allDMMEditors) {
                String dmmValidateCheckTab = Translator.getInstance().getTranslation("Dita_Map_Completeness_Check") + " - " + URLUtil.extractFileName((URL)url);
                installedTabKeys.put(dmmValidateCheckTab, new AIFixExecutor(pluginWorkspaceAccess, dmmValidateCheckTab));
            }
        }
        for (Map.Entry entry : installedTabKeys.entrySet()) {
            pluginWorkspaceAccess.getResultsManager().addPopUpMenuCustomizer((String)entry.getKey(), (ResultsTabPopUpMenuCustomizer)entry.getValue());
            pluginWorkspaceAccess.getResultsManager().addEventHandler((String)entry.getKey(), (ResultsTabEventHandler)entry.getValue());
        }
    }

    private static void uninstallCustomizers(PluginWorkspace pluginWorkspaceAccess) {
        if (!installedTabKeys.isEmpty()) {
            for (Map.Entry<String, AIFixExecutor> entry : installedTabKeys.entrySet()) {
                pluginWorkspaceAccess.getResultsManager().removePopUpMenuCustomizer(entry.getKey(), (ResultsTabPopUpMenuCustomizer)entry.getValue());
                pluginWorkspaceAccess.getResultsManager().removeEventHandler(entry.getKey(), (ResultsTabEventHandler)entry.getValue());
            }
            installedTabKeys.clear();
        }
    }

    static {
        installedTabKeys = new HashMap<String, AIFixExecutor>();
    }

    private static class AIFixExecutor
    implements ResultsTabPopUpMenuCustomizer,
    ResultsTabEventHandler {
        private PluginWorkspace pluginWS;
        private String tabKey;

        AIFixExecutor(PluginWorkspace pluginWS, String tabKey) {
            this.pluginWS = pluginWS;
            this.tabKey = tabKey;
        }

        public boolean handle(ResultsTabEvent event) {
            return false;
        }

        public void customizePopUpMenu(Object arg0) {
            List selectedResults = this.pluginWS.getResultsManager().getSelectedResults(this.tabKey);
            if (selectedResults != null && selectedResults.size() == 1 && this.isCurrentOpenedEditorForDPI((DocumentPositionedInfo)selectedResults.get(0))) {
                final DocumentPositionedInfo currentDPI = (DocumentPositionedInfo)selectedResults.get(0);
                JPopupMenu menu = (JPopupMenu)arg0;
                AbstractAction aiFixAction = new AbstractAction(Translator.getInstance().getTranslation("Ai_Fix_Action_Name"), IconsLoader.loadIcon("/images/GenerateAttributeValue16.png")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        this.executeFix(currentDPI);
                    }
                };
                menu.insert(aiFixAction, 0);
                menu.insert(new JSeparator(), 1);
            }
        }

        private boolean isCurrentOpenedEditorForDPI(DocumentPositionedInfo currentDPI) {
            try {
                return this.pluginWS.getEditorAccess(new URL(currentDPI.getSystemID()), 0) != null;
            }
            catch (MalformedURLException ex) {
                log.error(ex.getMessage());
                return false;
            }
        }

        private void executeFix(DocumentPositionedInfo dpi) {
            PositronAIFixAction quickFixAction;
            if (dpi != null && (quickFixAction = AIFixExecutor.getOpenAIFixAction()) != null) {
                try {
                    this.pluginWS.open(new URL(dpi.getSystemID()));
                }
                catch (MalformedURLException e) {
                    log.error(e.getMessage());
                }
                quickFixAction.performFix(dpi);
            }
        }

        private static PositronAIFixAction getOpenAIFixAction() {
            List<PositronAIActionBase> pseudoActions = openAICompletionActionsManager.getPseudoActions();
            for (PositronAIActionBase actionIterator : pseudoActions) {
                if (!(actionIterator instanceof PositronAIFixAction)) continue;
                return (PositronAIFixAction)actionIterator;
            }
            return null;
        }
    }
}

