/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.engine;

import com.oxygenxml.positron.api.connector.dto.ModelDescriptor;
import com.oxygenxml.positron.core.engines.IEnginesManager;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.core.util.AIModelsUtil;
import com.oxygenxml.positron.utilities.AIProviderConstants;
import com.oxygenxml.positron.utilities.ModelIdentifierUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;

public class SaasEnginesManager
implements IEnginesManager {
    private static final Translator TRANSLATOR = Translator.getInstance();

    public Map<String, List<ModelDescriptor>> getAvailableEngines() {
        Map groupedModelsForUI = AIModelsUtil.getGroupedModelsForUI();
        LinkedHashMap<String, List<ModelDescriptor>> enginesMappings = new LinkedHashMap<String, List<ModelDescriptor>>();
        for (Map.Entry entry : groupedModelsForUI.entrySet()) {
            String key = (String)entry.getKey();
            List modelDescriptors = (List)entry.getValue();
            ArrayList<ModelDescriptor> modelsWithNamespace = new ArrayList<ModelDescriptor>();
            for (ModelDescriptor m : modelDescriptors) {
                ModelDescriptor md = new ModelDescriptor(ModelIdentifierUtil.buildModelIdentifier((String)"aips", (String)m.getId()), m.getUiLabel(), m.getDescription(), m.getContextWindow(), m.getMaxOutputTokens(), m.isReasoningModel());
                modelsWithNamespace.add(md);
            }
            enginesMappings.put("AI Positron Service / " + key, modelsWithNamespace);
        }
        return enginesMappings;
    }

    public void saveEngine(String selectedEngineId) {
        if (selectedEngineId != null && selectedEngineId.equals(AIProviderConstants.DEFAULT_ENGINE.getId())) {
            selectedEngineId = null;
        }
        PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage().setOption("default.engine.model", selectedEngineId);
    }

    public boolean isChoosingEngineAllowed() {
        return true;
    }

    public ModelDescriptor getCurrentEngineDescriptor() {
        String aiModelFromOptions = AIModelsUtil.getAIModelFromOptions((String)"default.engine.model");
        if (aiModelFromOptions == null || "<Default>".equals(aiModelFromOptions)) {
            aiModelFromOptions = AIProviderConstants.DEFAULT_ENGINE.getId();
        }
        String currentEngine = aiModelFromOptions;
        return this.getAvailableEngines().values().stream().flatMap(Collection::stream).filter(model -> model.getId().equals(currentEngine)).findFirst().orElse(new ModelDescriptor(currentEngine, currentEngine, null));
    }

    public String getModelsComboTooltip() {
        return TRANSLATOR.getTranslation("Default_model_explanation");
    }
}

