/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.diff;

import com.oxygenxml.positron.core.interactions.ContentInserter;
import com.oxygenxml.positron.core.interactions.ReadOnlyController;
import com.oxygenxml.positron.core.interactions.ReadOnlyControllerImpl;
import com.oxygenxml.positron.core.interactions.textpage.TextXPathEffector;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.core.util.AuthorTextUtil;
import com.oxygenxml.positron.plugin.completion.author.ContentInserterForAuthorPage;
import com.oxygenxml.positron.plugin.completion.text.ContentInserterForTextPage;
import com.oxygenxml.positron.plugin.diff.PreviewQuitHandler;
import com.oxygenxml.positron.plugin.diff.PreviewURLHandler;
import com.oxygenxml.positron.utilities.json.InsertMode;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.URLUtil;
import ro.sync.ecss.extensions.api.component.AuthorComponentException;
import ro.sync.ecss.extensions.api.component.EditorComponentProvider;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.editor.page.WSEditorPage;
import ro.sync.exml.workspace.api.editor.page.WSTextBasedEditorPage;
import ro.sync.exml.workspace.api.editor.page.author.WSAuthorEditorPage;
import ro.sync.exml.workspace.api.editor.page.text.WSTextEditorPage;
import ro.sync.exml.workspace.api.standalone.StandalonePluginWorkspace;

public class PreviewUtil {
    private static final Logger logger = LoggerFactory.getLogger(PreviewUtil.class);

    public static boolean previewReplaceSelectionWithSuggestion(WSTextBasedEditorPage editorPage, final String suggestion, final boolean interpretingCompletionAsMarkup, final int startOffset, final int endOffset) {
        final WSTextBasedEditorPage originalEditorPage = editorPage;
        return PreviewUtil.previewOperation(editorPage, new SuggestionHandler(){

            @Override
            public void handleSuggestion(WSTextBasedEditorPage editorPage) throws Exception {
                int eo;
                int so;
                ContentInserter contentInserter = PreviewUtil.getContentInserter(editorPage);
                if (contentInserter != null) {
                    so = startOffset;
                    eo = endOffset;
                    if (AuthorTextUtil.isSelectionOverUnresolvedConref((WSTextBasedEditorPage)editorPage, (int)startOffset, (int)endOffset)) {
                        try {
                            so = editorPage.getOffsetForAnchor(originalEditorPage.createAnchor(startOffset));
                            eo = editorPage.getOffsetForAnchor(originalEditorPage.createAnchor(endOffset));
                        }
                        catch (BadLocationException e) {
                            logger.error(e.getMessage(), (Throwable)e);
                        }
                    }
                } else {
                    throw new IOException("Cannot insert in current page: " + editorPage);
                }
                contentInserter.replaceSelectionWithSuggestion(suggestion, interpretingCompletionAsMarkup, so, eo, false);
            }
        });
    }

    private static ContentInserter getContentInserter(WSTextBasedEditorPage editorPage) throws Exception {
        Object contentInserter = null;
        Exception[] ex = new Exception[1];
        if (editorPage instanceof WSTextEditorPage) {
            contentInserter = new ContentInserterForTextPage((WSTextEditorPage)editorPage, (ReadOnlyController)new ReadOnlyControllerImpl((WSEditorPage)editorPage), new TextXPathEffector((WSTextEditorPage)editorPage));
        } else if (editorPage instanceof WSAuthorEditorPage) {
            contentInserter = new ContentInserterForAuthorPage(((WSAuthorEditorPage)editorPage).getDocumentController(), (WSAuthorEditorPage)editorPage, err -> {
                ex[0] = new Exception((String)err);
            }, null);
        }
        if (ex[0] != null) {
            throw ex[0];
        }
        return contentInserter;
    }

    public static boolean previewInsert(WSTextBasedEditorPage editorPage, final int startOffset, final int endOffset, final String suggestion, final List<InsertMode> insertModes, final boolean asMarkup, final boolean deleteSelection) {
        return PreviewUtil.previewOperation(editorPage, new SuggestionHandler(){

            @Override
            public void handleSuggestion(WSTextBasedEditorPage editorPage) throws Exception {
                ContentInserter contentInserter = PreviewUtil.getContentInserter(editorPage);
                if (contentInserter == null) {
                    throw new IOException("Cannot insert in current page: " + editorPage);
                }
                contentInserter.insert(startOffset, endOffset, suggestion, insertModes, asMarkup, deleteSelection, false);
            }
        });
    }

    private static boolean previewOperation(WSTextBasedEditorPage editorPage, SuggestionHandler suggestionHandler) {
        StandalonePluginWorkspace pluginWorkspace = (StandalonePluginWorkspace)PluginWorkspaceProvider.getPluginWorkspace();
        URL currentURL = editorPage.getParentEditor().getEditorLocation();
        if (currentURL != null) {
            String fileName = URLUtil.extractFileName((URL)currentURL);
            String fileNameNoExt = URLUtil.removeExtension((String)fileName);
            String newFileName = fileNameNoExt + "-changes." + URLUtil.getExtension((String)fileName);
            try {
                URL urlContainingChanges = URLUtil.isFromLocalDrive((URL)currentURL) ? new URL(URLUtil.getParentURL((URL)currentURL).toString() + newFileName) : PreviewURLHandler.encodeURL("modifiededitable", currentURL.toString());
                return PreviewUtil.tryShowPreview(editorPage, suggestionHandler, pluginWorkspace, currentURL, urlContainingChanges);
            }
            catch (IOException | AuthorComponentException e) {
                logger.error((Object)e, e);
                pluginWorkspace.showErrorMessage("Could not open preview: " + e.getMessage());
            }
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    private static boolean tryShowPreview(WSTextBasedEditorPage editorPage, SuggestionHandler suggestionHandler, StandalonePluginWorkspace pluginWorkspace, URL currentURL, URL urlContainingChanges) throws AuthorComponentException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static EditorComponentProvider createEditorComponentProvider(StandalonePluginWorkspace pluginWorkspace, URL currentURL, String pageID) throws AuthorComponentException {
        EditorComponentProvider editorComponentProvider;
        try {
            Method createWithContentType = pluginWorkspace.getClass().getMethod("createEditorComponentProvider", String[].class, String.class, String.class);
            editorComponentProvider = (EditorComponentProvider)createWithContentType.invoke((Object)pluginWorkspace, new String[]{pageID}, pageID, pluginWorkspace.getUtilAccess().getContentType(currentURL.toString()));
        }
        catch (Exception ex) {
            editorComponentProvider = pluginWorkspace.createEditorComponentProvider(new String[]{pageID}, pageID);
        }
        return editorComponentProvider;
    }

    private static boolean showPreviewFrame(StandalonePluginWorkspace pluginWorkspace, URL currentContentURL, URL proposedChangesURL) throws MalformedURLException {
        boolean changesAppliedDuringPreview = false;
        try {
            Method openMergeAppDialog = pluginWorkspace.getClass().getMethod("openMergeApplication", String.class, String.class, Boolean.TYPE, String.class, URL.class, Boolean.TYPE, Boolean.TYPE, String.class, URL.class, Boolean.TYPE, Boolean.TYPE, URL.class);
            openMergeAppDialog.invoke((Object)pluginWorkspace, Translator.getInstance().getTranslation("Changes"), null, true, Translator.getInstance().getTranslation("Current_diff"), currentContentURL, true, false, Translator.getInstance().getTranslation("Proposed_changes"), PreviewURLHandler.encodeURL("modified", proposedChangesURL.toString()), false, false, currentContentURL);
            changesAppliedDuringPreview = PreviewURLHandler.changesAppliedDuringPreview();
            PreviewURLHandler.setPreviewDetails(null, null);
        }
        catch (Exception e) {
            JFrame diffFrame = (JFrame)pluginWorkspace.openDiffFilesApplication(Translator.getInstance().getTranslation("Current_diff"), currentContentURL, Translator.getInstance().getTranslation("Proposed_changes"), PreviewURLHandler.encodeURL("modified", proposedChangesURL.toString()), currentContentURL, false);
            if (diffFrame != null) {
                PreviewQuitHandler.installQuitHandlers(diffFrame);
            }
            PreviewURLHandler.setPreviewDetails(null, null);
        }
        return changesAppliedDuringPreview;
    }

    private static interface SuggestionHandler {
        public void handleSuggestion(WSTextBasedEditorPage var1) throws Exception;
    }
}

