/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.customizer;

import com.oxygenxml.positron.core.auth.requests.AuthenticationInfoManager;
import com.oxygenxml.positron.core.util.PositronOptionsUtil;
import com.oxygenxml.positron.plugin.completion.AICompletionProvidersManager;
import com.oxygenxml.positron.plugin.completion.CompletionActionsManager;
import com.oxygenxml.positron.plugin.customizer.DitaMapManagerAndProjectPopupMenuCustomizerUtil;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.JPopupMenu;
import ro.sync.basic.util.URLUtil;
import ro.sync.exml.workspace.api.standalone.StandalonePluginWorkspace;
import ro.sync.exml.workspace.api.standalone.project.ProjectController;
import ro.sync.exml.workspace.api.standalone.project.ProjectPopupMenuCustomizer;

public class ProjectMenuCustomizer
implements ProjectPopupMenuCustomizer {
    private static final String PROJECT_REFACTORING = "Project/Refactoring";
    private StandalonePluginWorkspace pluginWorkspaceAccess;
    private AuthenticationInfoManager authenticationInfoManager;
    private CompletionActionsManager completionActionsManager;
    private AICompletionProvidersManager aiCompletionProviderManager;

    public ProjectMenuCustomizer(StandalonePluginWorkspace pluginWorkspaceAccess, AuthenticationInfoManager authenticationInfoManager, CompletionActionsManager completionActionsManager, AICompletionProvidersManager aiCompletionProviderManager) {
        this.pluginWorkspaceAccess = pluginWorkspaceAccess;
        this.authenticationInfoManager = authenticationInfoManager;
        this.completionActionsManager = completionActionsManager;
        this.aiCompletionProviderManager = aiCompletionProviderManager;
    }

    public void customizePopUpMenu(Object popUp) {
        if (PositronOptionsUtil.isPositronEnabled()) {
            JPopupMenu menu = (JPopupMenu)popUp;
            Supplier<List<URL>> currentSelectionSupplier = this.getProjectCurrentSelectedFileSupplier();
            DitaMapManagerAndProjectPopupMenuCustomizerUtil.customizePopUpWithRefactoringAction(this.pluginWorkspaceAccess, this.authenticationInfoManager, this.completionActionsManager, this.aiCompletionProviderManager.getCurrentCompletionProvider(), menu, PROJECT_REFACTORING, currentSelectionSupplier);
            DitaMapManagerAndProjectPopupMenuCustomizerUtil.customizePopUpWithAiIgnoreAction(menu, currentSelectionSupplier, this::refreshFoldersToShowNewlyAddedAiIgnoreFiles);
        }
    }

    private void refreshFoldersToShowNewlyAddedAiIgnoreFiles() {
        ProjectController projectCtrl = this.pluginWorkspaceAccess.getProjectManager();
        projectCtrl.refreshFolders((File[])Arrays.stream(projectCtrl.getSelectedFiles()).map(File::getParentFile).filter(Objects::nonNull).distinct().toArray(File[]::new));
    }

    private Supplier<List<URL>> getProjectCurrentSelectedFileSupplier() {
        return () -> Arrays.stream(this.pluginWorkspaceAccess.getProjectManager().getSelectedFiles()).map(t -> URLUtil.convertToURL((String)t.getAbsolutePath())).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

