/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.customizer;

import com.oxygenxml.positron.actions.dialog.internal.DialogType;
import com.oxygenxml.positron.actions.dialog.internal.MessageDialogBuilder;
import com.oxygenxml.positron.core.AICompletionDetailsProvider;
import com.oxygenxml.positron.core.auth.requests.AuthenticationInfoManager;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.plugin.AIPositronInfo;
import com.oxygenxml.positron.plugin.MenusActionsManager;
import com.oxygenxml.positron.plugin.completion.CompletionActionsManager;
import com.oxygenxml.positron.plugin.license.DirectConnectionLicenseManager;
import com.oxygenxml.positron.plugin.refactoring.RefactorController;
import com.oxygenxml.positron.plugin.util.DirectConnectionConfigurationHelper;
import com.oxygenxml.positron.plugin.util.IconsLoader;
import com.oxygenxml.positron.plugin.util.OxygenUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.text.MessageFormat;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.standalone.StandalonePluginWorkspace;
import ro.sync.exml.workspace.api.standalone.ui.OxygenUIComponentsFactory;

public class DitaMapManagerAndProjectPopupMenuCustomizerUtil {
    private static final Logger log = LoggerFactory.getLogger(DitaMapManagerAndProjectPopupMenuCustomizerUtil.class);
    private static final Translator TRANSLATOR = Translator.getInstance();

    private DitaMapManagerAndProjectPopupMenuCustomizerUtil() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static void customizePopUpWithRefactoringAction(StandalonePluginWorkspace pluginWorkspaceAccess, AuthenticationInfoManager authenticationInfoManager, CompletionActionsManager completionActionsManager, AICompletionDetailsProvider currentCompletionProvider, JPopupMenu popUp, String popUpConstant, Supplier<List<URL>> supplier) {
        Component[] componentList = popUp.getComponents();
        boolean isCurrentVersion = OxygenUtils.getCurrentMajorVersion() >= 26;
        for (Component component : componentList) {
            String id = pluginWorkspaceAccess.getActionsProvider().getActionID((Object)component);
            boolean isRefactoringMenu = popUpConstant.equals(id);
            if (!isRefactoringMenu || !isCurrentVersion) continue;
            JMenu refactoringMenu = (JMenu)component;
            refactoringMenu.add(new JSeparator());
            AbstractAction aiRefactoringAction = DitaMapManagerAndProjectPopupMenuCustomizerUtil.createAIRefactoringAction(supplier, authenticationInfoManager, currentCompletionProvider, completionActionsManager);
            JMenuItem aiRefactoringMenuItem = OxygenUIComponentsFactory.createMenuItem((Action)aiRefactoringAction);
            refactoringMenu.add(aiRefactoringMenuItem);
            break;
        }
    }

    private static AbstractAction createAIRefactoringAction(final Supplier<List<URL>> supplier, final AuthenticationInfoManager authenticationInfoManager, final AICompletionDetailsProvider aiCompletionProvider, final CompletionActionsManager completionActionsManager) {
        return new AbstractAction(TRANSLATOR.getTranslation("Refactor_Title") + "...", IconsLoader.loadIcon("/images/DockableFramePositron16.png")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DirectConnectionConfigurationHelper.isDirectConnection() && !DirectConnectionConfigurationHelper.isLicenseForDirectConnectionValid()) {
                    MessageDialogBuilder dialogBuilder = new MessageDialogBuilder(TRANSLATOR.getTranslation("No_license_detected"), DialogType.INFO);
                    dialogBuilder.setMessage(TRANSLATOR.getTranslation("Direct_Connection_Using_Info"));
                    dialogBuilder.setOkButtonName(TRANSLATOR.getTranslation("Register") + "...");
                    if (dialogBuilder.buildAndShow().getResult() == 1) {
                        DirectConnectionLicenseManager.getInstance().askForLicense();
                    }
                } else if (!DirectConnectionConfigurationHelper.isDirectConnection() && !authenticationInfoManager.isConnected()) {
                    MessageDialogBuilder dialogBuilder = new MessageDialogBuilder(TRANSLATOR.getTranslation("Unauthorized"), DialogType.INFO);
                    dialogBuilder.setMessage(MessageFormat.format(TRANSLATOR.getTranslation("not_connected_message"), "Oxygen AI Positron", AIPositronInfo.PRODUCT_NAME));
                    dialogBuilder.setOkButtonName(TRANSLATOR.getTranslation("Go_To_Positron"));
                    if (dialogBuilder.buildAndShow().getResult() == 1) {
                        StandalonePluginWorkspace pluginWorkspace = (StandalonePluginWorkspace)PluginWorkspaceProvider.getPluginWorkspace();
                        pluginWorkspace.showView("PositronPluginViewID", this.enabled);
                    }
                } else {
                    RefactorController refactorController = new RefactorController(completionActionsManager, aiCompletionProvider);
                    refactorController.refactorContent((List)supplier.get());
                }
            }
        };
    }

    public static void customizePopUpWithAiIgnoreAction(JPopupMenu popupMenu, Supplier<List<URL>> resourcesToAddSupplier, Runnable additionalActionTOPerformedAfterAiIgnoreFinishes) {
        popupMenu.addSeparator();
        popupMenu.add(MenusActionsManager.createAiIgnoreAction(resourcesToAddSupplier, additionalActionTOPerformedAfterAiIgnoreFinishes));
    }
}

