/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.completion.author;

import com.oxygenxml.positron.core.interactions.DefaultContentInserterForAuthorPage;
import com.oxygenxml.positron.core.interactions.ReadOnlyController;
import com.oxygenxml.positron.plugin.diff.PreviewUtil;
import com.oxygenxml.positron.utilities.json.InsertMode;
import java.awt.Component;
import java.util.List;
import java.util.function.Consumer;
import ro.sync.ecss.extensions.api.AuthorCaretListener;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.exml.workspace.api.editor.WSEditor;
import ro.sync.exml.workspace.api.editor.page.WSTextBasedEditorPage;
import ro.sync.exml.workspace.api.editor.page.author.WSAuthorEditorPage;

public class ContentInserterForAuthorPage
extends DefaultContentInserterForAuthorPage {
    private Component compToFocus;
    private AuthorCaretListener caretListener = caretEvent -> this.removeInsertionHighlight();

    public ContentInserterForAuthorPage(AuthorDocumentController controller, WSAuthorEditorPage authorEditorPage, Consumer<String> errorConsumer, ReadOnlyController readOnlyController) {
        super(controller, authorEditorPage, errorConsumer, readOnlyController);
        WSEditor parentEditor = authorEditorPage.getParentEditor();
        this.compToFocus = (Component)parentEditor.getComponent();
        authorEditorPage.addAuthorCaretListener(this.caretListener);
    }

    public int[] insert(int startOffset, int endOffset, String suggestion, List<InsertMode> insertModes, boolean asMarkup, boolean deleteSelection, boolean isCopilotInsert) {
        int[] toRet = super.insert(startOffset, endOffset, suggestion, insertModes, asMarkup, deleteSelection, isCopilotInsert);
        this.compToFocus.requestFocus();
        return toRet;
    }

    public int[] replaceSelectionWithSuggestion(String suggestion, boolean asMarkup, int startOffset, int endOffset, boolean isCopilotReplace) {
        int[] toRet = super.replaceSelectionWithSuggestion(suggestion, asMarkup, startOffset, endOffset, isCopilotReplace);
        if (this.compToFocus != null && suggestion != null) {
            this.compToFocus.requestFocus();
        }
        return toRet;
    }

    public void cleanUp() {
        super.cleanUp();
        this.authorPage.removeAuthorCaretListener(this.caretListener);
        this.compToFocus = null;
    }

    public boolean previewReplaceSelectionWithSuggestion(String suggestion, boolean interpretingCompletionAsMarkup, int startOffset, int endOffset) {
        return PreviewUtil.previewReplaceSelectionWithSuggestion((WSTextBasedEditorPage)this.authorPage, suggestion, interpretingCompletionAsMarkup, startOffset, endOffset);
    }

    public boolean previewInsert(int startOffset, int endOffset, String suggestion, List<InsertMode> insertModes, boolean asMarkup, boolean deleteSelection) {
        return PreviewUtil.previewInsert((WSTextBasedEditorPage)this.authorPage, startOffset, endOffset, suggestion, insertModes, asMarkup, deleteSelection);
    }
}

