/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.completion;

import com.oxygenxml.positron.actions.RecentlyUsedActionsOptionsStorageUtil;
import com.oxygenxml.positron.actions.TranslationActionCustomizer;
import com.oxygenxml.positron.core.AIActionsProvider;
import com.oxygenxml.positron.core.AICompletionProviderResolver;
import com.oxygenxml.positron.core.PositronActionsProvider;
import com.oxygenxml.positron.core.actions.DefaultActionInteractor;
import com.oxygenxml.positron.core.actions.DefaultActionInteractorProvider;
import com.oxygenxml.positron.core.actions.ExcludedPositronActions;
import com.oxygenxml.positron.core.actions.MessagePresenter;
import com.oxygenxml.positron.core.actions.OperationSemaphoreHandler;
import com.oxygenxml.positron.core.actions.ReloadActionsListener;
import com.oxygenxml.positron.core.actions.loader.AdditionalActionsProvider;
import com.oxygenxml.positron.core.actions.types.ActionInteractorFactory;
import com.oxygenxml.positron.core.actions.types.BaseActionInteractor;
import com.oxygenxml.positron.core.actions.types.CreateTopicsAction;
import com.oxygenxml.positron.core.actions.types.PositronAIActionBase;
import com.oxygenxml.positron.core.actions.types.PositronAIActionCustomizer;
import com.oxygenxml.positron.core.actions.types.PositronAICreateDocumentAction;
import com.oxygenxml.positron.core.actions.types.PositronAIFixAction;
import com.oxygenxml.positron.core.actions.types.PositronAIGenerateContentFromContextAction;
import com.oxygenxml.positron.core.actions.types.PositronAIInsertCommentAction;
import com.oxygenxml.positron.core.actions.types.PositronAIInsertFragmentForLeftSuggestionAction;
import com.oxygenxml.positron.core.actions.types.PositronAIPromptUserAction;
import com.oxygenxml.positron.core.actions.types.PositronCopilotProcessContentBasedOnUserInstructionsAction;
import com.oxygenxml.positron.core.actions.types.PositronDocumentationDraftAction;
import com.oxygenxml.positron.core.actions.types.PositronResolveCommentsAction;
import com.oxygenxml.positron.core.actions.types.PositronUpdateDocumentBasedOnImagesAction;
import com.oxygenxml.positron.core.actions.types.PreActionListener;
import com.oxygenxml.positron.core.actions.validation.AIContentEventListener;
import com.oxygenxml.positron.core.auth.requests.ServerRequestListener;
import com.oxygenxml.positron.core.chat.ChatInteractor;
import com.oxygenxml.positron.core.interactions.ContentInserter;
import com.oxygenxml.positron.core.interactions.DocumentContentInteractor;
import com.oxygenxml.positron.core.interactions.DocumentDetailsProvider;
import com.oxygenxml.positron.core.interactions.IDocumentCreator;
import com.oxygenxml.positron.core.interactions.IUserInputProvider;
import com.oxygenxml.positron.core.progress.OperationProgressPresenter;
import com.oxygenxml.positron.core.util.ActionMatcherUtil;
import com.oxygenxml.positron.plugin.AIActionsInfoProvider;
import com.oxygenxml.positron.utilities.action.ActionsUtil;
import com.oxygenxml.positron.utilities.json.AIActionDetails;
import com.oxygenxml.positron.utilities.json.ActionType;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.concurrent.Semaphore;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.options.WSOptionsStorage;

public class CompletionActionsManager
implements OperationSemaphoreHandler,
DefaultActionInteractorProvider,
AIActionsProvider,
PositronActionsProvider {
    private static final Logger log = LoggerFactory.getLogger(CompletionActionsManager.class);
    private static final AIActionsInfoProvider aiActionsInfoProvider = AIActionsInfoProvider.getInstance();
    private final Semaphore operationInProgress = new Semaphore(1);
    private List<AIActionDetails> lastBuiltInActions = new ArrayList<AIActionDetails>();
    private List<AIActionDetails> visibleFromSideViewCompletionActionsDetails = new ArrayList<AIActionDetails>();
    private List<PositronAIActionBase> visibleFromSideViewCompletionActions = new ArrayList<PositronAIActionBase>();
    private List<AIActionDetails> pseudoActionsDetails = new ArrayList<AIActionDetails>();
    private List<PositronAIActionBase> pseudoActions = new ArrayList<PositronAIActionBase>();
    private List<PositronAIActionBase> hiddenFromSideViewCompletionActions = new ArrayList<PositronAIActionBase>();
    private MessagePresenter messagePresenter;
    private final WSOptionsStorage optionsStorage;
    private final AdditionalActionsProvider additionalActionsProvider;
    private AICompletionProviderResolver aiCompletionProviderResolver;
    private OperationProgressPresenter operationsStatusPresenter;
    private List<ReloadActionsListener> reloadActionListeners = new ArrayList<ReloadActionsListener>();
    private ContentInserter lastContentInserter;
    private DocumentContentInteractor lastPrefixExtractor;
    private ChatInteractor chatInteractor;
    private DefaultActionInteractor defaultActionInteractor;
    private final Lock lock = new ReentrantLock();
    private final IUserInputProvider userInputProvider;
    private final IDocumentCreator documentCreator;
    private AIContentEventListener aiContentAppliedListener;

    public CompletionActionsManager(PluginWorkspace pluginWorkspace, MessagePresenter messagePresenter, ChatInteractor chatInteractor, AICompletionProviderResolver aiCompletionProviderResolver, OperationProgressPresenter operationsStatusPresenter, AdditionalActionsProvider additionalActionsProvider, IUserInputProvider userInputProvider, IDocumentCreator documentCreator, AIContentEventListener contentAppliedListener) {
        this.additionalActionsProvider = additionalActionsProvider;
        this.optionsStorage = pluginWorkspace.getOptionsStorage();
        this.messagePresenter = messagePresenter;
        this.chatInteractor = chatInteractor;
        this.aiCompletionProviderResolver = aiCompletionProviderResolver;
        this.operationsStatusPresenter = operationsStatusPresenter;
        this.userInputProvider = userInputProvider;
        this.documentCreator = documentCreator;
        this.aiContentAppliedListener = contentAppliedListener;
        this.loadActions(null, null);
        this.loadPseudoActions(null, null);
    }

    public void updateCompletionProviderResolver(AICompletionProviderResolver completionProviderResolver) {
        this.aiCompletionProviderResolver = completionProviderResolver;
        for (PositronAIActionBase action : this.visibleFromSideViewCompletionActions) {
            action.updateCompletionProviderResolver(this.aiCompletionProviderResolver);
        }
    }

    public Optional<PositronResolveCommentsAction> getHiddenFromSideViewResolveCommentsAction() {
        Optional<PositronAIActionBase> currentResolveCommentsAction = this.hiddenFromSideViewCompletionActions.stream().filter(act -> "action.resolve.comments".equals(act.getActionDetails().getId())).findAny();
        PositronResolveCommentsAction resolveCommentsAction = null;
        if (currentResolveCommentsAction.isPresent()) {
            resolveCommentsAction = (PositronResolveCommentsAction)currentResolveCommentsAction.get();
        } else {
            AIActionDetails actionDetails = this.retrieveAIAction("action.resolve.comments", Collections.emptyMap());
            if (actionDetails != null) {
                BaseActionInteractor actionInteractor = ActionInteractorFactory.createActionInteractor((AIActionDetails)actionDetails, (IDocumentCreator)this.documentCreator);
                actionInteractor.setAIContentEventListener(this.aiContentAppliedListener);
                resolveCommentsAction = (PositronResolveCommentsAction)this.createAction(actionInteractor);
                resolveCommentsAction.setCompletionImplementation(this.lastContentInserter, this.lastPrefixExtractor, this.userInputProvider);
                this.hiddenFromSideViewCompletionActions.add((PositronAIActionBase)resolveCommentsAction);
            }
        }
        return Optional.ofNullable(resolveCommentsAction);
    }

    public void addReloadActionListener(ReloadActionsListener reloadActionListener) {
        this.reloadActionListeners.add(reloadActionListener);
    }

    private void loadActions(ContentInserter contentInserter, DocumentContentInteractor prefixExtractor) {
        this.lastContentInserter = contentInserter;
        this.lastPrefixExtractor = prefixExtractor;
        log.debug("Load actions internal.");
        this.visibleFromSideViewCompletionActions.clear();
        for (AIActionDetails detail : this.visibleFromSideViewCompletionActionsDetails) {
            BaseActionInteractor actionInteractor = ActionInteractorFactory.createActionInteractor((AIActionDetails)detail, (IDocumentCreator)this.documentCreator);
            actionInteractor.setAIContentEventListener(this.aiContentAppliedListener);
            PositronAIActionBase completionAction = this.createAction(actionInteractor);
            if ("action.translate.to.lang".equals(detail.getId())) {
                completionAction.setActionCustomizer((PositronAIActionCustomizer)new TranslationActionCustomizer());
            }
            completionAction.setCompletionImplementation(contentInserter, prefixExtractor, this.userInputProvider);
            if (actionInteractor instanceof DefaultActionInteractor) {
                DefaultActionInteractor defaultInteractor = (DefaultActionInteractor)actionInteractor;
                defaultInteractor.setDocumentExtractor(prefixExtractor);
            }
            if (!ActionMatcherUtil.shouldAddAction((DocumentDetailsProvider)contentInserter, (AIActionDetails)detail)) continue;
            this.visibleFromSideViewCompletionActions.add(completionAction);
        }
        this.defaultActionInteractor = new DefaultActionInteractor(null);
        this.defaultActionInteractor.setCompletionInserter(contentInserter);
        this.defaultActionInteractor.setDocumentExtractor(prefixExtractor);
        this.defaultActionInteractor.setAIContentEventListener(this.aiContentAppliedListener);
    }

    private PositronAIActionBase createAction(BaseActionInteractor actionInteractor) {
        AIActionDetails detail = actionInteractor.getActionDetails();
        Object completionAction = null;
        ActionType actionType = detail.getComputedType();
        completionAction = actionType == ActionType.GENERATE_DOCUMENTATION_DRAFT ? new PositronDocumentationDraftAction(actionInteractor, this.aiCompletionProviderResolver, this.messagePresenter, this.chatInteractor, (OperationSemaphoreHandler)this, this.operationsStatusPresenter, this.documentCreator) : (actionType == ActionType.UPDATE_ENTIRE_DOCUMENT_BASED_ON_IMAGES ? new PositronUpdateDocumentBasedOnImagesAction(actionInteractor, this.aiCompletionProviderResolver, this.messagePresenter, this.chatInteractor, (OperationSemaphoreHandler)this, this.operationsStatusPresenter) : (actionType == ActionType.CREATE_NEW_DOCUMENT_FROM_TEXT ? new PositronAICreateDocumentAction(actionInteractor, this.aiCompletionProviderResolver, this.messagePresenter, this.chatInteractor, (OperationSemaphoreHandler)this, this.operationsStatusPresenter) : (actionType == ActionType.PROMPT_USER ? ("action.create.ai.topics".equals(detail.getId()) ? new CreateTopicsAction(actionInteractor, this.aiCompletionProviderResolver, this.messagePresenter, this.chatInteractor, (OperationSemaphoreHandler)this, this.operationsStatusPresenter) : new PositronAIPromptUserAction(actionInteractor, this.aiCompletionProviderResolver, this.messagePresenter, this.chatInteractor, (OperationSemaphoreHandler)this, this.operationsStatusPresenter)) : (actionType == ActionType.INSERT_SUGGESTION_FOR_LEFT_CONTENT ? new PositronAIInsertFragmentForLeftSuggestionAction(actionInteractor, this.aiCompletionProviderResolver, this.messagePresenter, this.chatInteractor, (OperationSemaphoreHandler)this, this.operationsStatusPresenter) : (ActionType.GENERATE_CONTENT_FROM_CONTEXT == actionType || ActionType.INSERT_SCHEMA_AWARE == actionType && detail.getId().startsWith("action.autocomplete") ? new PositronAIGenerateContentFromContextAction(actionInteractor, this.aiCompletionProviderResolver, this.messagePresenter, this.chatInteractor, (OperationSemaphoreHandler)this, this.operationsStatusPresenter) : (ActionType.INSERT_SCHEMA_AWARE == actionType && "action.document.code".equals(detail.getId()) ? new PositronAIInsertCommentAction(actionInteractor, this.aiCompletionProviderResolver, this.messagePresenter, this.chatInteractor, (OperationSemaphoreHandler)this, this.operationsStatusPresenter) : ("action.resolve.comments".equals(detail.getId()) ? new PositronResolveCommentsAction(actionInteractor, this.aiCompletionProviderResolver, this.messagePresenter, this.chatInteractor, (OperationSemaphoreHandler)this, this.operationsStatusPresenter) : new PositronAIActionBase(actionInteractor, this.aiCompletionProviderResolver, this.messagePresenter, this.chatInteractor, (OperationSemaphoreHandler)this, this.operationsStatusPresenter))))))));
        completionAction.setPreActionListener(new PreActionListener(){

            public void actionAboutToBeExecuted(PositronAIActionBase action) {
                if (action.getActionDetails() != null && !action.getActionDetails().getId().equals("action.translate.to.lang")) {
                    RecentlyUsedActionsOptionsStorageUtil.addToRecentlyUsedTheIdOfImmediatelyExecutingAction(action);
                }
            }
        });
        return completionAction;
    }

    public List<PositronAIActionBase> getCompletionActions() {
        return new ArrayList<PositronAIActionBase>(this.visibleFromSideViewCompletionActions);
    }

    public void setCompletionImplementation(ContentInserter completionInserter, DocumentContentInteractor prefixExtractor) {
        this.visibleFromSideViewCompletionActions.forEach(this.updateCompletionImplementation(completionInserter, prefixExtractor));
        this.pseudoActions.forEach(this.updateCompletionImplementation(completionInserter, prefixExtractor));
        this.hiddenFromSideViewCompletionActions.forEach(this.updateCompletionImplementation(completionInserter, prefixExtractor));
        this.defaultActionInteractor.setCompletionInserter(completionInserter);
        this.loadActions(completionInserter, prefixExtractor);
        this.loadPseudoActions(completionInserter, prefixExtractor);
        this.hiddenFromSideViewCompletionActions.clear();
        this.reloadActionListeners.stream().forEach(ReloadActionsListener::actionsReloaded);
    }

    private Consumer<? super PositronAIActionBase> updateCompletionImplementation(ContentInserter completionInserter, DocumentContentInteractor prefixExtractor) {
        return action -> action.setCompletionImplementation(completionInserter, prefixExtractor, this.userInputProvider);
    }

    public Semaphore getOperationInProgressSemaphore() {
        return this.operationInProgress;
    }

    public Thread loadAiActions(final ServerRequestListener requestListener, final boolean shouldRequestOnlyCustomAction) {
        Thread loader = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CompletionActionsManager.this.lock.lock();
                try {
                    List<AIActionDetails> builtInActions;
                    requestListener.beforeRequestStarted();
                    if (shouldRequestOnlyCustomAction) {
                        builtInActions = CompletionActionsManager.this.lastBuiltInActions;
                    } else {
                        CompletionActionsManager.this.lastBuiltInActions = builtInActions = new ArrayList<AIActionDetails>(CompletionActionsManager.this.removeDuplicatedOrInvalidActions(CompletionActionsManager.this.aiCompletionProviderResolver.getCurrentCompletionProvider().loadBuiltInActions()));
                    }
                    List<AIActionDetails> additionalActions = CompletionActionsManager.this.additionalActionsProvider.getActions().stream().map(AIActionDetails.class::cast).collect(Collectors.toList());
                    ArrayList<AIActionDetails> finalAdditionalActions = new ArrayList<AIActionDetails>(CompletionActionsManager.this.removeDuplicatedOrInvalidActions(additionalActions));
                    aiActionsInfoProvider.setAllCompletionActionsDetails(CompletionActionsManager.this.computeCompletionActionsDetails(builtInActions, finalAdditionalActions, false));
                    CompletionActionsManager.this.visibleFromSideViewCompletionActionsDetails = CompletionActionsManager.this.computeCompletionActionsDetails(builtInActions, finalAdditionalActions, true);
                    CompletionActionsManager.this.pseudoActionsDetails = CompletionActionsManager.this.computePseudoActionsDetails(builtInActions, finalAdditionalActions);
                    CompletionActionsManager.this.loadActions(CompletionActionsManager.this.lastContentInserter, CompletionActionsManager.this.lastPrefixExtractor);
                    CompletionActionsManager.this.loadPseudoActions(CompletionActionsManager.this.lastContentInserter, CompletionActionsManager.this.lastPrefixExtractor);
                    CompletionActionsManager.this.hiddenFromSideViewCompletionActions.clear();
                    CompletionActionsManager.this.reloadActionListeners.stream().forEach(ReloadActionsListener::actionsReloaded);
                }
                finally {
                    CompletionActionsManager.this.lock.unlock();
                    requestListener.requestEnded();
                }
            }
        });
        loader.start();
        return loader;
    }

    List<AIActionDetails> computeCompletionActionsDetails(List<AIActionDetails> serverActions, List<AIActionDetails> additionalActions, boolean isExcludeActionsFilteredFromPreferences) {
        Stream<AIActionDetails> stream;
        ArrayList<AIActionDetails> toReturnActions = new ArrayList<AIActionDetails>();
        Predicate<AIActionDetails> filterPseudoPredicate = actionDetails -> actionDetails.getComputedType() != ActionType.PSEUDO;
        Predicate<AIActionDetails> filterExcludedFromPreferencesPredicate = actionDetails -> !aiActionsInfoProvider.getExcludedActions().isExcludedAction(actionDetails.getId());
        if (Boolean.parseBoolean(this.optionsStorage.getOption("oxygen.positron.plugin.load.default.actions", String.valueOf(Boolean.TRUE)))) {
            stream = serverActions.stream().filter(filterPseudoPredicate);
            if (isExcludeActionsFilteredFromPreferences) {
                stream = stream.filter(filterExcludedFromPreferencesPredicate);
            }
            toReturnActions.addAll(stream.collect(Collectors.toList()));
        }
        additionalActions.forEach(action -> toReturnActions.removeIf(actionDetails -> Objects.equals(action.getId(), actionDetails.getId())));
        stream = additionalActions.stream().filter(filterPseudoPredicate);
        if (isExcludeActionsFilteredFromPreferences) {
            stream = stream.filter(filterExcludedFromPreferencesPredicate);
        }
        stream.forEach(toReturnActions::add);
        return toReturnActions;
    }

    List<AIActionDetails> computePseudoActionsDetails(List<AIActionDetails> serverActions, List<AIActionDetails> additionalActions) {
        ArrayList<AIActionDetails> toReturnActions = new ArrayList<AIActionDetails>();
        ExcludedPositronActions excludedActions = aiActionsInfoProvider.getExcludedActions();
        Predicate<AIActionDetails> filterPseudoActionsPredicate = actionDetails -> "pseudoaction.chat.message.agent".equals(actionDetails.getId()) || !excludedActions.isExcludedAction(actionDetails.getId());
        toReturnActions.addAll(serverActions.stream().filter(actionDetails -> actionDetails.getComputedType() == ActionType.PSEUDO).filter(filterPseudoActionsPredicate).collect(Collectors.toList()));
        additionalActions.forEach(action -> toReturnActions.removeIf(actionDetails -> Objects.equals(action.getId(), actionDetails.getId())));
        additionalActions.stream().filter(actionDetails -> actionDetails.getComputedType() == ActionType.PSEUDO).filter(filterPseudoActionsPredicate).forEach(toReturnActions::add);
        return toReturnActions;
    }

    Collection<AIActionDetails> removeDuplicatedOrInvalidActions(List<AIActionDetails> completionActionsDetails) {
        HashSet addedActions = new HashSet();
        ArrayList<AIActionDetails> uniqueActions = new ArrayList<AIActionDetails>();
        completionActionsDetails.forEach(actionDetails -> {
            if (actionDetails.getId() == null) {
                log.error("Skipping action with null ID.");
            } else if (addedActions.contains(actionDetails.getId())) {
                log.error("Duplicated action ID: {}", (Object)actionDetails.getId());
            } else {
                if (actionDetails.getPrompt() == null) {
                    log.error("Action with no prompt: {}", (Object)actionDetails.getId());
                }
                uniqueActions.add((AIActionDetails)actionDetails);
                addedActions.add(actionDetails.getId());
            }
        });
        return uniqueActions;
    }

    public DefaultActionInteractor getDefaultActionInteractor() {
        return this.defaultActionInteractor;
    }

    public AIActionDetails getPseudoActionDetailsByID(String actionId) {
        return this.pseudoActionsDetails.stream().filter(action -> Objects.equals(action.getId(), actionId)).findFirst().orElse(null);
    }

    public PositronAIActionBase getPositronAIActionBaseByID(String actionId) {
        Predicate<PositronAIActionBase> actionIDFilter = action -> Objects.equals(action.getActionDetails().getId(), actionId);
        return this.visibleFromSideViewCompletionActions.stream().filter(actionIDFilter).findFirst().orElse(this.pseudoActions.stream().filter(actionIDFilter).findFirst().orElse(null));
    }

    public PositronAIActionBase getPositronAIAction(String actionId) {
        return this.getPositronAIActionBaseByID(actionId);
    }

    public List<AIActionDetails> getCompletionActionsDetails() {
        return this.visibleFromSideViewCompletionActionsDetails;
    }

    private void loadPseudoActions(ContentInserter contentInserter, DocumentContentInteractor prefixExtractor) {
        this.pseudoActions.clear();
        this.lastContentInserter = contentInserter;
        for (AIActionDetails detail : this.pseudoActionsDetails) {
            PositronAIFixAction completionAction = null;
            BaseActionInteractor actionInteractor = ActionInteractorFactory.createActionInteractor((AIActionDetails)detail, (IDocumentCreator)this.documentCreator);
            actionInteractor.setAIContentEventListener(this.aiContentAppliedListener);
            if ("pseudoaction.quick.fix".equals(detail.getId())) {
                completionAction = new PositronAIFixAction(actionInteractor, this.aiCompletionProviderResolver, this.messagePresenter, this.chatInteractor, (OperationSemaphoreHandler)this, this.operationsStatusPresenter);
            } else if (detail.getId() != null && detail.getId().startsWith("pseudoaction.chat.message.")) {
                completionAction = new PositronAIActionBase(actionInteractor, this.aiCompletionProviderResolver, this.messagePresenter, this.chatInteractor, (OperationSemaphoreHandler)this, this.operationsStatusPresenter);
            } else if ("pseudoaction.copilot.rewrite.content.based.on.instructions".equals(detail.getId())) {
                completionAction = new PositronCopilotProcessContentBasedOnUserInstructionsAction(actionInteractor, this.aiCompletionProviderResolver, this.messagePresenter, this.chatInteractor, (OperationSemaphoreHandler)this, this.operationsStatusPresenter);
            } else if (detail.getId() != null && ActionsUtil.isNewFileWithAIPseudoaction((String)detail.getId())) {
                completionAction = new PositronAIActionBase(actionInteractor, this.aiCompletionProviderResolver, this.messagePresenter, this.chatInteractor, (OperationSemaphoreHandler)this, this.operationsStatusPresenter);
            }
            if (completionAction == null) continue;
            completionAction.setCompletionImplementation(contentInserter, prefixExtractor, this.userInputProvider);
            this.pseudoActions.add((PositronAIActionBase)completionAction);
        }
    }

    public boolean isAdditionalActionsFile(File file) throws IOException {
        return this.additionalActionsProvider.isFileFromAdditionalActionsFolder(file);
    }

    public AIActionDetails retrieveAIAction(String id, Map<String, Object> parameters) {
        Predicate<AIActionDetails> actionIdFilter = action -> Objects.equals(action.getId(), id);
        return this.pseudoActionsDetails.stream().filter(actionIdFilter).findFirst().orElse(this.visibleFromSideViewCompletionActionsDetails.stream().filter(actionIdFilter).findFirst().orElse(null));
    }

    public List<PositronAIActionBase> getPseudoActions() {
        return this.pseudoActions;
    }

    public ContentInserter getLastContentInserter() {
        return this.lastContentInserter;
    }
}

