/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.chat.quickfind;

import com.oxygenxml.positron.plugin.chat.quickfind.PositronActionWrapper;
import com.oxygenxml.positron.plugin.chat.quickfind.QuickSearchItemSelectionListener;
import com.oxygenxml.positron.plugin.chat.quickfind.QuickSearchListItem;
import com.oxygenxml.positron.plugin.ui.TextFieldWithPlaceHolder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.event.CaretEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import ro.sync.exml.workspace.api.standalone.ui.OxygenUIComponentsFactory;

public class GenericFilteringPanel<T extends QuickSearchListItem>
extends JPanel {
    private static final int SECONDARY_TEXT_MATCH_PRIORITY = 1;
    private static final int DISPLAY_TEXT_MATCH_PRIORITY = 3;
    private static final String COMMIT_ACTION = "commit";
    private final ListWithPublicKeyEventProcessor<T> suggestionList;
    private JTextField searchField;
    private DefaultListModel<T> listModel;
    private JScrollPane listScroll;
    private List<T> allItems;
    private QuickSearchItemSelectionListener<T> itemSelectionListener;
    private static final int NO_OF_ROWS_TO_SHOW = 8;

    public GenericFilteringPanel(List<T> items, String placeholderText) {
        super(new BorderLayout());
        this.allItems = new ArrayList<T>(items);
        this.listModel = new DefaultListModel();
        this.suggestionList = new ListWithPublicKeyEventProcessor<T>(this.listModel);
        this.suggestionList.addMouseListener(this.createSuggestionsListMouseListener());
        this.suggestionList.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 0));
        this.setSuggestionsListRenderer();
        this.listScroll = new JScrollPane(this.suggestionList);
        this.searchField = new TextFieldWithPlaceHolder(placeholderText, true);
        this.searchField.addKeyListener(this.createSearchFieldKeyListener());
        this.searchField.getDocument().addDocumentListener(this.createSearchFieldDocListener());
        this.searchField.addCaretListener(this::findSuggestionsCaretMoved);
        this.searchField.getInputMap().put(KeyStroke.getKeyStroke(10, 0), COMMIT_ACTION);
        this.searchField.getActionMap().put(COMMIT_ACTION, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!GenericFilteringPanel.this.suggestionList.isSelectionEmpty() && GenericFilteringPanel.this.suggestionList.isVisible()) {
                    QuickSearchListItem selectedValue = (QuickSearchListItem)GenericFilteringPanel.this.suggestionList.getSelectedValue();
                    GenericFilteringPanel.this.selectItem(selectedValue);
                }
            }
        });
        this.setMatchesBasedOnPrefix("");
        this.setLayout(new BorderLayout());
        this.add((Component)this.searchField, "North");
        this.add((Component)this.listScroll, "Center");
        int height = this.getFontMetrics(this.suggestionList.getFont()).getHeight();
        this.setSize(this.getPreferredSize().width, 8 * height);
    }

    private void setSuggestionsListRenderer() {
        this.suggestionList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component comp = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value instanceof QuickSearchListItem) {
                    QuickSearchListItem item = (QuickSearchListItem)value;
                    this.setText(item.getDisplayText());
                    this.setToolTipText(item.getSecondaryText());
                }
                return comp;
            }
        });
    }

    private MouseAdapter createSuggestionsListMouseListener() {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                QuickSearchListItem selectedValue;
                if (e.getClickCount() == 2 && (selectedValue = (QuickSearchListItem)GenericFilteringPanel.this.suggestionList.getSelectedValue()) != null) {
                    GenericFilteringPanel.this.selectItem(selectedValue);
                }
            }
        };
    }

    private KeyAdapter createSearchFieldKeyListener() {
        return new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int keyCode = e.getKeyCode();
                if (keyCode == 38 || keyCode == 40 || keyCode == 33 || keyCode == 34) {
                    GenericFilteringPanel.this.suggestionList.processKeyEvent(e);
                }
            }
        };
    }

    private DocumentListener createSearchFieldDocListener() {
        return new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                GenericFilteringPanel.this.findSuggestions(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                GenericFilteringPanel.this.findSuggestions(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                GenericFilteringPanel.this.findSuggestions(e);
            }
        };
    }

    private void findSuggestionsCaretMoved(CaretEvent e) {
        String prefix = this.searchField.getText();
        this.setMatchesBasedOnPrefix(prefix);
    }

    private void findSuggestions(DocumentEvent e) {
        String prefix = this.searchField.getText();
        this.setMatchesBasedOnPrefix(prefix);
    }

    public void setMatchesBasedOnPrefix(String prefix) {
        List<QuickSearchListItem> matches = this.getMatches(prefix, this.allItems);
        this.listModel.clear();
        matches.forEach(this.listModel::addElement);
        if (!matches.isEmpty() && this.suggestionList.getSelectedIndex() == -1) {
            this.suggestionList.setSelectedIndex(0);
        }
    }

    private void selectItem(T item) {
        if (this.itemSelectionListener != null) {
            this.itemSelectionListener.onItemSelected(item);
        }
    }

    public List<T> getMatches(String prefix, List<T> items) {
        if (prefix == null || prefix.trim().isEmpty()) {
            return new ArrayList<T>(items);
        }
        String normalizedPrefix = prefix.toLowerCase(Locale.ROOT);
        ArrayList<ItemPriorityPair<QuickSearchListItem>> itemsWithPriority = new ArrayList<ItemPriorityPair<QuickSearchListItem>>();
        for (QuickSearchListItem item : items) {
            String secondaryText;
            double priority = 0.0;
            String displayText = item.getDisplayText();
            if (displayText != null && (displayText = displayText.toLowerCase(Locale.ROOT)).contains(normalizedPrefix)) {
                priority += 3.0;
                priority += GenericFilteringPanel.getAddedValue(prefix, displayText.toLowerCase(), 3.0);
            }
            if ((secondaryText = item.getSecondaryText()) != null && (secondaryText = secondaryText.toLowerCase(Locale.ROOT)).contains(normalizedPrefix)) {
                priority += 1.0;
                priority += GenericFilteringPanel.getAddedValue(prefix, secondaryText.toLowerCase(), 1.0);
            }
            if (!(priority > 0.0)) continue;
            itemsWithPriority.add(new ItemPriorityPair<QuickSearchListItem>(item, priority));
        }
        return itemsWithPriority.stream().sorted(Comparator.comparing(new Function<ItemPriorityPair<T>, Double>(){

            @Override
            public Double apply(ItemPriorityPair<T> t) {
                return t.getPriority();
            }
        }).reversed()).map(ItemPriorityPair::getItem).collect(Collectors.toList());
    }

    private static double getAddedValue(String prefix, String actionPropertyValue, double weightFactor) {
        double priority = 0.0;
        if (actionPropertyValue.startsWith(prefix)) {
            priority += weightFactor;
        }
        int indexOfMatch = actionPropertyValue.indexOf(prefix);
        return priority += weightFactor * (double)(actionPropertyValue.length() - indexOfMatch) / (double)actionPropertyValue.length();
    }

    public void setItemSelectionListener(QuickSearchItemSelectionListener<T> listener) {
        this.itemSelectionListener = listener;
    }

    public DefaultListModel<T> getListModel() {
        return this.listModel;
    }

    public List<T> getItems() {
        return this.allItems;
    }

    public void applyAndExecuteSuggestion(PositronActionWrapper suggestion) {
        this.searchField.setText(suggestion.getAction().getActionDetails().getTitle());
        this.listModel.clear();
        suggestion.getAction().actionPerformed(false);
    }

    public ListWithPublicKeyEventProcessor<T> getSuggestionList() {
        return this.suggestionList;
    }

    public JTextField getSearchField() {
        return this.searchField;
    }

    private static class ListWithPublicKeyEventProcessor<T>
    extends JList<T> {
        public ListWithPublicKeyEventProcessor(ListModel<T> dataModel) {
            super(dataModel);
        }

        @Override
        public void processKeyEvent(KeyEvent e) {
            super.processKeyEvent(e);
        }

        @Override
        public JToolTip createToolTip() {
            return OxygenUIComponentsFactory.installMultilineTooltip((JComponent)this);
        }
    }

    public static final class ItemPriorityPair<T> {
        private T item;
        private Double priority;

        public ItemPriorityPair(T item, Double priority) {
            this.item = item;
            this.priority = priority;
        }

        public T getItem() {
            return this.item;
        }

        public Double getPriority() {
            return this.priority;
        }
    }
}

