/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.chat.history;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Iterables;
import com.oxygenxml.positron.api.connector.dto.Message;
import com.oxygenxml.positron.api.connector.dto.ToolCallResponseMessage;
import com.oxygenxml.positron.plugin.chat.history.CorrectionMessageNode;
import com.oxygenxml.positron.plugin.chat.history.MessageNode;
import com.oxygenxml.positron.plugin.chat.history.MessageTreeConversation;
import com.oxygenxml.positron.plugin.chat.history.ToolsMessageNode;
import com.oxygenxml.positron.plugin.chat.history.ValidationErrorMessageNode;
import java.util.ArrayList;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true, allowGetters=false, allowSetters=false)
public class MessageTreeModel {
    @JsonProperty(value="conversationId")
    private long conversationId;
    @JsonProperty(value="root")
    private MessageNode rootNode = new MessageNode(null, null);

    public MessageTreeModel() {
        this.conversationId = System.currentTimeMillis();
    }

    public void addToolCallMessage(Message msg, List<Integer> pathToNode, String engineModel) {
        ToolsMessageNode newNode = new ToolsMessageNode(msg, engineModel);
        MessageNode parent = this.getLastMessageInPath(pathToNode);
        parent.addChild(newNode);
        pathToNode.add(parent.getContentNodes().size() - 1);
    }

    public void addToolCallDescriptionOnToolMessage(List<Integer> pathToNode, String toolCallDescription) {
        MessageNode node = this.getLastMessageInPath(pathToNode);
        if (node instanceof ToolsMessageNode) {
            ((ToolsMessageNode)node).addToolCallDescription(toolCallDescription);
        }
    }

    public void addToolCallError(List<Integer> pathToNode, String errorMessage) {
        MessageNode node = this.getLastMessageInPath(pathToNode);
        if (node instanceof ToolsMessageNode) {
            ((ToolsMessageNode)node).addToolCallError(errorMessage);
        }
    }

    public void addToolResponseOnToolMessage(List<Integer> pathToNode, ToolCallResponseMessage newToolResponse) {
        MessageNode node = this.getLastMessageInPath(pathToNode);
        if (node instanceof ToolsMessageNode) {
            ((ToolsMessageNode)node).addToolResponseMessageOnLastCall(newToolResponse);
        }
    }

    public void addMessage(Message msg, List<Integer> pathToNode, String engineModel) {
        MessageNode newNode = new MessageNode(msg, engineModel);
        MessageNode parent = this.getLastMessageInPath(pathToNode);
        parent.addChild(newNode);
        pathToNode.add(parent.getContentNodes().size() - 1);
    }

    public List<Integer> editNode(List<Integer> pathToNode, Message newMessage, String engineModelThatGeneratedTheResponse) {
        ArrayList<Integer> copyOfPathToNode = new ArrayList<Integer>(pathToNode);
        copyOfPathToNode.remove(copyOfPathToNode.size() - 1);
        MessageNode parent = this.getLastMessageInPath(copyOfPathToNode);
        parent.addChild(new MessageNode(newMessage, engineModelThatGeneratedTheResponse));
        Integer nodeInsertionIndex = parent.getContentNodes().size() - 1;
        copyOfPathToNode.add(nodeInsertionIndex);
        return copyOfPathToNode;
    }

    @JsonIgnore
    public List<MessageNode> getMessagesPath(List<Integer> pathToNode) {
        return new ArrayList<MessageNode>(this.getMessageNodesPath(pathToNode));
    }

    @JsonIgnore
    public MessageNode getLastMessageInPath(List<Integer> pathToNode) {
        if (pathToNode.isEmpty()) {
            return this.rootNode;
        }
        return (MessageNode)Iterables.getLast(this.getMessageNodesPath(pathToNode));
    }

    @JsonIgnore
    private List<MessageNode> getMessageNodesPath(List<Integer> pathToNode) {
        ArrayList<MessageNode> messages = new ArrayList<MessageNode>();
        MessageNode editedNode = this.rootNode;
        for (Integer i : pathToNode) {
            editedNode = editedNode.getContentNodes().get(i);
            messages.add(editedNode);
        }
        return messages;
    }

    public long getConversationId() {
        return this.conversationId;
    }

    @JsonIgnore
    public MessageTreeConversation findNewestConversation(List<Integer> startPath) {
        ArrayList<MessageNode> messages = new ArrayList<MessageNode>();
        ArrayList<Integer> messagesIndexPath = new ArrayList<Integer>(startPath);
        MessageNode editedNode = this.rootNode;
        for (Integer i : messagesIndexPath) {
            editedNode = editedNode.getContentNodes().get(i);
            messages.add(editedNode);
        }
        this.exploreNewestPath(editedNode, messages, messagesIndexPath);
        return new MessageTreeConversation(messages, messagesIndexPath);
    }

    @JsonIgnore
    private void exploreNewestPath(MessageNode editedNode, List<MessageNode> nodes, List<Integer> updatedIndex) {
        List<MessageNode> contentNodes;
        if (editedNode != null && !(contentNodes = editedNode.getContentNodes()).isEmpty()) {
            int position = contentNodes.size() - 1;
            MessageNode rightMost = contentNodes.get(position);
            nodes.add(rightMost);
            updatedIndex.add(position);
            this.exploreNewestPath(rightMost, nodes, updatedIndex);
        }
    }

    public boolean isConversationAvailableFor(List<Integer> path) {
        MessageNode editedNode = this.rootNode;
        for (Integer i : path) {
            List<MessageNode> contentNodes = editedNode.getContentNodes();
            if (i < contentNodes.size()) {
                editedNode = contentNodes.get(i);
                continue;
            }
            return false;
        }
        return true;
    }

    public int getMaxLevelIndex(List<Integer> messagesIndexPath) {
        List<Object> lastLevelNodes = new ArrayList(0);
        MessageNode editedNode = this.rootNode;
        for (Integer i : messagesIndexPath) {
            lastLevelNodes = editedNode.getContentNodes();
            editedNode = (MessageNode)lastLevelNodes.get(i);
        }
        return lastLevelNodes.size() - 1;
    }

    public List<Integer> addValidationErrorNode(List<Integer> pathToNode, ValidationErrorMessageNode validationErrorNode) {
        MessageNode parent = this.getLastMessageInPath(pathToNode);
        parent.addChild(validationErrorNode);
        ArrayList<Integer> newPath = new ArrayList<Integer>(pathToNode);
        newPath.add(parent.getContentNodes().size() - 1);
        return newPath;
    }

    public List<Integer> addCorrectionNode(List<Integer> pathToNode, CorrectionMessageNode correctionNode) {
        MessageNode parent = this.getLastMessageInPath(pathToNode);
        parent.addChild(correctionNode);
        ArrayList<Integer> newPath = new ArrayList<Integer>(pathToNode);
        newPath.add(parent.getContentNodes().size() - 1);
        return newPath;
    }
}

