/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.chat.attachments;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.LinkedList;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WrapLayout
extends FlowLayout {
    private static final Logger logger = LoggerFactory.getLogger((String)WrapLayout.class.getName());
    private Dimension lastBadSizeRefreshRequest;
    private boolean shouldRemoveTopPadding;
    private boolean shouldRemoveLeftPadding;

    public WrapLayout(int align, int hgap, int vgap, boolean shouldRemoveTopPadding, boolean shouldRemoveLeftPadding) {
        super(align, hgap, vgap);
        this.shouldRemoveTopPadding = shouldRemoveTopPadding;
        this.shouldRemoveLeftPadding = shouldRemoveLeftPadding;
    }

    public void setRemoveLeftPadding(boolean removeLeftPadding) {
        this.shouldRemoveLeftPadding = removeLeftPadding;
    }

    @Override
    public Dimension preferredLayoutSize(Container target) {
        return this.layoutSize(target, true);
    }

    @Override
    public Dimension minimumLayoutSize(Container target) {
        Dimension minimum = this.layoutSize(target, false);
        minimum.width -= this.getHgap() + 1;
        return minimum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension layoutSize(Container container, boolean preferred) {
        Object object = container.getTreeLock();
        synchronized (object) {
            int containerWidth = container.getSize().width;
            if (containerWidth == 0) {
                containerWidth = Integer.MAX_VALUE;
            }
            int containerHorizontalGap = this.getHgap();
            int containerVerticalGap = this.getVgap();
            Insets insets = container.getInsets();
            int horizontalInsetsAndGap = insets.left + insets.right + containerHorizontalGap * 2;
            int maxWidth = containerWidth - horizontalInsetsAndGap;
            Dimension containerDim = new Dimension(0, 0);
            int rowWidth = 0;
            int rowHeight = 0;
            int componentCount = container.getComponentCount();
            for (int i = 0; i < componentCount; ++i) {
                Dimension compDimension;
                Component component = container.getComponent(i);
                if (!component.isVisible()) continue;
                Dimension dimension = compDimension = preferred ? component.getPreferredSize() : component.getMinimumSize();
                if (rowWidth + compDimension.width > maxWidth) {
                    this.addNewRow(containerDim, rowWidth, rowHeight);
                    rowWidth = 0;
                    rowHeight = 0;
                }
                if (rowWidth != 0) {
                    rowWidth += containerHorizontalGap;
                }
                rowWidth += compDimension.width;
                rowHeight = Math.max(rowHeight, compDimension.height);
            }
            this.addNewRow(containerDim, rowWidth, rowHeight);
            containerDim.width += horizontalInsetsAndGap;
            containerDim.height += insets.top + insets.bottom + containerVerticalGap;
            Container scrollPane = SwingUtilities.getAncestorOfClass(JScrollPane.class, container);
            if (scrollPane != null) {
                containerDim.width -= containerHorizontalGap + 1;
            }
            return containerDim;
        }
    }

    @Override
    public void layoutContainer(Container target) {
        int horizontalGap;
        super.layoutContainer(target);
        int verticalGap = this.getVgap();
        if (verticalGap > 0 && this.shouldRemoveTopPadding) {
            int componentCount = target.getComponentCount();
            for (int i = 0; i < componentCount; ++i) {
                Component c = target.getComponent(i);
                if (!c.isVisible()) continue;
                Insets insets = target.getInsets();
                int expectedTopWithGap = insets.top + verticalGap;
                if (c.getY() < expectedTopWithGap) break;
                for (int j = 0; j < componentCount; ++j) {
                    Component cj = target.getComponent(j);
                    if (!cj.isVisible()) continue;
                    cj.setLocation(cj.getX(), cj.getY() - verticalGap);
                }
                break;
            }
        }
        if ((horizontalGap = this.getHgap()) > 0 && this.shouldRemoveLeftPadding) {
            int componentCount = target.getComponentCount();
            for (int i = 0; i < componentCount; ++i) {
                Component c = target.getComponent(i);
                if (!c.isVisible()) continue;
                Insets insets = target.getInsets();
                int expectedLeftWithGap = insets.left + horizontalGap;
                if (c.getX() < expectedLeftWithGap) break;
                for (int j = 0; j < componentCount; ++j) {
                    Component cj = target.getComponent(j);
                    if (!cj.isVisible()) continue;
                    cj.setLocation(cj.getX() - horizontalGap, cj.getY());
                }
                break;
            }
        }
        this.ensureRequiredHeight(target);
    }

    private void ensureRequiredHeight(Container target) {
        Dimension size = target.getSize();
        int neededHeight = -1;
        boolean outside = false;
        int noOfTargetComponents = target.getComponentCount();
        if (noOfTargetComponents > 0) {
            Component comp = target.getComponent(noOfTargetComponents - 1);
            Rectangle bounds = comp.getBounds();
            neededHeight = bounds.y + bounds.height;
            if (neededHeight > size.height) {
                outside = true;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Outside " + outside);
        }
        if (outside) {
            if (!size.equals(this.lastBadSizeRefreshRequest)) {
                this.lastBadSizeRefreshRequest = size;
                LinkedList<Container> parents = new LinkedList<Container>();
                for (Container parent = target.getParent(); parent != null; parent = parent.getParent()) {
                    parents.add(parent);
                    if (parent.getSize().height <= neededHeight) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug("Ancestor with enough height: " + parent);
                    }
                    SwingUtilities.invokeLater(() -> {
                        for (Container container : parents) {
                            container.invalidate();
                            container.revalidate();
                        }
                    });
                    break;
                }
            }
        } else {
            this.lastBadSizeRefreshRequest = null;
        }
    }

    private void addNewRow(Dimension dim, int rowWidth, int rowHeight) {
        dim.width = Math.max(dim.width, rowWidth);
        if (dim.height > 0) {
            dim.height += this.getVgap();
        }
        dim.height += rowHeight;
    }
}

