/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.chat.attachments;

import com.oxygenxml.positron.plugin.chat.attachments.AttachmentHighlightAwareTextArea;
import com.oxygenxml.positron.plugin.chat.attachments.AttachmentsPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import ro.sync.exml.workspace.api.standalone.ui.OxygenUIComponentsFactory;

public class TextAreaWithAttachmentsSupport
extends JPanel {
    private AttachmentHighlightAwareTextArea textArea;
    private AttachmentsPanel attachmentsPanel;
    private boolean defaultFocusOwner = true;

    public TextAreaWithAttachmentsSupport(String hint) {
        this.setLayout(new GridBagLayout());
        this.attachmentsPanel = new AttachmentsPanel(null, null, true, true);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 11;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.attachmentsPanel, gbc);
        this.textArea = new AttachmentHighlightAwareTextArea(hint, null, this.attachmentsPanel);
        JScrollPane scrollPane = OxygenUIComponentsFactory.createScrollPane((Component)this.textArea, (int)20, (int)30);
        ++gbc.gridy;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(0, 0, 5, 0);
        gbc.fill = 1;
        this.add((Component)scrollPane, gbc);
    }

    public String getText() {
        return this.textArea.getPlainTextContentWithAttachmentsExpanded() + this.textArea.getUnreferencedAttachmentsWithMarkerToAddToModel();
    }

    public Document getDocument() {
        return this.textArea.getDocument();
    }

    public void setText(String text) {
        this.attachmentsPanel.clearAttachments();
        this.textArea.setText(text);
    }

    public void selectAll() {
        this.textArea.selectAll();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.defaultFocusOwner) {
            SwingUtilities.invokeLater(() -> {
                if (this.textArea != null) {
                    this.textArea.requestFocusInWindow();
                }
            });
        }
    }

    public void setDefaultFocusOwner(boolean defaultFocusOwner) {
        this.defaultFocusOwner = defaultFocusOwner;
    }
}

