/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.chat.attachments;

import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.core.util.attach.MessageAttachmentUtils;
import com.oxygenxml.positron.core.util.attach.SelectionAttachmentUtil;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import ro.sync.basic.util.URLUtil;

public class MessageDescriptionUtil {
    public static String computeHumanReadableDescription(String chatContent) {
        chatContent = chatContent.replace("#################attachments#################", "");
        StringBuilder builder = new StringBuilder();
        Matcher matcher = MessageAttachmentUtils.ATTACH_PATTERN.matcher(chatContent);
        while (matcher.find()) {
            String resource = matcher.group(1);
            if (SelectionAttachmentUtil.isSelectionURL((String)resource)) {
                Map<String, String> queryParams = MessageDescriptionUtil.getQueryParams(resource);
                String contentValue = queryParams.get("oxycontent");
                if (contentValue != null) {
                    String decodeURIComponent = SelectionAttachmentUtil.decodeURIComponent((String)contentValue);
                    matcher.appendReplacement(builder, Matcher.quoteReplacement(decodeURIComponent));
                    continue;
                }
                matcher.appendReplacement(builder, Matcher.quoteReplacement(" @selection "));
                continue;
            }
            String humanReadableLocation = resource;
            URL urlWithoutUserInfo = URLUtil.clearUserInfo((String)resource);
            humanReadableLocation = urlWithoutUserInfo != null ? MessageDescriptionUtil.toHumanFormInternal(urlWithoutUserInfo) : MessageDescriptionUtil.toHumanFormInternal(URLUtil.convertToURL((String)humanReadableLocation));
            matcher.appendReplacement(builder, Matcher.quoteReplacement(" " + Translator.getInstance().getTranslation("Attach") + " " + humanReadableLocation));
        }
        matcher.appendTail(builder);
        return builder.toString();
    }

    private static String toHumanFormInternal(URL url) {
        String humanReadableLocation = URLUtil.isFromLocalDrive((URL)url) ? URLUtil.getDescription((URL)url) : URLUtil.decodeURIComponent((String)url.toExternalForm());
        return humanReadableLocation;
    }

    private static Map<String, String> getQueryParams(String url) {
        HashMap<String, String> params = new HashMap<String, String>();
        int questionMarkIndex = url.indexOf("?");
        if (questionMarkIndex != -1) {
            String[] pairs;
            String query = url.substring(questionMarkIndex + 1);
            for (String pair : pairs = query.split("&")) {
                String[] keyValue = pair.split("=", 2);
                if (keyValue.length == 2) {
                    params.put(keyValue[0], URLUtil.decodeURIComponent((String)keyValue[1]));
                    continue;
                }
                if (keyValue.length != 1) continue;
                params.put(keyValue[0], "");
            }
        }
        return params;
    }
}

