/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.chat.attachments;

import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.core.util.attach.SelectionAttachmentUtil;
import com.oxygenxml.positron.plugin.chat.actions.AttachFileToChatMessageAction;
import com.oxygenxml.positron.plugin.chat.attachments.AttachmentChip;
import com.oxygenxml.positron.plugin.chat.attachments.AttachmentReferenceUpdaterWhenSelectionChanges;
import com.oxygenxml.positron.plugin.chat.attachments.AttachmentsChangedListener;
import com.oxygenxml.positron.plugin.chat.attachments.ChatChipAttachmentManager;
import com.oxygenxml.positron.plugin.chat.attachments.SelectionChip;
import com.oxygenxml.positron.plugin.chat.attachments.WrapLayout;
import com.oxygenxml.positron.plugin.util.IconsLoader;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import ro.sync.exml.workspace.api.standalone.ui.OxygenUIComponentsFactory;

public class AttachmentsPanel
extends JPanel
implements ChatChipAttachmentManager {
    private static final Translator I18N = Translator.getInstance();
    private static final long serialVersionUID = 1L;
    private final Set<URL> attachments = new LinkedHashSet<URL>();
    private final List<AttachmentsChangedListener> attachmentsChangedListeners = new ArrayList<AttachmentsChangedListener>();
    private final JPopupMenu popupMenu;
    private final AbstractAction removeAllAction;
    private JButton attachFilesButton;
    private Supplier<String> currentSelectedEditorContentSupplier;
    private AttachmentReferenceUpdaterWhenSelectionChanges referncesUpdater;
    private SelectionChip selectionChip = new SelectionChip(() -> {
        for (URL url : this.attachments) {
            boolean isSelectionURL = SelectionAttachmentUtil.isSelectionURL((URL)url);
            if (!isSelectionURL) continue;
            this.attachmentsChangedListeners.forEach(l -> l.attachmentRemoved(url));
        }
        this.updateSelectionChip(null, null, null);
    });
    private static final String NO_SELECTION_PLACEHOLDER = "<No_Selection>";

    public AttachmentsPanel() {
        this(null, null, false, false);
    }

    public AttachmentsPanel(Supplier<String> currentSelectedEditorContentSupplier, AttachmentReferenceUpdaterWhenSelectionChanges referncesUpdater, boolean shouldRemoveTopPadding, boolean shouldRemoveLeftPadding) {
        this.currentSelectedEditorContentSupplier = currentSelectedEditorContentSupplier;
        this.referncesUpdater = referncesUpdater;
        this.setOpaque(false);
        this.setLayout(new WrapLayout(0, 5, 5, shouldRemoveTopPadding, shouldRemoveLeftPadding));
        AttachFileToChatMessageAction action = new AttachFileToChatMessageAction(t -> this.addAttachment(t), I18N.getTranslation("Attach"), IconsLoader.loadIcon("/images/Attachment16.png"));
        this.attachFilesButton = OxygenUIComponentsFactory.createToolbarButton((Action)action, (boolean)true);
        this.attachFilesButton.setHorizontalTextPosition(11);
        this.attachFilesButton.setVerticalTextPosition(0);
        this.add(this.attachFilesButton);
        this.add(this.selectionChip);
        this.popupMenu = OxygenUIComponentsFactory.createPopupMenu();
        this.removeAllAction = new AbstractAction(I18N.getTranslation("Remove_attachments")){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttachmentsPanel.this.clearAttachments();
            }
        };
        this.removeAllAction.putValue("SmallIcon", IconsLoader.loadIcon("/images/RemoveAll16.png"));
        this.popupMenu.add(this.removeAllAction);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger() && AttachmentsPanel.this.hasAttachments() && AttachmentsPanel.this.isEnabled()) {
                    AttachmentsPanel.this.popupMenu.show(AttachmentsPanel.this, e.getX(), e.getY());
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                AttachmentsPanel.this.updateAllChipsLabelText();
            }
        });
    }

    @Override
    public void setAttachmentComponentsVisible(boolean visible) {
        this.removeAllAction.setEnabled(visible);
        this.attachFilesButton.setVisible(visible);
        for (int i = 0; i < this.getComponentCount(); ++i) {
            if (!(this.getComponent(i) instanceof AttachmentChip)) continue;
            AttachmentChip attachmentChip = (AttachmentChip)this.getComponent(i);
            attachmentChip.setRemoveChipButtonVisible(visible);
        }
    }

    @Override
    public void addAttachmentsChangedListener(AttachmentsChangedListener listener) {
        this.attachmentsChangedListeners.add(listener);
    }

    @Override
    public void removeAttachmentsChangedListener(AttachmentsChangedListener listener) {
        this.attachmentsChangedListeners.remove(listener);
    }

    @Override
    public boolean addAttachment(URL resource) {
        boolean added = SelectionAttachmentUtil.isSelectionURL((URL)resource) ? this.addSelectionAttachment(resource) : this.addResourceAttachment(resource);
        this.updateAttachButtonTextState();
        return added;
    }

    private boolean addSelectionAttachment(URL resource) {
        String content = this.resolveSelectionContent(resource);
        String tooltipPrefix = this.determineTooltipPrefix(content);
        return this.updateSelectionChip(content, tooltipPrefix, null);
    }

    private String resolveSelectionContent(URL resource) {
        String content = SelectionAttachmentUtil.getContentQueryParam((URL)resource);
        if (content == null) {
            content = this.getSelectionChipContent();
        }
        if (content == null && this.currentSelectedEditorContentSupplier != null) {
            content = this.currentSelectedEditorContentSupplier.get();
        }
        if (content == null) {
            content = NO_SELECTION_PLACEHOLDER;
        }
        return content;
    }

    private String determineTooltipPrefix(String content) {
        if (NO_SELECTION_PLACEHOLDER.equals(content)) {
            return null;
        }
        if (this.currentSelectedEditorContentSupplier != null) {
            return I18N.getTranslation("Current_document_selection") + ":\n";
        }
        return I18N.getTranslation("Used_document_selection") + ":\n";
    }

    private boolean addResourceAttachment(URL resource) {
        boolean wasAttachmentAdded = false;
        if (!this.attachments.contains(resource)) {
            wasAttachmentAdded = this.attachments.add(resource);
            for (AttachmentsChangedListener listener : this.attachmentsChangedListeners) {
                listener.attachmentAdded(resource);
            }
            this.add(new AttachmentChip(resource, () -> this.removeAttachment(resource), this.attachments));
            this.revalidate();
            this.repaint();
        }
        return wasAttachmentAdded;
    }

    @Override
    public void removeAttachment(URL url) {
        this.attachmentsChangedListeners.forEach(l -> l.attachmentRemoved(url));
        if (this.attachments.remove(url)) {
            for (int i = 0; i < this.getComponentCount(); ++i) {
                AttachmentChip chip;
                if (!(this.getComponent(i) instanceof AttachmentChip) || !(chip = (AttachmentChip)this.getComponent(i)).getUrl().equals(url)) continue;
                this.remove(i);
                this.attachmentsChangedListeners.forEach(l -> l.attachmentRemoved(url));
                break;
            }
        }
        this.updateAttachButtonTextState();
    }

    @Override
    public void clearAttachments() {
        Collection<URL> attachmentsToRemove = this.getAttachments();
        this.attachments.clear();
        attachmentsToRemove.forEach(u -> this.attachmentsChangedListeners.forEach(listener -> listener.attachmentRemoved((URL)u)));
        Arrays.stream(this.getComponents()).filter(c -> c instanceof AttachmentChip && !(c instanceof SelectionChip)).forEach(t -> this.remove((Component)t));
        this.selectionChip.setSelectionChipTooltip(null, null);
        this.updateAttachButtonTextState();
        this.revalidate();
        this.repaint();
    }

    @Override
    public boolean hasAttachments() {
        return !this.attachments.isEmpty();
    }

    @Override
    public Collection<URL> getAttachments() {
        return new LinkedHashSet<URL>(this.attachments);
    }

    @Override
    public boolean updateSelectionChip(String selectedContent, String tooltipPrefix, String customName) {
        boolean wasAttachmentUpdated = false;
        Iterator<URL> iterator = this.attachments.iterator();
        while (iterator.hasNext()) {
            URL url = iterator.next();
            if (!SelectionAttachmentUtil.isSelectionURL((URL)url)) continue;
            iterator.remove();
            this.attachmentsChangedListeners.forEach(l -> l.attachmentAdded(url));
        }
        if (selectedContent != null && !selectedContent.isEmpty()) {
            URL selectionURL = SelectionAttachmentUtil.getSelectionURL();
            wasAttachmentUpdated = this.attachments.add(selectionURL);
            for (AttachmentsChangedListener listener : this.attachmentsChangedListeners) {
                listener.attachmentAdded(selectionURL);
            }
        }
        this.selectionChip.setSelectionChipTooltip(selectedContent, tooltipPrefix);
        this.selectionChip.setChipText(customName);
        if (this.referncesUpdater != null) {
            this.referncesUpdater.updateReferencesWhenSelectionChanges();
        }
        this.updateAttachButtonTextState();
        return wasAttachmentUpdated;
    }

    private void updateAttachButtonTextState() {
        this.attachFilesButton.putClientProperty("hideActionText", this.hasAttachments());
        this.revalidate();
        this.repaint();
    }

    private void updateAllChipsLabelText() {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            if (!(this.getComponent(i) instanceof AttachmentChip)) continue;
            AttachmentChip chip = (AttachmentChip)this.getComponent(i);
            chip.updateLabelText(this.attachFilesButton.getWidth());
        }
    }

    @Override
    public String getSelectionChipContent() {
        return this.selectionChip.getContent();
    }
}

