/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.plugin.chat.attachments;

import com.oxygenxml.positron.core.util.attach.SelectionAttachmentUtil;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.URLUtil;

public class AttachmentChipUtil {
    private static final Logger log = LoggerFactory.getLogger(AttachmentChipUtil.class);

    private AttachmentChipUtil() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static String extractFileName(URL resource, Collection<URL> attachments) {
        Object fileName;
        block6: {
            fileName = AttachmentChipUtil.extractSimpleFilenameInternal(resource);
            if (!SelectionAttachmentUtil.isSelectionURL((URL)resource) && attachments != null) {
                boolean isFirst = true;
                for (URL url : attachments) {
                    String otherFileName = AttachmentChipUtil.extractSimpleFilenameInternal(url);
                    if (!((String)fileName).equals(otherFileName)) continue;
                    if (resource.equals(url)) break;
                    isFirst = false;
                    break;
                }
                if (!isFirst) {
                    try {
                        Path parent = Paths.get(resource.toURI()).getParent();
                        if (parent != null) {
                            fileName = parent.getFileName() + "/" + (String)fileName;
                        }
                    }
                    catch (URISyntaxException e) {
                        if (!log.isDebugEnabled()) break block6;
                        log.debug((Object)e, (Throwable)e);
                    }
                }
            }
        }
        return fileName;
    }

    private static String extractSimpleFilenameInternal(URL resource) {
        String fileName = URLUtil.decodeURIComponent((String)URLUtil.extractFileName((URL)resource));
        if ("index.html".equals(fileName) && resource.getProtocol() != null && resource.getProtocol().startsWith("http")) {
            fileName = resource.getHost();
        }
        return fileName;
    }
}

